/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.DataStorage.Passives;

import com.cobbs.lordcraft.Passives.EPassive;
import com.cobbs.lordcraft.Passives.Passive;
import com.cobbs.lordcraft.Passives.TickingPassive;
import com.cobbs.lordcraft.Util.DataStorage.BasicSavedData;
import com.cobbs.lordcraft.Util.DataStorage.Passives.PassiveCollection;
import com.cobbs.lordcraft.Util.DataStorage.Passives.PassiveData;
import java.util.LinkedList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraftforge.event.TickEvent;

public class PassiveSavedData
extends BasicSavedData<PassiveCollection> {
    private static final String NAME = "lordcraft:passive";
    private LinkedList<EPassive> needUpdates = new LinkedList();

    public PassiveSavedData() {
        super(NAME);
    }

    public static PassiveSavedData get(ServerWorld world) {
        ServerWorld w = world.func_73046_m().func_71218_a(World.field_234918_g_);
        DimensionSavedDataManager storage = w.func_217481_x();
        return (PassiveSavedData)storage.func_215752_a(PassiveSavedData::new, NAME);
    }

    public static PassiveSavedData get(PlayerEntity player) {
        return PassiveSavedData.get((ServerWorld)player.func_130014_f_());
    }

    @Override
    public PassiveCollection createCollection(BasicSavedData store) {
        return new PassiveCollection(store);
    }

    public void tick(TickEvent.PlayerTickEvent event) {
        PlayerEntity p = event.player;
        String id = p.func_110124_au().toString();
        PassiveData d = (PassiveData)((PassiveCollection)this.data).get(id);
        ++d.ticker;
        boolean second = d.ticker == 20;
        for (EPassive e : d.states.keySet()) {
            Passive passive;
            if (d.states.get((Object)e) != 2 || !(passive = e.getPassive()).canTick() || !((TickingPassive)passive).tick(event, p, id, d, this, second)) continue;
            this.needUpdates.add(e);
        }
        if (second) {
            d.ticker -= 20;
        }
        this.func_76185_a();
        for (EPassive e : this.needUpdates) {
            this.markDataForSync((ServerPlayerEntity)p, e);
        }
        this.needUpdates.clear();
    }

    public void markDataForSync(ServerPlayerEntity player, EPassive passive) {
        ((PassiveCollection)this.data).syncToClient(player, passive);
    }

    public void activate(PlayerEntity player, EPassive passive) {
        PassiveData passiveData = (PassiveData)((PassiveCollection)this.data).get(player.func_110124_au().toString());
        if (passive.getPassive().canEnable(passiveData) && passiveData.getState(passive) != 2) {
            passiveData.setState(passive, 2);
            passive.getPassive().onActivate(this, passiveData, player);
        }
    }

    public void deActivate(PlayerEntity player, EPassive passive) {
        PassiveData passiveData = (PassiveData)((PassiveCollection)this.data).get(player.func_110124_au().toString());
        if (passiveData.getState(passive) == 2) {
            passiveData.setState(passive, 1);
            passive.getPassive().onDeactivate(this, passiveData, player);
        }
    }
}

