/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.DataStorage.Research;

import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.Research.EResearchState;
import com.cobbs.lordcraft.Util.DataStorage.BasicData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;

public class ResearchData
extends BasicData {
    public Map<EResearch, EResearchState> states;

    public ResearchData() {
        this.states = new HashMap<EResearch, EResearchState>();
    }

    public ResearchData(CompoundNBT nbt) {
        super(nbt);
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT nbt = new CompoundNBT();
        for (EResearch p : this.states.keySet()) {
            nbt.func_74768_a("" + p.ordinal(), this.states.get((Object)p).ordinal());
        }
        return nbt;
    }

    @Override
    public void deserialize(CompoundNBT nbt) {
        this.states = new HashMap<EResearch, EResearchState>();
        for (EResearch p : EResearch.values()) {
            String key = "" + p.ordinal();
            if (!nbt.func_74764_b(key)) continue;
            this.states.put(p, EResearchState.values()[nbt.func_74762_e(key)]);
        }
        this.validateResearch();
    }

    public EResearchState getState(EResearch research) {
        if (this.states.containsKey((Object)research)) {
            return this.states.get((Object)research);
        }
        return research.defaultState;
    }

    public boolean has(EResearch passive) {
        return this.getState(passive) == EResearchState.COMPLETE;
    }

    public void setState(EResearch research, EResearchState val) {
        this.states.put(research, val);
        if (val == EResearchState.COMPLETE) {
            this.validateResearch(research);
        }
    }

    public void validateResearch() {
        for (EResearch r : EResearch.values()) {
            if (this.getState(r).equals((Object)EResearchState.COMPLETE) || this.getState(r).equals((Object)EResearchState.LOCKED) || this.getState(r).equals((Object)EResearchState.VERY_HIDDEN) || r.getInstance().requirements.isEmpty()) continue;
            int reqs = 0;
            for (EResearch res : r.getInstance().requirements) {
                if (!this.getState(res).equals((Object)EResearchState.COMPLETE)) continue;
                ++reqs;
            }
            if (reqs == r.getInstance().requirements.size()) {
                this.setState(r, EResearchState.NORMAL);
                continue;
            }
            if (reqs == 0) continue;
            this.setState(r, EResearchState.REQUIRES);
        }
    }

    public void validateResearch(EResearch research) {
        for (EResearch res : research.getInstance().locked) {
            if (!this.getState(res).equals((Object)EResearchState.COMPLETE)) continue;
            this.setState(research, EResearchState.LOCKED);
            break;
        }
        this.validateResearch();
    }
}

