/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util;

import com.cobbs.lordcraft.LordCraft;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import net.minecraft.particles.BasicParticleType;

public enum EElement {
    WATER,
    EARTH,
    FIRE,
    AIR,
    LIGHT,
    DARK,
    ENERGY;


    public String getUnlocalName() {
        return ModHelper.concat("lordcraft.element.", this.ordinal());
    }

    public String getTextColor() {
        switch (this) {
            case WATER: {
                return "\u00a79";
            }
            case EARTH: {
                return "\u00a76";
            }
            case FIRE: {
                return "\u00a7c";
            }
            case AIR: {
                return "\u00a7e";
            }
            case LIGHT: {
                return "\u00a7f\u00a7l";
            }
            case DARK: {
                return "\u00a78";
            }
            case ENERGY: {
                return "\u00a7b";
            }
        }
        return "";
    }

    public char getTextColorCode() {
        switch (this) {
            case WATER: {
                return '9';
            }
            case EARTH: {
                return '6';
            }
            case FIRE: {
                return 'c';
            }
            case AIR: {
                return 'e';
            }
            case LIGHT: {
                return 'f';
            }
            case DARK: {
                return '8';
            }
            case ENERGY: {
                return 'b';
            }
        }
        return 'f';
    }

    public char getTextColorCode2() {
        switch (this) {
            case DARK: {
                return 'd';
            }
        }
        return this.getTextColorCode();
    }

    public static String getTextColor(EElement element) {
        if (element == null) {
            return "";
        }
        return element.getTextColor();
    }

    public static char getTextColorCode(EElement element) {
        if (element == null) {
            return 'f';
        }
        return element.getTextColorCode();
    }

    public static BasicParticleType getParticleType(EElement element) {
        if (element == null) {
            return LordCraft.proxy.spellParticleData;
        }
        switch (element) {
            case WATER: {
                return LordCraft.proxy.waterSpellParticleData;
            }
            case EARTH: {
                return LordCraft.proxy.earthSpellParticleData;
            }
            case FIRE: {
                return LordCraft.proxy.fireSpellParticleData;
            }
            case AIR: {
                return LordCraft.proxy.airSpellParticleData;
            }
            case LIGHT: {
                return LordCraft.proxy.lightSpellParticleData;
            }
            case DARK: {
                return LordCraft.proxy.darkSpellParticleData;
            }
            case ENERGY: {
                return LordCraft.proxy.energySpellParticleData;
            }
        }
        return LordCraft.proxy.spellParticleData;
    }
}

