/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.Entities;

import com.cobbs.lordcraft.Spells.SpellContainer;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class SpellArrow
extends ArrowEntity
implements IEntityAdditionalSpawnData {
    private SpellContainer container = null;

    public SpellArrow(EntityType<SpellArrow> type, World world) {
        super(type, world);
    }

    public SpellArrow(World worldIn, double x, double y, double z, SpellContainer container) {
        super(worldIn, x, y, z);
        this.container = container;
    }

    public SpellArrow(World worldIn, LivingEntity shooter, SpellContainer container) {
        super(worldIn, shooter);
        this.container = container;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        String s = this.container.serialise().toString();
        for (char c : s.toCharArray()) {
            buffer.writeChar((int)c);
        }
    }

    public void readSpawnData(PacketBuffer additionalData) {
        StringBuilder builder = new StringBuilder();
        try {
            while (true) {
                builder.append(additionalData.readChar());
            }
        }
        catch (Exception e) {
            try {
                this.container = SpellContainer.createFromNbt(JsonToNBT.func_180713_a((String)builder.toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    public SpellArrow(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public SpellArrow(World worldIn, LivingEntity shooter) {
        super(worldIn, shooter);
    }

    protected void func_70227_a(RayTraceResult raytraceResultIn) {
        Entity e;
        super.func_70227_a(raytraceResultIn);
        if (this.container != null && (e = this.func_234616_v_()) instanceof PlayerEntity) {
            PlayerEntity p = (PlayerEntity)e;
            if (raytraceResultIn instanceof EntityRayTraceResult) {
                EntityRayTraceResult result = (EntityRayTraceResult)raytraceResultIn;
                Entity target = result.func_216348_a();
                if (target instanceof LivingEntity && ModHelper.isServerWorld(this.field_70170_p) && ModHelper.isPlayerReal(p) && this.container.canCast(p, false)) {
                    this.container.getSpell().cast(p, (LivingEntity)target, this.container.spellMod, this.container.effectivePotency(0, false));
                    this.container.drainCost(p, false);
                }
            } else if (raytraceResultIn instanceof BlockRayTraceResult && this.field_70254_i) {
                BlockRayTraceResult result = (BlockRayTraceResult)raytraceResultIn;
                BlockPos pos = result.func_216350_a();
                if (ModHelper.isServerWorld(this.field_70170_p) && ModHelper.isPlayerReal(p) && this.container.canCast(p, false)) {
                    this.container.getSpell().cast(p, pos, result.func_216354_b(), this.container.spellMod, this.container.effectivePotency(0, false));
                    this.container.drainCost(p, false);
                }
            }
        }
    }
}

