/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.Entities;

import com.cobbs.lordcraft.Entries.Entities;
import com.cobbs.lordcraft.Entries.ModItems;
import com.cobbs.lordcraft.Spells.ESpell;
import com.cobbs.lordcraft.Spells.ESpellFocus;
import com.cobbs.lordcraft.Spells.SpellContainer;
import com.cobbs.lordcraft.Util.Damage.DamageSourceElemental;
import com.cobbs.lordcraft.Util.EElement;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class SpellProjectile
extends ProjectileItemEntity
implements IEntityAdditionalSpawnData {
    private static AxisAlignedBB gravityBox = new AxisAlignedBB(-5.0, -5.0, -5.0, 5.0, 5.0, 5.0);
    public SpellContainer container = null;
    private double ranged = 1.0;
    private double potency;
    private boolean lobbing = false;
    public double r = 0.0;
    public double g = 0.0;
    public double b = 0.0;

    public SpellProjectile(World p_i50159_2_) {
        super(Entities.SPELL_PROJECTILE_ENTITY, p_i50159_2_);
    }

    public SpellProjectile(World worldIn, LivingEntity throwerIn, SpellContainer container, double potency) {
        super(Entities.SPELL_PROJECTILE_ENTITY, throwerIn, worldIn);
        this.setSpellContainer(container);
        this.potency = potency;
    }

    public SpellProjectile(World worldIn, double x, double y, double z) {
        super(Entities.SPELL_PROJECTILE_ENTITY, x, y, z, worldIn);
    }

    public SpellProjectile(EntityType<SpellProjectile> spellProjectileEntityType, World world) {
        super(spellProjectileEntityType, world);
    }

    private void setSpellContainer(SpellContainer container) {
        this.container = container;
        this.ranged = container.sliderVal;
        this.lobbing = container.modifier;
        Color c = container.getSpell().color;
        this.r = (double)c.getRed() / 255.0;
        this.g = (double)c.getGreen() / 255.0;
        this.b = (double)c.getBlue() / 255.0;
    }

    protected void func_70227_a(RayTraceResult result) {
        boolean flag;
        Entity e = this.func_234616_v_();
        if (e != null && this.container != null) {
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                EntityRayTraceResult eResult = (EntityRayTraceResult)result;
                this.container.getSpell().cast((PlayerEntity)e, eResult.func_216348_a(), this.container.spellMod, this.potency);
            } else if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockRayTraceResult bResult = (BlockRayTraceResult)result;
                this.container.getSpell().cast((PlayerEntity)e, bResult.func_216350_a(), bResult.func_216354_b(), this.container.spellMod, this.potency);
            }
        }
        boolean bl = flag = this.container.spell != ESpell.GRAVITY_WELL;
        if (this.container != null && flag) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)3);
                this.func_70106_y();
            }
        } else {
            this.func_213317_d(new Vector3d(0.0, 0.0, 0.0));
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        String s = this.container.serialise().toString();
        buffer.writeDouble(this.potency);
        for (char c : s.toCharArray()) {
            buffer.writeChar((int)c);
        }
    }

    public void readSpawnData(PacketBuffer additionalData) {
        StringBuilder builder = new StringBuilder();
        this.potency = additionalData.readDouble();
        try {
            while (true) {
                builder.append(additionalData.readChar());
            }
        }
        catch (Exception e) {
            try {
                this.setSpellContainer(SpellContainer.createFromNbt(JsonToNBT.func_180713_a((String)builder.toString())));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    protected Item func_213885_i() {
        if (this.container != null) {
            switch (this.container.spell.element) {
                case WATER: {
                    return Items.field_205158_fa;
                }
                case EARTH: {
                    return Items.field_151174_bG;
                }
                case FIRE: {
                    return Items.field_151059_bz;
                }
                case AIR: {
                    return Items.field_151008_G;
                }
                case LIGHT: {
                    return Items.field_196106_bc;
                }
                case DARK: {
                    return Items.field_151044_h;
                }
                case ENERGY: {
                    return Items.field_179563_cD;
                }
            }
        }
        return ModItems.DUST_BASIC;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("lord:spell", (INBT)this.container.serialise());
        compound.func_74780_a("potency", this.potency);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSpellContainer(SpellContainer.createFromNbt(compound.func_74775_l("lord:spell")));
        this.potency = compound.func_74769_h("potency");
    }

    public boolean func_189652_ae() {
        if (this.container != null) {
            return !this.lobbing;
        }
        return super.func_189652_ae();
    }

    protected float func_70185_h() {
        if (this.container != null) {
            return this.lobbing ? super.func_70185_h() : 0.0f;
        }
        return super.func_70185_h();
    }

    public void func_70071_h_() {
        if (this.field_70173_aa >= 400 || this.container == null) {
            this.func_70106_y();
        }
        if (this.container != null) {
            if (this.field_70170_p.field_72995_K) {
                if (this.field_70173_aa > 0 && this.field_70173_aa % 3 == 0) {
                    int max = 2;
                    if (this.container.sliderVal < 2.0) {
                        max = 4;
                    }
                    for (int i = 0; i < max; ++i) {
                        Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)EElement.getParticleType(this.container.spell.element), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.r, this.g, this.b);
                    }
                }
            } else {
                PlayerEntity caster;
                if (this.container.spell == ESpell.GRAVITY_WELL && this.func_234616_v_() != null) {
                    caster = (PlayerEntity)this.func_234616_v_();
                    double pScale = 2.0 + this.potency;
                    for (LivingEntity t : this.field_70170_p.func_217357_a(LivingEntity.class, gravityBox.func_186662_g(pScale).func_186670_a(this.func_233580_cy_()))) {
                        Vector3d vec = t.func_213303_ch();
                        vec = vec.func_72444_a(this.func_213303_ch()).func_72432_b();
                        int mod = 8;
                        if (!t.equals((Object)caster)) {
                            t.func_70097_a((DamageSource)DamageSourceElemental.EARTHDAMAGE.from((Entity)caster), (float)this.potency);
                        }
                        if (t instanceof PlayerEntity) {
                            if (!t.func_130014_f_().func_73046_m().func_71219_W() || !t.func_225608_bj_()) continue;
                            t.func_70024_g(vec.field_72450_a / (double)mod, vec.field_72448_b / (double)mod, vec.field_72449_c / (double)mod);
                            ((ServerPlayerEntity)t).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)t));
                            continue;
                        }
                        t.func_70024_g(vec.field_72450_a / (double)mod, vec.field_72448_b / (double)mod, vec.field_72449_c / (double)mod);
                    }
                    this.field_70173_aa += 7;
                }
                if (this.container.focus == ESpellFocus.CASCADE && this.func_234616_v_() != null) {
                    caster = (PlayerEntity)this.func_234616_v_();
                    for (Entity e : caster.field_70170_p.func_72839_b((Entity)caster, new AxisAlignedBB(-6.0, -6.0, -6.0, 6.0, 6.0, 6.0).func_191194_a(this.func_213303_ch()))) {
                        if (!(e instanceof LivingEntity) || e instanceof PlayerEntity) continue;
                        this.container.getSpell().cast(caster, e, this.container.spellMod, this.potency);
                    }
                }
            }
        }
        super.func_70071_h_();
    }

    public void func_70103_a(byte id) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

