/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.Events;

import com.cobbs.lordcraft.Blocks.PlayerInterface.PlayerInterfaceBlock;
import com.cobbs.lordcraft.Blocks.PlayerInterface.PlayerInterfaceTE;
import com.cobbs.lordcraft.Items.ArtifactItem;
import com.cobbs.lordcraft.Items.Artifacts.ArtifactFireAir;
import com.cobbs.lordcraft.Items.Tools.IElementalTool;
import com.cobbs.lordcraft.MainClass;
import com.cobbs.lordcraft.Passives.Abilities.IHasModifier;
import com.cobbs.lordcraft.Passives.EPassive;
import com.cobbs.lordcraft.Passives.Passive;
import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.Util.Client.ClientData;
import com.cobbs.lordcraft.Util.Commands.PipCommand;
import com.cobbs.lordcraft.Util.Commands.ResearchCommand;
import com.cobbs.lordcraft.Util.DataStorage.Lordic.LordicCollection;
import com.cobbs.lordcraft.Util.DataStorage.Lordic.LordicData;
import com.cobbs.lordcraft.Util.DataStorage.Lordic.LordicSavedData;
import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaCollection;
import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaSavedData;
import com.cobbs.lordcraft.Util.DataStorage.Objectives.EObjective;
import com.cobbs.lordcraft.Util.DataStorage.Objectives.ObjectivesCollection;
import com.cobbs.lordcraft.Util.DataStorage.Objectives.ObjectivesSavedData;
import com.cobbs.lordcraft.Util.DataStorage.Passives.PassiveCollection;
import com.cobbs.lordcraft.Util.DataStorage.Passives.PassiveData;
import com.cobbs.lordcraft.Util.DataStorage.Passives.PassiveSavedData;
import com.cobbs.lordcraft.Util.DataStorage.Research.ResearchCollection;
import com.cobbs.lordcraft.Util.DataStorage.Research.ResearchSavedData;
import com.cobbs.lordcraft.Util.EElement;
import com.cobbs.lordcraft.Util.EShadowKey;
import com.cobbs.lordcraft.Util.Helpers.DataStorageHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.WorldGen.OreEntry;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lordcraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModEvents {
    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isServer()) {
            PlayerEntity player = event.player;
            ManaSavedData.get(player).tick(event);
            PassiveSavedData.get(player).tick(event);
            ItemStack stack = player.func_184607_cu();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ShieldItem && player.func_184605_cv() == 72000) {
                ArtifactFireAir.shieldBlast(player);
            }
        }
    }

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent event) {
        String s = event.getName().toString();
        if (s.equals("minecraft:chests/simple_dungeon") || s.equals("minecraft:chests/abandoned_mineshaft")) {
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("lordcraft:inject/scraps"))).func_216044_b());
        }
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        if (event.getCategory() != Biome.Category.THEEND && event.getCategory() != Biome.Category.NETHER) {
            for (OreEntry o : OreEntry.ores) {
                if (!o.enabled) continue;
                event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, o.state, o.perCluster)).func_242733_d(o.max)).func_242728_a()).func_242731_b(o.perChunk));
            }
        }
    }

    @SubscribeEvent
    public static void playerJoinServer(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            PassiveSavedData pStore = PassiveSavedData.get((ServerWorld)event.getPlayer().func_130014_f_());
            ((PassiveCollection)pStore.data).syncToClient((ServerPlayerEntity)event.getPlayer());
            ResearchSavedData rStore = ResearchSavedData.get((ServerWorld)event.getPlayer().func_130014_f_());
            ((ResearchCollection)rStore.data).syncToClient((ServerPlayerEntity)event.getPlayer());
            ObjectivesSavedData oStore = ObjectivesSavedData.get((ServerWorld)event.getPlayer().func_130014_f_());
            ((ObjectivesCollection)oStore.data).syncToClient((ServerPlayerEntity)event.getPlayer());
            LordicSavedData lStore = LordicSavedData.get((ServerWorld)event.getPlayer().func_130014_f_());
            ((LordicCollection)lStore.data).syncToClient((ServerPlayerEntity)event.getPlayer());
            ManaSavedData mStore = ManaSavedData.get((ServerWorld)event.getPlayer().func_130014_f_());
            ((ManaCollection)mStore.data).syncToClient((ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void entityLeavesWorld(EntityLeaveWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            for (EShadowKey key : EShadowKey.values()) {
                key.cleanupPlayer((PlayerEntity)event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public static void playerRespawns(PlayerEvent.PlayerRespawnEvent event) {
        World world;
        PlayerEntity player = event.getPlayer();
        if (ModHelper.isPlayerReal(player) && ModHelper.isServerWorld(world = event.getEntityLiving().field_70170_p)) {
            PassiveSavedData passiveSavedData = PassiveSavedData.get((ServerWorld)world);
            PassiveData pData = (PassiveData)((PassiveCollection)passiveSavedData.data).get(event.getEntity().func_110124_au().toString());
            LordicSavedData lordicSavedData = LordicSavedData.get((ServerWorld)world);
            LordicData lData = (LordicData)((LordicCollection)lordicSavedData.data).get(event.getEntity().func_110124_au().toString());
            for (EPassive passive : EPassive.values()) {
                Passive p = passive.getPassive();
                if (!(p instanceof IHasModifier) || !pData.has(passive)) continue;
                p.onDeactivate(passiveSavedData, pData, player);
                p.onActivate(passiveSavedData, pData, player);
            }
            DataStorageHelper.updateLegacyState(player, lData.legacy, lData.legacyLevel);
        }
    }

    @SubscribeEvent
    public static void blockProtection(BlockEvent.BreakEvent event) {
        BlockState state = event.getState();
        if (state.func_177230_c() instanceof PlayerInterfaceBlock) {
            if (ModHelper.isPlayerReal(event.getPlayer())) {
                BlockPos pos = event.getPos();
                IWorld world = event.getWorld();
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof PlayerInterfaceTE && !((PlayerInterfaceTE)te).canBreak(event.getPlayer())) {
                    event.setCanceled(true);
                }
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        PipCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        ResearchCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void fallEvent(LivingFallEvent event) {
        World world = event.getEntity().field_70170_p;
        if (ModHelper.isServerWorld(world) && event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            for (Hand h : Hand.values()) {
                ItemStack stack = player.func_184586_b(h);
                if (stack.func_190926_b()) continue;
                Item item = stack.func_77973_b();
                if (item instanceof IElementalTool && ((IElementalTool)item).getElement() == EElement.AIR) {
                    if (!DataStorageHelper.hasResearch(player, EResearch.CRYSTAL_TOOLS)) continue;
                    event.setDamageMultiplier(0.0f);
                    DataStorageHelper.incrementObjective(player, EObjective.AIR_TOOL);
                    break;
                }
                if (!(item instanceof ArtifactItem) || ((ArtifactItem)item).element != EElement.AIR || !DataStorageHelper.hasResearch(player, EResearch.AIR_ARTIFACT)) continue;
                event.setDamageMultiplier(0.0f);
                break;
            }
            PassiveSavedData passiveSavedData = PassiveSavedData.get((ServerWorld)world);
            PassiveData data = (PassiveData)((PassiveCollection)passiveSavedData.data).get(event.getEntity().func_110124_au().toString());
            if (data.getState(EPassive.FALL_RESIST) == 2) {
                event.setDamageMultiplier(event.getDamageMultiplier() * 0.25f);
            }
        }
    }

    @SubscribeEvent
    public static void hurtEvent(LivingHurtEvent event) {
        World world = event.getEntity().field_70170_p;
        if (ModHelper.isServerWorld(world)) {
            PassiveData data;
            PassiveSavedData savedData;
            PlayerEntity player;
            if (event.getSource().func_76346_g() instanceof PlayerEntity) {
                player = (PlayerEntity)event.getSource().func_76346_g();
                savedData = PassiveSavedData.get(player);
                data = (PassiveData)((PassiveCollection)savedData.data).get(player);
                if (player.func_70090_H() && data.has(EPassive.WATER_STRIKE)) {
                    event.setAmount(event.getAmount() * 1.5f);
                }
                if (data.has(EPassive.FROST_TOUCH)) {
                    event.getEntityLiving().func_195064_c(new EffectInstance((Effect)MainClass.frostbite, 100, 0));
                }
            }
            if (event.getEntity() instanceof PlayerEntity) {
                player = (PlayerEntity)event.getEntity();
                if (event.getSource().func_76346_g() != null) {
                    savedData = PassiveSavedData.get(player);
                    data = (PassiveData)((PassiveCollection)savedData.data).get(player);
                    if (data.has(EPassive.FLAME_RETALIATION)) {
                        event.getSource().func_76346_g().func_70015_d(10);
                    }
                }
                if (event.getSource().func_76347_k()) {
                    savedData = PassiveSavedData.get(player);
                    data = (PassiveData)((PassiveCollection)savedData.data).get(player);
                    if (data.has(EPassive.FIRE_PROOF)) {
                        event.setAmount(0.0f);
                    } else {
                        for (Hand h : Hand.values()) {
                            Item item;
                            ItemStack stack = player.func_184586_b(h);
                            if (stack.func_190926_b() || !((item = stack.func_77973_b()) instanceof ArtifactItem) || ((ArtifactItem)item).element != EElement.FIRE || !DataStorageHelper.hasResearch(player, EResearch.FIRE_ARTIFACT)) continue;
                            event.setAmount(0.0f);
                            break;
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        if (ModHelper.isServerWorld(player.field_70170_p)) {
            if (ModHelper.isPlayerReal(player)) {
                PassiveSavedData savedData = PassiveSavedData.get(player);
                PassiveData data = (PassiveData)((PassiveCollection)savedData.data).get(player);
                float speed = event.getOriginalSpeed();
                if (data.has(EPassive.AQUA_AFFINITY) && player.func_70090_H()) {
                    speed *= 5.0f;
                }
                if (data.has(EPassive.MINING)) {
                    speed *= 2.0f;
                }
                event.setNewSpeed(speed);
            }
        } else {
            PassiveData data = ClientData.passiveData;
            float speed = event.getOriginalSpeed();
            if (data.has(EPassive.AQUA_AFFINITY) && player.func_70090_H()) {
                speed *= 5.0f;
            }
            if (data.has(EPassive.MINING)) {
                speed *= 2.0f;
            }
            event.setNewSpeed(speed);
        }
    }

    @SubscribeEvent
    public static void attackEvent(LivingAttackEvent event) {
        Entity e;
        World world = event.getEntity().field_70170_p;
        if (ModHelper.isServerWorld(world) && (e = event.getSource().func_76346_g()) instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)e;
            PassiveSavedData savedData = PassiveSavedData.get(player);
            PassiveData data = (PassiveData)((PassiveCollection)savedData.data).get(player);
            if (data.has(EPassive.FLAME_TOUCH)) {
                event.getEntityLiving().func_70015_d(10);
            }
            LordicSavedData lordicSavedData = LordicSavedData.get(player);
            LordicData lordicData = (LordicData)((LordicCollection)lordicSavedData.data).get(player);
            if (lordicData.legacy == 3) {
                if (event.getEntityLiving() instanceof AnimalEntity) {
                    double percentDone = Math.min(1.0f, event.getAmount() / event.getEntityLiving().func_110138_aP());
                    DataStorageHelper.changeMana(player, (int)(percentDone * 2000.0));
                } else if (lordicData.legacyLevel > 0 && event.getEntityLiving() instanceof MonsterEntity) {
                    double percentDone = Math.min(1.0f, event.getAmount() / event.getEntityLiving().func_110138_aP());
                    DataStorageHelper.changeMana(player, (int)(percentDone * 2000.0));
                }
            }
        }
    }
}

