/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.Helpers;

import com.cobbs.lordcraft.Items.Armor.MageRobes;
import com.cobbs.lordcraft.Items.SpellCasting.StaffItem;
import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.Spells.ESpell;
import com.cobbs.lordcraft.Spells.ESpellFocus;
import com.cobbs.lordcraft.Util.Client.ClientData;
import com.cobbs.lordcraft.Util.DataStorage.Lordic.LordicData;
import com.cobbs.lordcraft.Util.EElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.ItemStack;

public class ClientDataStorageHelper {
    public static int getManaCost(int original, EElement element) {
        return (int)((double)original * ClientDataStorageHelper.getDiscountMultiplier(element));
    }

    public static double getDiscountMultiplier(EElement element) {
        LordicData data = ClientData.lordicData;
        double multi = 1.0;
        if (data.legacy == 1) {
            multi -= 0.1;
            if (data.legacyLevel > 0) {
                multi -= 0.05;
                if (data.legacyLevel > 1) {
                    multi -= 0.05;
                }
            }
        }
        if (element != null) {
            if (element.ordinal() == data.primaryElement) {
                multi -= 0.25;
            }
            switch (element) {
                case WATER: {
                    if (!data.water_master) break;
                    multi -= 0.1;
                    break;
                }
                case EARTH: {
                    if (!data.earth_master) break;
                    multi -= 0.1;
                    break;
                }
                case FIRE: {
                    if (!data.fire_master) break;
                    multi -= 0.1;
                    break;
                }
                case AIR: {
                    if (!data.air_master) break;
                    multi -= 0.1;
                    break;
                }
                case LIGHT: {
                    if (!data.light_master) break;
                    multi -= 0.1;
                    break;
                }
                case DARK: {
                    if (!data.dark_master) break;
                    multi -= 0.1;
                }
            }
        }
        int count = 0;
        int lastE = -1;
        for (ItemStack stack : Minecraft.func_71410_x().field_71439_g.func_184193_aE()) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof MageRobes)) continue;
            MageRobes robe = (MageRobes)stack.func_77973_b();
            if (lastE == -1 || lastE == robe.element.ordinal()) {
                lastE = robe.element.ordinal();
                ++count;
            }
            if (robe.element != element) continue;
            multi -= 0.05;
        }
        if (count == 4) {
            multi -= 0.1;
        }
        for (ItemStack stack : Minecraft.func_71410_x().field_71439_g.func_184214_aD()) {
            if (!(stack.func_77973_b() instanceof StaffItem) || ((StaffItem)stack.func_77973_b()).element != element) continue;
            multi -= 0.1;
            break;
        }
        return multi;
    }

    public static boolean canUseFocus(ESpellFocus focus) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184812_l_()) {
            return true;
        }
        switch (focus) {
            case PROJECTILE: {
                return ClientData.researchData.has(EResearch.FOCUS_PROJECTILE);
            }
            case AOE: {
                return ClientData.researchData.has(EResearch.FOCUS_AOE);
            }
            case ARC: {
                return ClientData.researchData.has(EResearch.FOCUS_ARC);
            }
            case CASCADE: {
                return ClientData.researchData.has(EResearch.FOCUS_CASCADE);
            }
            case CHANNELING: {
                return ClientData.researchData.has(EResearch.FOCUS_CHANNELING);
            }
            case CONE: {
                return ClientData.researchData.has(EResearch.FOCUS_CONE);
            }
            case SCATTER: {
                return ClientData.researchData.has(EResearch.FOCUS_SCATTER);
            }
            case TRINITY: {
                return ClientData.researchData.has(EResearch.FOCUS_TRINITY);
            }
            case SELF: 
            case TOUCH: {
                return true;
            }
        }
        return false;
    }

    public static boolean canUseSpell(ESpell spell) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184812_l_()) {
            return true;
        }
        switch (spell) {
            case HEAL: {
                return ClientData.researchData.has(EResearch.WATER_SPELL_UTIL);
            }
            case FREEZE: {
                return ClientData.researchData.has(EResearch.WATER_SPELL_COMBAT);
            }
            case DIG: {
                return ClientData.researchData.has(EResearch.EARTH_SPELL_UTIL);
            }
            case GRAVITY_WELL: {
                return ClientData.researchData.has(EResearch.EARTH_SPELL_COMBAT);
            }
            case REGEN: {
                return ClientData.researchData.has(EResearch.FIRE_SPELL_UTIL);
            }
            case FLAME: {
                return ClientData.researchData.has(EResearch.FIRE_SPELL_COMBAT);
            }
            case IMPULSE: {
                return ClientData.researchData.has(EResearch.AIR_SPELL_UTIL);
            }
            case LIFT: {
                return ClientData.researchData.has(EResearch.AIR_SPELL_COMBAT);
            }
            case BLIND: {
                return ClientData.researchData.has(EResearch.LIGHT_SPELL_UTIL);
            }
            case FLASH: {
                return ClientData.researchData.has(EResearch.LIGHT_SPELL_COMBAT);
            }
            case BLINK: {
                return ClientData.researchData.has(EResearch.DARK_SPELL_UTIL);
            }
            case DARK_DAMAGE: {
                return ClientData.researchData.has(EResearch.DARK_SPELL_COMBAT);
            }
            case KRONDAS: {
                return ClientData.researchData.has(EResearch.LEGACY_II) && ClientData.lordicData.legacy == 3;
            }
            case SPARKS: {
                return ClientData.researchData.has(EResearch.SPELL_CRAFTING);
            }
            case BOLT: {
                return ClientData.researchData.has(EResearch.BOLT_SPELL);
            }
        }
        return false;
    }
}

