/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.Helpers;

import java.awt.Color;
import net.minecraft.item.DyeColor;

public class ColorHelper {
    public static final int BLACK = new Color(48, 48, 48).getRGB();
    public static final int COLOURLESS = new Color(0, 0, 0, 0).getRGB();
    public static final int WHITE = Color.WHITE.getRGB();
    public static final int MAGMITE = new Color(0, 160, 255, 0).getRGB();
    public static final int RUNE_CRYSTAL_SELECT_BASIC = new Color(93, 93, 93).getRGB();
    public static final int RUNE_CRYSTAL_SELECT_ADVANCED = new Color(69, 99, 129).getRGB();
    public static final int RUNE_CRYSTAL_BASIC = new Color(62, 62, 62).getRGB();
    public static final int RUNE_CRYSTAL_ADVANCED = new Color(46, 66, 86).getRGB();
    public static final int[] ELEMENTALCOLOURS = new int[]{Color.GRAY.getRGB(), new Color(54, 66, 180).getRGB(), new Color(220, 110, 0).getRGB(), new Color(180, 40, 40).getRGB(), new Color(210, 210, 0).getRGB(), WHITE, BLACK, Color.CYAN.getRGB()};
    public static final int buttonHover1 = Color.YELLOW.getRGB();
    public static final int buttonHover2 = Color.ORANGE.getRGB();
    public static final int[] CONSTELLATION_COLORS = new int[]{Color.GRAY.getRGB(), new Color(59, 72, 245).getRGB(), new Color(255, 142, 0).getRGB(), new Color(245, 44, 44).getRGB(), new Color(255, 255, 0).getRGB(), WHITE, new Color(255, 0, 255).getRGB(), new Color(0, 255, 255).getRGB()};
    public static final float[][] tabColors = new float[][]{ColorHelper.rgbTo3f(new Color(0, 200, 0).getRGB()), ColorHelper.rgbTo3f(new Color(0, 200, 200).getRGB()), ColorHelper.rgbTo3f(new Color(200, 0, 200).getRGB()), ColorHelper.rgbTo3f(new Color(200, 0, 0).getRGB()), ColorHelper.rgbTo3f(new Color(240, 240, 0).getRGB()), ColorHelper.rgbTo3f(new Color(100, 40, 100).getRGB())};

    public static int colorMultiplier(int v) {
        switch (v) {
            case -1: {
                return COLOURLESS;
            }
            case 15: {
                return BLACK;
            }
        }
        return DyeColor.values()[v].getColorValue();
    }

    public static float[] rgbTo3f(int rgb) {
        Color c = new Color(rgb);
        float[] color = new float[]{c.getRed(), c.getGreen(), c.getBlue()};
        color[0] = color[0] / 255.0f;
        color[1] = color[1] / 255.0f;
        color[2] = color[2] / 255.0f;
        return color;
    }

    public static int interpolate(int c1, int c2, int prog, int maxProg) {
        return ColorHelper.interpolate(c1, c2, (double)prog / (double)maxProg);
    }

    public static int interpolate(int c1, int c2, double prog) {
        return ColorHelper.interpolate(new Color(c1), new Color(c2), prog).getRGB();
    }

    public static Color interpolate(Color c1, Color c2, double prog) {
        double fac1 = 1.0 - prog;
        int r = (int)((double)c1.getRed() * fac1 + (double)c2.getRed() * prog);
        int g = (int)((double)c1.getGreen() * fac1 + (double)c2.getGreen() * prog);
        int b = (int)((double)c1.getBlue() * fac1 + (double)c2.getBlue() * prog);
        return new Color(r, g, b);
    }
}

