/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.Helpers;

import com.cobbs.lordcraft.Items.Armor.MageRobes;
import com.cobbs.lordcraft.Items.SpellCasting.StaffItem;
import com.cobbs.lordcraft.MainClass;
import com.cobbs.lordcraft.Passives.EPassive;
import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.Research.EResearchState;
import com.cobbs.lordcraft.Util.DataStorage.Lordic.LordicCollection;
import com.cobbs.lordcraft.Util.DataStorage.Lordic.LordicData;
import com.cobbs.lordcraft.Util.DataStorage.Lordic.LordicSavedData;
import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaCollection;
import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaData;
import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaSavedData;
import com.cobbs.lordcraft.Util.DataStorage.Objectives.EObjective;
import com.cobbs.lordcraft.Util.DataStorage.Objectives.ObjectivesCollection;
import com.cobbs.lordcraft.Util.DataStorage.Objectives.ObjectivesData;
import com.cobbs.lordcraft.Util.DataStorage.Objectives.ObjectivesSavedData;
import com.cobbs.lordcraft.Util.DataStorage.Passives.PassiveCollection;
import com.cobbs.lordcraft.Util.DataStorage.Passives.PassiveData;
import com.cobbs.lordcraft.Util.DataStorage.Passives.PassiveSavedData;
import com.cobbs.lordcraft.Util.DataStorage.Research.ResearchCollection;
import com.cobbs.lordcraft.Util.DataStorage.Research.ResearchData;
import com.cobbs.lordcraft.Util.DataStorage.Research.ResearchSavedData;
import com.cobbs.lordcraft.Util.EElement;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class DataStorageHelper {
    public void setObjective(PlayerEntity player, EObjective objective, int val) {
        if (!player.func_130014_f_().field_72995_K) {
            ObjectivesSavedData savedData = ObjectivesSavedData.get(player);
            ObjectivesData data = (ObjectivesData)((ObjectivesCollection)savedData.data).get(player);
            data.objectives.set(objective.ordinal(), val);
            DataStorageHelper.processObjective(objective, player, val);
        }
    }

    public static void incrementObjective(PlayerEntity player, EObjective objective) {
        if (!player.func_130014_f_().field_72995_K) {
            ObjectivesSavedData savedData = ObjectivesSavedData.get(player);
            ObjectivesData data = (ObjectivesData)((ObjectivesCollection)savedData.data).get(player);
            int val = data.objectives.get(objective.ordinal());
            if (val < objective.max) {
                data.objectives.set(objective.ordinal(), ++val);
                savedData.cleanupAndSync(player);
                DataStorageHelper.processObjective(objective, player, val);
            }
        }
    }

    public static void processObjective(EObjective objective, PlayerEntity player, int val) {
        if (val >= objective.max) {
            objective.unlock.run(player);
        }
    }

    public static void unlockResearch(PlayerEntity player, EResearch ... researchs) {
        if (!player.func_130014_f_().field_72995_K) {
            ResearchSavedData savedData = ResearchSavedData.get(player);
            ResearchData data = (ResearchData)((ResearchCollection)savedData.data).get(player);
            for (EResearch research : researchs) {
                data.setState(research, EResearchState.COMPLETE);
                research.onUnlock(player);
            }
            savedData.func_76185_a();
            for (EResearch research : researchs) {
                savedData.markDataForSync((ServerPlayerEntity)player, research);
            }
        }
    }

    public static boolean hasResearch(PlayerEntity player, EResearch research) {
        if (!ModHelper.isPlayerReal(player)) {
            return false;
        }
        if (!player.func_130014_f_().field_72995_K) {
            if (player.func_184812_l_() || research == null) {
                return true;
            }
            ResearchSavedData savedData = ResearchSavedData.get(player);
            ResearchData data = (ResearchData)((ResearchCollection)savedData.data).get(player);
            return data.has(research);
        }
        return false;
    }

    public static void revealResearch(PlayerEntity player, EResearch ... researches) {
        ResearchSavedData savedData = ResearchSavedData.get(player);
        ResearchData data = (ResearchData)((ResearchCollection)savedData.data).get(player);
        for (EResearch research : researches) {
            if (data.getState(research) != EResearchState.VERY_HIDDEN) continue;
            data.setState(research, EResearchState.HIDDEN);
            data.validateResearch();
        }
        savedData.cleanupAndSync(player);
    }

    public static void revealPassives(PlayerEntity player, EPassive ... passives) {
        PassiveSavedData savedData = PassiveSavedData.get(player);
        PassiveData data = (PassiveData)((PassiveCollection)savedData.data).get(player);
        for (EPassive passive : passives) {
            data.setState(passive, 1);
        }
        savedData.cleanupAndSync(player);
    }

    public static boolean changeManaCapacity(PlayerEntity player, int amount) {
        boolean flag = false;
        ManaSavedData savedData = ManaSavedData.get(player);
        ManaData data = (ManaData)((ManaCollection)savedData.data).get(player);
        int old = data.maxMana;
        data.maxMana += amount;
        data.mana = Math.min(data.maxMana, data.mana);
        boolean bl = flag = old != data.maxMana;
        if (flag) {
            savedData.cleanupAndSync(player);
        }
        return flag;
    }

    public static boolean changeManaCapacity(String playerID, World world, int amount) {
        PlayerEntity e;
        boolean flag = false;
        ManaSavedData savedData = ManaSavedData.get((ServerWorld)world);
        ManaData data = (ManaData)((ManaCollection)savedData.data).get(playerID);
        int old = data.maxMana;
        data.maxMana += amount;
        data.mana = Math.min(data.maxMana, data.mana);
        boolean bl = flag = old != data.maxMana;
        if (flag && (e = world.func_217371_b(UUID.fromString(playerID))) != null) {
            savedData.cleanupAndSync(e);
        }
        return flag;
    }

    public static boolean changeMana(String playerID, World world, int amount) {
        PlayerEntity e;
        boolean flag = false;
        ManaSavedData savedData = ManaSavedData.get((ServerWorld)world);
        ManaData data = (ManaData)((ManaCollection)savedData.data).get(playerID);
        int old = data.mana;
        data.mana = Math.min(data.maxMana, data.mana += amount);
        boolean bl = flag = old != data.mana;
        if (flag && (e = world.func_217371_b(UUID.fromString(playerID))) != null) {
            savedData.cleanupAndSync(e);
        }
        return flag;
    }

    public static boolean changeMana(PlayerEntity player, int amount) {
        boolean flag = false;
        ManaSavedData savedData = ManaSavedData.get(player);
        ManaData data = (ManaData)((ManaCollection)savedData.data).get(player);
        int old = data.mana;
        data.mana = Math.min(data.maxMana, data.mana += amount);
        boolean bl = flag = old != data.mana;
        if (flag) {
            savedData.cleanupAndSync(player);
        }
        return flag;
    }

    public static int getManaCost(int original, EElement element, PlayerEntity player) {
        return (int)((double)original * DataStorageHelper.getDiscountMultiplier(element, player));
    }

    public static double getDiscountMultiplier(EElement element, PlayerEntity player) {
        LordicSavedData savedData = LordicSavedData.get(player);
        LordicData data = (LordicData)((LordicCollection)savedData.data).get(player);
        double multi = 1.0;
        if (data.legacy == 1) {
            multi -= 0.1;
            if (data.legacyLevel > 0) {
                multi -= 0.05;
                if (data.legacyLevel > 1) {
                    multi -= 0.05;
                }
            }
        }
        if (element != null) {
            if (element.ordinal() == data.primaryElement) {
                multi -= 0.25;
            }
            switch (element) {
                case WATER: {
                    if (!data.water_master) break;
                    multi -= 0.1;
                    break;
                }
                case EARTH: {
                    if (!data.earth_master) break;
                    multi -= 0.1;
                    break;
                }
                case FIRE: {
                    if (!data.fire_master) break;
                    multi -= 0.1;
                    break;
                }
                case AIR: {
                    if (!data.air_master) break;
                    multi -= 0.1;
                    break;
                }
                case LIGHT: {
                    if (!data.light_master) break;
                    multi -= 0.1;
                    break;
                }
                case DARK: {
                    if (!data.dark_master) break;
                    multi -= 0.1;
                }
            }
        }
        int count = 0;
        int lastE = -1;
        for (ItemStack stack : player.func_184193_aE()) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof MageRobes)) continue;
            MageRobes robe = (MageRobes)stack.func_77973_b();
            if (lastE == -1 || lastE == robe.element.ordinal()) {
                lastE = robe.element.ordinal();
                ++count;
            }
            if (robe.element != element) continue;
            multi -= 0.05;
        }
        if (count == 4) {
            multi -= 0.1;
        }
        for (ItemStack stack : player.func_184214_aD()) {
            if (!(stack.func_77973_b() instanceof StaffItem) || ((StaffItem)stack.func_77973_b()).element != element) continue;
            multi -= 0.1;
            break;
        }
        return multi;
    }

    public static boolean drainPips(PlayerEntity player, int pipCost, boolean simulate) {
        ManaSavedData savedData = ManaSavedData.get(player);
        ManaData data = (ManaData)((ManaCollection)savedData.data).get(player);
        if (data.pips >= pipCost) {
            if (!simulate) {
                data.pips -= pipCost;
                savedData.func_76185_a();
                ((ManaCollection)savedData.data).syncToClient((ServerPlayerEntity)player);
            }
            return true;
        }
        ModHelper.insufficientPips(player);
        return false;
    }

    public static boolean openEye(PlayerEntity player) {
        LordicSavedData savedData = LordicSavedData.get(player);
        LordicData data = (LordicData)((LordicCollection)savedData.data).get(player);
        if (data.openEye) {
            return false;
        }
        data.openEye = true;
        data.hud_visibility[3] = true;
        ModHelper.actionBarMessage(player, "lordcraft.open_eye");
        savedData.cleanupAndSync(player);
        return true;
    }

    public static void setLegacyLevel(PlayerEntity player, int level) {
        LordicSavedData savedData = LordicSavedData.get(player);
        LordicData data = (LordicData)((LordicCollection)savedData.data).get(player);
        data.legacyLevel = level;
        DataStorageHelper.updateLegacyState(player, data.legacy, data.legacyLevel);
        savedData.cleanupAndSync(player);
    }

    public static void setMastery(PlayerEntity player, EElement element) {
        LordicSavedData savedData = LordicSavedData.get(player);
        LordicData data = (LordicData)((LordicCollection)savedData.data).get(player);
        switch (element) {
            case WATER: {
                data.water_master = true;
                break;
            }
            case EARTH: {
                data.earth_master = true;
                break;
            }
            case FIRE: {
                data.fire_master = true;
                break;
            }
            case AIR: {
                data.air_master = true;
                break;
            }
            case LIGHT: {
                data.light_master = true;
                break;
            }
            case DARK: {
                data.dark_master = true;
            }
        }
        savedData.cleanupAndSync(player);
    }

    public static void setThelos(PlayerEntity player) {
        LordicSavedData savedData = LordicSavedData.get(player);
        LordicData data = (LordicData)((LordicCollection)savedData.data).get(player);
        data.thelos = true;
        savedData.cleanupAndSync(player);
    }

    public static void updateLegacyState(PlayerEntity player, int legacy, int level) {
        DataStorageHelper.removeLegacyModifiers(player);
        switch (legacy) {
            case 0: {
                player.func_110148_a(Attributes.field_233826_i_).func_233769_c_(new AttributeModifier(UUID.fromString(MainClass.idoricLegacyID0), "lordcraft:idoric0", 2.0, AttributeModifier.Operation.ADDITION));
                if (level <= 0) break;
                player.func_110148_a(Attributes.field_233826_i_).func_233769_c_(new AttributeModifier(UUID.fromString(MainClass.idoricLegacyID1), "lordcraft:idoric1", 2.0, AttributeModifier.Operation.ADDITION));
                if (level <= 1) break;
                player.func_110148_a(Attributes.field_233827_j_).func_233769_c_(new AttributeModifier(UUID.fromString(MainClass.idoricLegacyID2), "lordcraft:idoric2", 2.0, AttributeModifier.Operation.ADDITION));
                break;
            }
            case 2: {
                player.func_110148_a(Attributes.field_233823_f_).func_233769_c_(new AttributeModifier(UUID.fromString(MainClass.celestialLegacyID0), "lordcraft:celestial0", 1.0, AttributeModifier.Operation.ADDITION));
                if (level <= 0) break;
                player.func_110148_a(Attributes.field_233823_f_).func_233769_c_(new AttributeModifier(UUID.fromString(MainClass.celestialLegacyID1), "lordcraft:celestial1", 1.0, AttributeModifier.Operation.ADDITION));
                if (level <= 1) break;
                player.func_110148_a(Attributes.field_233825_h_).func_233769_c_(new AttributeModifier(UUID.fromString(MainClass.celestialLegacyID2), "lordcraft:celestial2", 1.5, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public static void removeLegacyModifiers(PlayerEntity player) {
        try {
            player.func_110148_a(Attributes.field_233826_i_).func_233770_c_(UUID.fromString(MainClass.idoricLegacyID0));
            player.func_110148_a(Attributes.field_233826_i_).func_233770_c_(UUID.fromString(MainClass.idoricLegacyID1));
            player.func_110148_a(Attributes.field_233827_j_).func_233770_c_(UUID.fromString(MainClass.idoricLegacyID2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            player.func_110148_a(Attributes.field_233823_f_).func_233770_c_(UUID.fromString(MainClass.celestialLegacyID0));
            player.func_110148_a(Attributes.field_233823_f_).func_233770_c_(UUID.fromString(MainClass.celestialLegacyID1));
            player.func_110148_a(Attributes.field_233825_h_).func_233770_c_(UUID.fromString(MainClass.celestialLegacyID2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

