/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.Helpers;

import com.cobbs.lordcraft.Entries.ModItems;
import com.cobbs.lordcraft.Particles.ParticleSpell;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class ModHelper {
    public static final int maxChargeValue = 1000;
    public static Random rand = new Random();
    public static final String flattenSymbol = "~";
    public static String[] oreNames = new String[]{"diamond", "magmite", "emerald", "platinum", "uranium", "yellorium", "titanium", "rutile", "gold", "resonating", "silicon", "silver", "lead", "osmium", "zinc", "nickel", "crystal", "glowstone", "redstone", "quartz", "lapis", "aluminium", "aluminum", "bauxite", "iron", "copper", "tin", "coal", "lava", "ore", "clay", "gravel", "sand", "stone", "grass", "dirt"};
    public static float particleRingAngle = (float)ModHelper.toRadian(18.0);

    public static <T> List<T> wrap(T ... objects) {
        ArrayList<T> list = new ArrayList<T>(objects.length);
        int max = objects.length;
        for (int i = 0; i < max; ++i) {
            list.add(objects[i]);
        }
        return list;
    }

    public static <T> List<T> wrapLinked(T ... objects) {
        LinkedList<T> list = new LinkedList<T>();
        int max = objects.length;
        for (int i = 0; i < max; ++i) {
            list.add(objects[i]);
        }
        return list;
    }

    public static IReorderingProcessor makeProcessor(String s1, Style formatting1, String s2, Style formatting2) {
        return IReorderingProcessor.func_242234_a((IReorderingProcessor)IReorderingProcessor.func_242239_a((String)s1, (Style)formatting1), (IReorderingProcessor)IReorderingProcessor.func_242239_a((String)s2, (Style)formatting2));
    }

    public static IReorderingProcessor makeProcessor(String s1, TextFormatting formatting1, String s2, TextFormatting formatting2) {
        return ModHelper.makeProcessor(s1, Style.field_240709_b_.func_240712_a_(formatting1), s2, Style.field_240709_b_.func_240712_a_(formatting2));
    }

    public static IReorderingProcessor makeProcessor(String s1, Style formatting1, String s2, TextFormatting formatting2) {
        return ModHelper.makeProcessor(s1, formatting1, s2, Style.field_240709_b_.func_240712_a_(formatting2));
    }

    public static IReorderingProcessor makeProcessor(String s1, TextFormatting formatting1, String s2, Style formatting2) {
        return ModHelper.makeProcessor(s1, Style.field_240709_b_.func_240712_a_(formatting1), s2, formatting2);
    }

    public static String concat(Object ... objects) {
        if (objects.length == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (Object o : objects) {
            b.append(o);
        }
        return b.toString();
    }

    public static String flatten(Object ... objects) {
        if (objects.length == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        int max = objects.length - 1;
        for (int i = 0; i < max; ++i) {
            b.append(objects[i]);
            b.append(flattenSymbol);
        }
        b.append(objects[max]);
        return b.toString();
    }

    public static String flatten(BlockPos p) {
        StringBuilder b = new StringBuilder();
        b.append(p.func_177958_n());
        b.append(flattenSymbol);
        b.append(p.func_177956_o());
        b.append(flattenSymbol);
        b.append(p.func_177952_p());
        return b.toString();
    }

    public static boolean isServerWorld(World world) {
        return world != null && !world.field_72995_K;
    }

    public static int boolToInt(boolean val) {
        return val ? 1 : 0;
    }

    public static boolean intToBool(int val) {
        return val == 1;
    }

    public static double toRadian(double degree) {
        return Math.PI * (degree / 180.0);
    }

    public static double toDegree(double radian) {
        return 180.0 * (radian / Math.PI);
    }

    public static int fortuneMultiplier(int level) {
        int percent = 100 / (level + 1);
        int val = rand.nextInt(100);
        for (int i = 1; i <= level + 1; ++i) {
            if ((val -= percent) >= 0) continue;
            return i;
        }
        return 1;
    }

    public static Advancement getAdvancement(MinecraftServer server, String id) {
        try {
            return server.func_191949_aK().func_192778_a(new ResourceLocation("lordcraft", ModHelper.concat(":", id)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void applyAdvancement(PlayerEntity p, String id) {
        if (!p.field_70170_p.field_72995_K) {
            try {
                ((ServerPlayerEntity)p).func_192039_O().func_192750_a(ModHelper.getAdvancement(p.func_184102_h(), id), "impossible");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void applyAdvancement2(PlayerEntity p, String id) {
        if (!p.field_70170_p.field_72995_K) {
            try {
                ((ServerPlayerEntity)p).func_192039_O().func_192750_a(ModHelper.getAdvancement(p.func_184102_h(), id), "impossible2");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean inscriptionCheckAndRemove(PlayerEntity player, int count) {
        if (count <= 0) {
            return true;
        }
        boolean flag = false;
        NonNullList inventory = player.field_71071_by.field_70462_a;
        LinkedList<Integer> index1 = new LinkedList<Integer>();
        LinkedList<Integer> index2 = new LinkedList<Integer>();
        int max = inventory.size();
        for (int i = 0; i < max; ++i) {
            ItemStack stack = (ItemStack)inventory.get(i);
            if (stack.func_190926_b() || !stack.func_77973_b().equals(ModItems.INSCRIPTION_TILE)) continue;
            int temp = count - stack.func_190916_E();
            if (temp >= 0) {
                index1.add(i);
                index2.add(stack.func_190916_E());
            } else {
                index1.add(i);
                index2.add(stack.func_190916_E() + temp);
            }
            count = temp;
        }
        boolean bl = flag = count <= 0;
        if (flag) {
            int j = 0;
            for (Integer i : index1) {
                ((ItemStack)inventory.get(i)).func_190918_g(((Integer)index2.get(j)).intValue());
                ++j;
            }
        }
        return flag;
    }

    public static void updateBlock(World worldIn, BlockState state, BlockPos pos) {
        worldIn.func_184138_a(pos, state, worldIn.func_180495_p(pos), 3);
        worldIn.func_175646_b(pos, worldIn.func_175625_s(pos));
    }

    public static void updateBlockFromTE(TileEntity te) {
        World world = te.func_145831_w();
        BlockPos pos = te.func_174877_v();
        BlockState state = world.func_180495_p(pos);
        ModHelper.updateBlock(world, state, pos);
    }

    public static void unlockResearchFeedbackMessage(PlayerEntity player) {
        ModHelper.actionBarMessage(player, "lordcraft.objective.unlock");
    }

    public static void missingResearch(PlayerEntity player) {
        ModHelper.actionBarMessage(player, "lordcraft.research.missing");
    }

    public static void insufficientMana(PlayerEntity player) {
        ModHelper.actionBarMessage(player, "lordcraft.insufficient.mana");
    }

    public static void insufficientLevels(PlayerEntity player) {
        ModHelper.actionBarMessage(player, "lordcraft.insufficient.levels");
    }

    public static void insufficientPips(PlayerEntity player) {
        ModHelper.actionBarMessage(player, "lordcraft.insufficient.pips");
    }

    public static void actionBarMessage(PlayerEntity player, String text) {
        player.func_146105_b((ITextComponent)new TranslationTextComponent(text), true);
    }

    public static void twoHandsNeeded(PlayerEntity player) {
        ModHelper.actionBarMessage(player, "lordcraft.casting.twohands");
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static void spawnParticleRing(BasicParticleType type, PlayerEntity player, double r, double g, double b) {
        double x = player.func_213303_ch().field_72450_a;
        double y = player.func_213303_ch().field_72448_b + 0.5;
        double z = player.func_213303_ch().field_72449_c;
        Vector3d moveVector = player.func_70040_Z();
        float i = -1.0f;
        while (i <= 1.0f) {
            double yAdjust = Math.sqrt(1.0 - Math.pow(i, 2.0));
            ParticleSpell proj1 = (ParticleSpell)Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)type, x + (double)i * Math.cos(player.field_70177_z), y + yAdjust, z + (double)i * Math.sin(player.field_70177_z), r, g, b);
            ParticleSpell proj2 = (ParticleSpell)Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)type, x + (double)i * Math.cos(player.field_70177_z), y - yAdjust, z + (double)i * Math.sin(player.field_70177_z), r, g, b);
            proj1.setVelocity(moveVector.field_72450_a * 2.0, moveVector.field_72448_b * 2.0, moveVector.field_72449_c * 2.0);
            proj2.setVelocity(moveVector.field_72450_a * 2.0, moveVector.field_72448_b * 2.0, moveVector.field_72449_c * 2.0);
            i = (float)((double)i + 0.5);
        }
    }

    public static void spawnAOEParticles(BasicParticleType type, PlayerEntity playerEntity, double speed, double r, double g, double b) {
        ModHelper.spawnAOEParticles(type, playerEntity.func_213303_ch().func_72441_c(0.0, 0.5, 0.0), speed, r, g, b);
    }

    public static void spawnAOEParticles(BasicParticleType type, Vector3d source, double speed, double r, double g, double b) {
        Vector3d motionVec = new Vector3d((double)(rand.nextFloat() * 0.05f), (double)(rand.nextFloat() * 0.05f), 1.0);
        for (int i = 0; i < 20; ++i) {
            for (int j = 0; j < 2; ++j) {
                ParticleSpell proj1 = (ParticleSpell)Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)type, source.func_82615_a(), source.func_82617_b(), source.func_82616_c(), r, g, b);
                motionVec = motionVec.func_178785_b((float)((double)i / 20.0 * Math.PI));
                proj1.setVelocity(motionVec.field_72450_a * speed, motionVec.field_72448_b * speed, motionVec.field_72449_c * speed);
            }
        }
    }

    public static void spawnFlatParticleRing(BasicParticleType type, LivingEntity entity, double speed) {
        Vector3d direction = new Vector3d(1.5, 0.0, 0.0);
        for (int i = 0; i < 20; ++i) {
            Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)type, entity.func_226277_ct_() + direction.field_72450_a, entity.func_226278_cu_() + direction.field_72448_b, entity.func_226281_cx_() + direction.field_72449_c, 0.0, speed, 0.0);
            direction = direction.func_178785_b(particleRingAngle);
        }
    }

    public static void spawnSpellFlatParticleRing(BasicParticleType type, LivingEntity entity, double speed, double r, double g, double b) {
        Vector3d direction = new Vector3d(1.5, 0.0, 0.0);
        for (int i = 0; i < 20; ++i) {
            ParticleSpell particle = (ParticleSpell)Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)type, entity.func_226277_ct_() + direction.field_72450_a, entity.func_226278_cu_() + direction.field_72448_b, entity.func_226281_cx_() + direction.field_72449_c, r, g, b);
            direction = direction.func_178785_b(particleRingAngle);
            particle.setVelocity(0.0, speed, 0.0);
        }
    }

    public static boolean listContainsAnyStack(List<ItemStack> items, Ingredient stack) {
        for (ItemStack s : items) {
            if (!stack.test(s)) continue;
            return true;
        }
        return false;
    }

    public static int listIndexIngredient(List<ItemStack> items, Ingredient stack) {
        int i = 0;
        for (ItemStack s : items) {
            if (stack.test(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String capitaliseFirst(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static int[] earthCheck(int[] values, BlockState state) {
        Block b = state.func_177230_c();
        int[] toReturn = values;
        String bName = b.func_149739_a().toLowerCase();
        String stackName = new ItemStack((IItemProvider)b, 1).func_200301_q().getString().toLowerCase();
        int max = oreNames.length;
        for (int x = 0; x < max; ++x) {
            if (!bName.contains(oreNames[x]) && !stackName.contains(oreNames[x])) continue;
            if (toReturn[0] >= x || toReturn[0] == -1) {
                if (toReturn[0] == x) break;
                toReturn[2] = toReturn[1];
                toReturn[1] = toReturn[0];
                toReturn[0] = x;
                break;
            }
            if (toReturn[1] >= x || toReturn[1] == -1) {
                if (toReturn[1] == x) break;
                toReturn[2] = toReturn[1];
                toReturn[1] = x;
                break;
            }
            if (toReturn[2] < x && toReturn[2] != -1) continue;
            toReturn[2] = x;
            break;
        }
        return toReturn;
    }

    public static boolean isPlayerReal(PlayerEntity player) {
        return player != null && !(player instanceof FakePlayer);
    }
}

