/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.Helpers;

import com.cobbs.lordcraft.Items.SpellCasting.CastingTool;
import com.cobbs.lordcraft.UI.IGui;
import com.cobbs.lordcraft.Util.Helpers.RenderCore;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import org.lwjgl.opengl.GL11;

public class RenderHelper {
    public static final ResourceLocation TEXTURE_BEAM = new ResourceLocation("lordcraft", "textures/effect/laser.png");

    public static void drawScaledRect(int x, int y, int width, int height, double zLevel, int textureX, int textureY, int texW, int texH) {
        float f = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderCore.addVertex((IVertexBuilder)bufferbuilder, x, y + height, zLevel, (float)textureX * f, (float)(textureY + texH) * f);
        RenderCore.addVertex((IVertexBuilder)bufferbuilder, x + width, y + height, zLevel, (float)(textureX + texW) * f, (float)(textureY + texH) * f);
        RenderCore.addVertex((IVertexBuilder)bufferbuilder, x + width, y, zLevel, (float)(textureX + texW) * f, (float)textureY * f);
        RenderCore.addVertex((IVertexBuilder)bufferbuilder, x, y, zLevel, (float)textureX * f, (float)textureY * f);
        tessellator.func_78381_a();
    }

    public static void drawRotatedScaledRect(int x1, int y1, int x2, int y2, double zLevel, int textureX, int textureY, int texW, int texH) {
        float f = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderCore.addVertex((IVertexBuilder)bufferbuilder, x1, y2, zLevel, (float)textureX * f, (float)(textureY + texH) * f);
        RenderCore.addVertex((IVertexBuilder)bufferbuilder, x2, y2, zLevel, (float)(textureX + texW) * f, (float)(textureY + texH) * f);
        RenderCore.addVertex((IVertexBuilder)bufferbuilder, x2, y1, zLevel, (float)(textureX + texW) * f, (float)textureY * f);
        RenderCore.addVertex((IVertexBuilder)bufferbuilder, x1, y1, zLevel, (float)textureX * f, (float)textureY * f);
        tessellator.func_78381_a();
    }

    public static void renderItemStack(ItemStack stack, int angle, double midDist, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        if (!stack.func_190926_b()) {
            matrix.func_227860_a_();
            matrix.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), (float)angle, true));
            matrix.func_227861_a_(midDist, 0.0, 0.0);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.GROUND, combinedLightIn, combinedOverlayIn, matrix, buffer);
            matrix.func_227865_b_();
        }
    }

    public static void renderItemIntoGui(ItemStack stack, int x, int y) {
        RenderHelper.renderItemIntoGui(stack, x, y, false);
    }

    public static void renderItemIntoGui(ItemStack stack, int x, int y, boolean transparent) {
        Minecraft minecraft = Minecraft.func_71410_x();
        net.minecraft.client.renderer.RenderHelper.func_227780_a_();
        minecraft.func_175599_af().func_180450_b(stack, x, y);
        minecraft.func_175599_af().func_175030_a(minecraft.field_71466_p, stack, x, y);
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
    }

    public static void renderItemIntoGui(ItemStack stack, int x, int y, int customSize) {
        Minecraft minecraft = Minecraft.func_71410_x();
        net.minecraft.client.renderer.RenderHelper.func_227780_a_();
        minecraft.func_175599_af().func_180450_b(stack, x, y);
        minecraft.func_175599_af().func_180453_a(minecraft.field_71466_p, stack, x, y, "" + customSize);
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
    }

    public static void renderQuad(Tessellator tes, float width, float height, Direction.Axis axis, float textureX, float textureY, float u, float v) {
        BufferBuilder wr = tes.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        switch (axis) {
            case X: {
                RenderCore.addVertex((IVertexBuilder)wr, 0.0, 0.0, 0.0, textureX, textureY);
                RenderCore.addVertex((IVertexBuilder)wr, width, 0.0, 0.0, textureX + u, textureY);
                RenderCore.addVertex((IVertexBuilder)wr, width, height, 0.0, textureX + u, textureY + v);
                RenderCore.addVertex((IVertexBuilder)wr, 0.0, height, 0.0, textureX, textureY + v);
                break;
            }
            case Y: {
                RenderCore.addVertex((IVertexBuilder)wr, 0.0, 0.0, 0.0, textureX, textureY);
                RenderCore.addVertex((IVertexBuilder)wr, width, 0.0, 0.0, textureX + u, textureY);
                RenderCore.addVertex((IVertexBuilder)wr, width, 0.0, height, textureX + u, textureY + v);
                RenderCore.addVertex((IVertexBuilder)wr, 0.0, 0.0, height, textureX, textureY + v);
                break;
            }
            case Z: {
                RenderCore.addVertex((IVertexBuilder)wr, 0.0, 0.0, 0.0, textureX, textureY);
                RenderCore.addVertex((IVertexBuilder)wr, 0.0, 0.0, width, textureX + u, textureY);
                RenderCore.addVertex((IVertexBuilder)wr, 0.0, height, width, textureX + u, textureY + v);
                RenderCore.addVertex((IVertexBuilder)wr, 0.0, height, 0.0, textureX, textureY + v);
            }
        }
        tes.func_78381_a();
    }

    public static void renderCube(double x, double y, double z, float xSize, float ySize, float zSize, float xAngle, float yAngle, float zAngle, boolean blend, float textureX, float textureY, float u, float v) {
        RenderHelper.renderQuad(x, y, z, xSize, zSize, xAngle, yAngle, zAngle, blend, Direction.Axis.Y, textureX, textureY, u, v);
        RenderHelper.renderQuad(x, y, z + (double)zSize, xSize, ySize, xAngle, yAngle, zAngle, blend, Direction.Axis.X, textureX, textureY, u, v);
        RenderHelper.renderQuad(x, y, z, zSize, ySize, xAngle, yAngle, zAngle, blend, Direction.Axis.Z, textureX, textureY, u, v);
        GL11.glFrontFace((int)2304);
        RenderHelper.renderQuad(x, y + (double)ySize, z, xSize, zSize, xAngle, yAngle, zAngle, blend, Direction.Axis.Y, textureX, textureY, u, v);
        RenderHelper.renderQuad(x, y, z, xSize, ySize, xAngle, yAngle, zAngle, blend, Direction.Axis.X, textureX, textureY, u, v);
        RenderHelper.renderQuad(x + (double)xSize, y, z, zSize, ySize, xAngle, yAngle, zAngle, blend, Direction.Axis.Z, textureX, textureY, u, v);
        GL11.glFrontFace((int)2305);
    }

    public static void renderCube(IVertexBuilder builder, MatrixStack stack, double x, double y, double z, float xSize, float ySize, float zSize, float textureX, float textureY, float u, float v, int r, int g, int b, int a, int light, TextureAtlasSprite sprite) {
        RenderHelper.renderQuad(builder, stack, x, y, z, xSize, zSize, Direction.DOWN, textureX, textureY, u, v, r, g, b, a, light, sprite);
        RenderHelper.renderQuad(builder, stack, x, y, z + (double)zSize, xSize, ySize, Direction.WEST, textureX, textureY, u, v, r, g, b, a, light, sprite);
        RenderHelper.renderQuad(builder, stack, x, y, z, zSize, ySize, Direction.NORTH, textureX, textureY, u, v, r, g, b, a, light, sprite);
        RenderHelper.renderQuad(builder, stack, x, y + (double)ySize, z, xSize, zSize, Direction.UP, textureX, textureY, u, v, r, g, b, a, light, sprite);
        RenderHelper.renderQuad(builder, stack, x, y, z, xSize, ySize, Direction.EAST, textureX, textureY, u, v, r, g, b, a, light, sprite);
        RenderHelper.renderQuad(builder, stack, x + (double)xSize, y, z, zSize, ySize, Direction.SOUTH, textureX, textureY, u, v, r, g, b, a, light, sprite);
    }

    public static void renderQuad(double x, double y, double z, float width, float height, float xAngle, float yAngle, float zAngle, boolean blend, Direction.Axis axis, float textureX, float textureY, float u, float v) {
        RenderCore.pushMatrix();
        RenderCore.translated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        RenderCore.rotatef((float)xAngle, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderCore.rotatef((float)yAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderCore.rotatef((float)zAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderCore.translated((double)-0.5, (double)-0.5, (double)-0.5);
        if (blend) {
            RenderCore.enableBlend();
        }
        RenderCore.disableLighting();
        Tessellator tes = Tessellator.func_178181_a();
        RenderHelper.renderQuad(tes, width, height, axis, textureX, textureY, u, v);
        RenderCore.enableLighting();
        if (blend) {
            RenderCore.disableBlend();
        }
        RenderCore.popMatrix();
    }

    public static void renderQuad(IVertexBuilder builder, MatrixStack stack, double x, double y, double z, float width, float height, Direction dir, float textureX, float textureY, float u, float v, int r, int g, int b, int a, int light, TextureAtlasSprite sprite) {
        RenderCore.pushMatrix(stack);
        RenderCore.translated(stack, x, y, z);
        RenderHelper.renderQuad(builder, stack, width, height, dir, textureX, textureY, u, v, r, g, b, a, light, sprite);
        RenderCore.popMatrix(stack);
    }

    public static void renderQuad(IVertexBuilder wr, MatrixStack stack, float width, float height, Direction dir, float textureX, float textureY, float u, float v, int r, int g, int b, int a, int light, TextureAtlasSprite sprite) {
        MatrixStack.Entry entry = stack.func_227866_c_();
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        Direction.Axis axis = dir.func_176740_k();
        builder.setQuadOrientation(dir);
        switch (axis) {
            case X: {
                if (dir.func_176743_c() == Direction.AxisDirection.POSITIVE) {
                    RenderCore.addVertexData(builder, 0.0f, height, 0.0f, textureX, textureY + v);
                    RenderCore.addVertexData(builder, width, height, 0.0f, textureX + u, textureY + v);
                    RenderCore.addVertexData(builder, width, 0.0f, 0.0f, textureX + u, textureY);
                    RenderCore.addVertexData(builder, 0.0f, 0.0f, 0.0f, textureX, textureY);
                    break;
                }
                RenderCore.addVertexData(builder, 0.0f, 0.0f, 0.0f, textureX, textureY);
                RenderCore.addVertexData(builder, width, 0.0f, 0.0f, textureX + u, textureY);
                RenderCore.addVertexData(builder, width, height, 0.0f, textureX + u, textureY + v);
                RenderCore.addVertexData(builder, 0.0f, height, 0.0f, textureX, textureY + v);
                break;
            }
            case Y: {
                if (dir.func_176743_c() == Direction.AxisDirection.POSITIVE) {
                    RenderCore.addVertexData(builder, 0.0f, 0.0f, height, textureX, textureY + v);
                    RenderCore.addVertexData(builder, width, 0.0f, height, textureX + u, textureY + v);
                    RenderCore.addVertexData(builder, width, 0.0f, 0.0f, textureX + u, textureY);
                    RenderCore.addVertexData(builder, 0.0f, 0.0f, 0.0f, textureX, textureY);
                    break;
                }
                RenderCore.addVertexData(builder, 0.0f, 0.0f, 0.0f, textureX, textureY);
                RenderCore.addVertexData(builder, width, 0.0f, 0.0f, textureX + u, textureY);
                RenderCore.addVertexData(builder, width, 0.0f, height, textureX + u, textureY + v);
                RenderCore.addVertexData(builder, 0.0f, 0.0f, height, textureX, textureY + v);
                break;
            }
            case Z: {
                if (dir.func_176743_c() == Direction.AxisDirection.POSITIVE) {
                    RenderCore.addVertexData(builder, 0.0f, height, 0.0f, textureX, textureY + v);
                    RenderCore.addVertexData(builder, 0.0f, height, width, textureX + u, textureY + v);
                    RenderCore.addVertexData(builder, 0.0f, 0.0f, width, textureX + u, textureY);
                    RenderCore.addVertexData(builder, 0.0f, 0.0f, 0.0f, textureX, textureY);
                    break;
                }
                RenderCore.addVertexData(builder, 0.0f, 0.0f, 0.0f, textureX, textureY);
                RenderCore.addVertexData(builder, 0.0f, 0.0f, width, textureX + u, textureY);
                RenderCore.addVertexData(builder, 0.0f, height, width, textureX + u, textureY + v);
                RenderCore.addVertexData(builder, 0.0f, height, 0.0f, textureX, textureY + v);
            }
        }
        RenderCore.addQuad(entry, wr, builder, r, g, b, a, light);
    }

    public static Tessellator setupRenderWorldLast(MatrixStack stack, Vector3d projectedView) {
        stack.func_227860_a_();
        stack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        RenderCore.pushMatrix();
        RenderCore.multMatrix((Matrix4f)stack.func_227866_c_().func_227870_a_());
        RenderCore.enableBlend();
        RenderCore.enableDepthTest();
        RenderCore.disableCull();
        return Tessellator.func_178181_a();
    }

    public static void cleanUpRenderWorldLast(MatrixStack stack) {
        RenderCore.enableCull();
        RenderCore.disableDepthTest();
        RenderCore.disableBlend();
        RenderCore.popMatrix();
        stack.func_227865_b_();
    }

    public static void drawLasersBetweenPoints(MatrixStack matrix, Vector3d from, Vector3d to, float r, float g, float b, float thickness, float ticks, float cnt) {
        RenderCore.pushMatrix();
        double distance = from.func_72438_d(to);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        Vector3d view = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        matrix.func_227861_a_(-view.func_82615_a(), -view.func_82617_b(), -view.func_82616_c());
        matrix.func_227861_a_(from.field_72450_a, from.field_72448_b, from.field_72449_c);
        RenderCore.pushMatrix();
        RenderCore.multMatrix((Matrix4f)matrix.func_227866_c_().func_227870_a_());
        RenderCore.enableColorMaterial();
        RenderCore.disableDepthTest();
        RenderCore.enableBlend();
        RenderCore.disableCull();
        RenderCore.enableTexture();
        RenderCore.blendFunc((int)770, (int)771);
        RenderCore.color4f((float)r, (float)g, (float)b, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE_BEAM);
        double f = Math.sin(cnt);
        thickness = (float)((double)thickness + 0.0125 * f);
        double v1 = -ticks;
        double v2 = distance * 1.5 - (double)ticks;
        Vector3d vector = to.func_178788_d(from);
        RenderHelper.drawBeamBasic(thickness, wr, v1, v2, vector);
        RenderCore.enableDepthTest();
        RenderCore.enableCull();
        RenderCore.popMatrix();
        RenderCore.popMatrix();
    }

    public static void drawLasers(RenderWorldLastEvent event, Vector3d from, RayTraceResult trace, double xOffset, double yOffset, double zOffset, float r, float g, float b, float thickness, PlayerEntity player, float ticks, boolean firstPerson, float cnt) {
        Hand activeHand;
        if (player.func_184614_ca().func_77973_b() instanceof CastingTool) {
            activeHand = Hand.MAIN_HAND;
        } else if (player.func_184592_cb().func_77973_b() instanceof CastingTool) {
            activeHand = Hand.OFF_HAND;
        } else {
            return;
        }
        double distance = Math.sqrt(from.func_178788_d(trace.func_216347_e()).func_189985_c());
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        Vector3d view = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        MatrixStack matrix = event.getMatrixStack();
        matrix.func_227861_a_(-view.func_82615_a(), -view.func_82617_b(), -view.func_82616_c());
        matrix.func_227861_a_(from.field_72450_a, from.field_72448_b, from.field_72449_c);
        RenderCore.pushMatrix();
        RenderCore.multMatrix((Matrix4f)matrix.func_227866_c_().func_227870_a_());
        RenderCore.enableColorMaterial();
        RenderCore.disableDepthTest();
        RenderCore.enableBlend();
        RenderCore.disableCull();
        RenderCore.enableTexture();
        RenderCore.rotatef((float)MathHelper.func_219799_g((float)ticks, (float)(-player.field_70177_z), (float)(-player.field_70126_B)), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderCore.rotatef((float)MathHelper.func_219799_g((float)ticks, (float)player.field_70125_A, (float)player.field_70127_C), (float)1.0f, (float)0.0f, (float)0.0f);
        RenderCore.blendFunc((int)770, (int)771);
        RenderCore.color4f((float)r, (float)g, (float)b, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE_BEAM);
        double f = Math.sin(cnt);
        thickness = (float)((double)thickness + 0.0125 * f);
        double v1 = -ticks;
        double v2 = distance * 1.5 - (double)ticks;
        RenderHelper.drawBeam(xOffset, yOffset, zOffset, thickness, activeHand, distance, wr, v1, v2, ticks, firstPerson);
        RenderCore.enableDepthTest();
        RenderCore.enableCull();
        RenderCore.popMatrix();
    }

    private static void drawBeam(double xOffset, double yOffset, double zOffset, float thickness, Hand hand, double distance, BufferBuilder wr, double v1, double v2, float ticks, boolean firstPerson) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        float startXOffset = -0.25f;
        float startYOffset = -0.115f;
        float startZOffset = 0.65f + (1.0f - player.func_175156_o());
        if (firstPerson) {
            startXOffset = -0.675f;
        }
        float f = MathHelper.func_219799_g((float)ticks, (float)player.field_70127_C, (float)player.field_70125_A) - MathHelper.func_219799_g((float)ticks, (float)player.field_71164_i, (float)player.field_71155_g);
        float f1 = MathHelper.func_219799_g((float)ticks, (float)player.field_70126_B, (float)player.field_70177_z) - MathHelper.func_219799_g((float)ticks, (float)player.field_71163_h, (float)player.field_71154_f);
        startXOffset += f1 / 1000.0f;
        startYOffset += f / 1000.0f;
        if (Minecraft.func_71410_x().field_71474_y.field_186715_A != HandSide.RIGHT) {
            hand = hand == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND;
        }
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        if (hand == Hand.MAIN_HAND) {
            wr.func_225582_a_((double)startXOffset, (double)(-thickness + startYOffset), (double)startZOffset).func_225583_a_(1.0f, (float)v1).func_181675_d();
            wr.func_225582_a_(xOffset, (double)(-thickness) + yOffset, distance + zOffset).func_225583_a_(1.0f, (float)v2).func_181675_d();
            wr.func_225582_a_(xOffset, (double)thickness + yOffset, distance + zOffset).func_225583_a_(0.0f, (float)v2).func_181675_d();
            wr.func_225582_a_((double)startXOffset, (double)(thickness + startYOffset), (double)startZOffset).func_225583_a_(0.0f, (float)v1).func_181675_d();
        } else {
            startYOffset = -0.12f;
            wr.func_225582_a_((double)(-startXOffset), (double)(thickness + startYOffset), (double)startZOffset).func_225583_a_(0.0f, (float)v1).func_181675_d();
            wr.func_225582_a_(xOffset, (double)thickness + yOffset, distance + zOffset).func_225583_a_(0.0f, (float)v2).func_181675_d();
            wr.func_225582_a_(xOffset, (double)(-thickness) + yOffset, distance + zOffset).func_225583_a_(1.0f, (float)v2).func_181675_d();
            wr.func_225582_a_((double)(-startXOffset), (double)(-thickness + startYOffset), (double)startZOffset).func_225583_a_(1.0f, (float)v1).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    private static void drawBeamBasic(float thickness, BufferBuilder wr, double v1, double v2, Vector3d vector) {
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_225582_a_(0.0, (double)thickness, 0.0).func_225583_a_(1.0f, (float)v1).func_181675_d();
        wr.func_225582_a_(vector.field_72450_a, vector.field_72448_b + (double)thickness, vector.field_72449_c).func_225583_a_(1.0f, (float)v2).func_181675_d();
        wr.func_225582_a_(vector.field_72450_a, vector.field_72448_b - (double)thickness, vector.field_72449_c).func_225583_a_(0.0f, (float)v2).func_181675_d();
        wr.func_225582_a_(0.0, (double)(-thickness), 0.0).func_225583_a_(0.0f, (float)v1).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawLine(IGui cont, MatrixStack stack, int x0, int x1, int y0, int y1, int time) {
        if (Math.abs(y1 - y0) < Math.abs(x1 - x0)) {
            if (x0 > x1) {
                RenderHelper.plotLineLow(cont, stack, x1, y1, x0, y0, time);
            } else {
                RenderHelper.plotLineLow(cont, stack, x0, y0, x1, y1, time);
            }
        } else if (y0 > y1) {
            RenderHelper.plotLineHigh(cont, stack, x1, y1, x0, y0, time);
        } else {
            RenderHelper.plotLineHigh(cont, stack, x0, y0, x1, y1, time);
        }
    }

    public static void plotLineLow(IGui cont, MatrixStack stack, int x0, int y0, int x1, int y1, int time) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        double yi = 1.0;
        if (dy < 0.0) {
            yi = -1.0;
            dy = -dy;
        }
        double D = 2.0 * dy - dx;
        double y = y0;
        double ratio = 256.0 / dx;
        for (int x = x0; x < x1; ++x) {
            int texX = time + (int)Math.floor(ratio * (double)(x - x0));
            if (texX > 255) {
                texX -= 255;
            }
            cont.getGui().func_238474_b_(stack, x, (int)y, texX, 84, 2, 2);
            if (D > 0.0) {
                y += yi;
                D -= 2.0 * dx;
            }
            D += 2.0 * dy;
        }
    }

    public static void plotLineHigh(IGui cont, MatrixStack stack, int x0, int y0, int x1, int y1, int time) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        double xi = 1.0;
        if (dx < 0.0) {
            xi = -1.0;
            dx = -dx;
        }
        double D = 2.0 * dx - dy;
        double x = x0;
        double ratio = 256.0 / dy;
        for (int y = y0; y < y1; ++y) {
            int texX = time + (int)Math.floor(ratio * (double)(y - y0));
            if (texX > 255) {
                texX -= 255;
            }
            cont.getGui().func_238474_b_(stack, (int)x, y, texX, 84, 2, 2);
            if (D > 0.0) {
                x += xi;
                D -= 2.0 * dy;
            }
            D += 2.0 * dx;
        }
    }
}

