/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.JEI;

import com.cobbs.lordcraft.Entries.ModBlocks;
import com.cobbs.lordcraft.Entries.ModItems;
import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.Util.EElement;
import com.cobbs.lordcraft.Util.Helpers.ColorHelper;
import com.cobbs.lordcraft.Util.Helpers.InputHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Recipes.IArcaneCraftingRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ArcaneRecipeCategory
implements IRecipeCategory<ICraftingRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("lordcraft", "arcane_crafting");
    public static final String title = ModHelper.concat("lordcraft", ".", "arcane_crafting");
    public IJeiHelpers helpers;
    public final IDrawable background;
    public final IDrawable icon;
    public final IDrawable crystalSelect;
    public final IDrawable crystal;
    public final IDrawable crystalElemental;
    public final IDrawable voidCrystal;

    public ArcaneRecipeCategory(IJeiHelpers helpers) {
        this.helpers = helpers;
        IGuiHelper guiHelper = helpers.getGuiHelper();
        ResourceLocation location = new ResourceLocation("lordcraft", "textures/gui/arcane_table.png");
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.WORKBENCH_BASIC));
        this.background = guiHelper.createDrawable(location, 7, 3, 166, 72);
        this.crystal = guiHelper.createDrawable(location, 176, 0, 18, 34);
        this.crystalElemental = guiHelper.createDrawable(location, 194, 0, 24, 40);
        this.crystalSelect = guiHelper.createDrawable(location, 219, 3, 18, 34);
        this.voidCrystal = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.VOID_CRYSTAL));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends ICraftingRecipe> getRecipeClass() {
        return ICraftingRecipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)title, (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(ICraftingRecipe recipe, IIngredients ingredients) {
        ItemStack recipeOutput = recipe.func_77571_b();
        try {
            ingredients.setInputIngredients((List)recipe.func_192400_c());
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipeOutput);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, ICraftingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IArcaneCraftingRecipe r = (IArcaneCraftingRecipe)recipe;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int index = i * 3 + j;
                guiItemStacks.init(index, true, 22 + j * 18, 2 + i * 18);
            }
        }
        int index = 0;
        List lists = ingredients.getInputs(VanillaTypes.ITEM);
        for (int i = 0; i < 3 && i != r.getRHeight(); ++i) {
            for (int j = 0; j < 3 && index < lists.size() && j != r.getRWidth(); ++index, ++j) {
                int ind = i * 3 + j + (r.getRWidth() == 1 ? 1 : 0);
                guiItemStacks.set(ind, (List)lists.get(index));
            }
        }
        guiItemStacks.init(9, false, 116, 20);
        guiItemStacks.set(9, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        if (recipe instanceof ShapelessRecipe) {
            recipeLayout.setShapeless();
        }
    }

    public void draw(ICraftingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        IArcaneCraftingRecipe r = (IArcaneCraftingRecipe)recipe;
        int element = r.getElement();
        GlStateManager.func_227740_m_();
        if (element > 0) {
            float[] c = ColorHelper.rgbTo3f(ColorHelper.ELEMENTALCOLOURS[element]);
            GlStateManager.func_227702_d_((float)c[0], (float)c[1], (float)c[2], (float)1.0f);
            this.crystalElemental.draw(matrixStack, 140, 9);
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            this.crystal.draw(matrixStack, 143, 12);
        }
        if (InputHelper.mouseInArea(mouseX, mouseY, 143, 12, 161, 48)) {
            this.crystalSelect.draw(matrixStack, 143, 12);
        }
        if (r.voidRecipe()) {
            this.voidCrystal.draw(matrixStack, 86, 42);
        }
        EResearch research = r.getResearch();
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrixStack, I18n.func_135052_a((String)research.unlocalname(), (Object[])new Object[0]), 3.0f, 62.0f, ColorHelper.ELEMENTALCOLOURS[7]);
        GlStateManager.func_227740_m_();
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public List<ITextComponent> getTooltipStrings(ICraftingRecipe recipe, double mouseX, double mouseY) {
        IArcaneCraftingRecipe r = (IArcaneCraftingRecipe)recipe;
        int element = r.getElement();
        if (element > 0 && InputHelper.mouseInArea(mouseX, mouseY, 143, 12, 161, 48)) {
            EElement e = EElement.values()[element - 1];
            return ModHelper.wrapLinked(new StringTextComponent(ModHelper.concat(I18n.func_135052_a((String)"lordcraft.attuned_element", (Object[])new Object[0]), ": ", e.getTextColor(), I18n.func_135052_a((String)EElement.values()[element - 1].getUnlocalName(), (Object[])new Object[0]))));
        }
        if (r.voidRecipe() && InputHelper.mouseInArea(mouseX, mouseY, 86, 42, 102, 58)) {
            return ModHelper.wrapLinked(new TranslationTextComponent("lordcraft.void_recipe"));
        }
        return Collections.emptyList();
    }
}

