/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.JEI;

import com.cobbs.lordcraft.Entries.ModBlocks;
import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.Util.Helpers.ColorHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Recipes.BasinRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class BasinRecipeCategory
implements IRecipeCategory<BasinRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("lordcraft", "arcane_basin");
    public static final String title = ModHelper.concat("lordcraft", ".", "arcane_basin");
    public IJeiHelpers helpers;
    public final IDrawable background;
    public final IDrawable icon;

    public BasinRecipeCategory(IJeiHelpers helpers) {
        this.helpers = helpers;
        IGuiHelper guiHelper = helpers.getGuiHelper();
        ResourceLocation location = new ResourceLocation("lordcraft", "textures/gui/basin_recipe.png");
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.ARCANE_BASIN));
        this.background = guiHelper.createDrawable(location, 0, 0, 166, 87);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends BasinRecipe> getRecipeClass() {
        return BasinRecipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)title, (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(BasinRecipe recipe, IIngredients ingredients) {
        ArrayList<Ingredient> stacks = new ArrayList<Ingredient>(recipe.reagent.size() + 2);
        stacks.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151131_as)}));
        stacks.addAll((Collection<Ingredient>)recipe.reagent);
        stacks.add(recipe.collector);
        ingredients.setInputIngredients(stacks);
        ItemStack output = recipe.output.func_77946_l();
        output.func_190920_e(output.func_190916_E() * recipe.amount);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)output);
    }

    public void setRecipe(IRecipeLayout recipeLayout, BasinRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 2, 2);
        guiItemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        int i = 0;
        for (i = 1; i < recipe.reagent.size() + 1; ++i) {
            guiItemStacks.init(i, true, 2 + (i - 1) * 18, 22);
            guiItemStacks.set(i, (List)ingredients.getInputs(VanillaTypes.ITEM).get(i));
        }
        List stacks = (List)ingredients.getInputs(VanillaTypes.ITEM).get(i);
        stacks.forEach(stack -> stack.func_190920_e(recipe.amount));
        guiItemStacks.init(i, true, 74, 42);
        guiItemStacks.set(i, stacks);
        guiItemStacks.init(i + 1, false, 146, 54);
        guiItemStacks.set(i + 1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public void draw(BasinRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        EResearch research = recipe.getResearch();
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrixStack, I18n.func_135052_a((String)research.unlocalname(), (Object[])new Object[0]), 5.0f, 77.0f, ColorHelper.ELEMENTALCOLOURS[7]);
        GlStateManager.func_227740_m_();
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

