/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.JEI;

import com.cobbs.lordcraft.Blocks.ArcaneWorkbench.ArcaneWorkbenchContBig;
import com.cobbs.lordcraft.Blocks.ArcaneWorkbench.ArcaneWorkbenchContSmall;
import com.cobbs.lordcraft.Blocks.Ritual.CraftingRitual;
import com.cobbs.lordcraft.Blocks.Ritual.ERitual;
import com.cobbs.lordcraft.Entries.ModBlocks;
import com.cobbs.lordcraft.Entries.ModItems;
import com.cobbs.lordcraft.Util.JEI.ArcaneRecipeCategory;
import com.cobbs.lordcraft.Util.JEI.BasinRecipeCategory;
import com.cobbs.lordcraft.Util.JEI.RitualRecipeCategory;
import com.cobbs.lordcraft.Util.Recipes.BasinRecipe;
import com.cobbs.lordcraft.Util.Recipes.IResearchCraftingRequirement;
import com.cobbs.lordcraft.Util.Recipes.RitualRecipe;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class LordPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("lordcraft", "jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ArcaneRecipeCategory(registration.getJeiHelpers()), new BasinRecipeCategory(registration.getJeiHelpers())});
        for (ERitual ritual : ERitual.values()) {
            if (!(ritual.getRitual() instanceof CraftingRitual)) continue;
            registration.addRecipeCategories(new IRecipeCategory[]{new RitualRecipeCategory(registration.getJeiHelpers(), ritual)});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        List recipes = world.func_199532_z().func_241447_a_(IRecipeType.field_222149_a);
        recipes = recipes.stream().filter(recipe -> recipe instanceof IResearchCraftingRequirement).collect(Collectors.toList());
        registration.addRecipes(recipes, ArcaneRecipeCategory.ID);
        List basinRecipes = world.func_199532_z().func_241447_a_(BasinRecipe.BASIN_RECIPE_TYPE);
        registration.addRecipes((Collection)basinRecipes, BasinRecipeCategory.ID);
        List ritualRecipes = world.func_199532_z().func_241447_a_(RitualRecipe.RITUAL_RECIPE_TYPE);
        for (ERitual ritual : ERitual.values()) {
            if (!(ritual.getRitual() instanceof CraftingRitual)) continue;
            LinkedList<RitualRecipe> subsetRecipes = new LinkedList<RitualRecipe>(ritualRecipes);
            subsetRecipes.removeIf(ritualRecipe -> ritualRecipe.ritual != ritual);
            registration.addRecipes(subsetRecipes, RitualRecipeCategory.getID(ritual));
        }
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(ArcaneWorkbenchContSmall.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
        registration.addRecipeTransferHandler(ArcaneWorkbenchContSmall.class, ArcaneRecipeCategory.ID, 1, 9, 10, 36);
        registration.addRecipeTransferHandler(ArcaneWorkbenchContBig.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 54);
        registration.addRecipeTransferHandler(ArcaneWorkbenchContBig.class, ArcaneRecipeCategory.ID, 1, 9, 10, 54);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.WORKBENCH_BASIC), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.WORKBENCH_ADV), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.WORKBENCH_VOID), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.WORKBENCH_BASIC), new ResourceLocation[]{ArcaneRecipeCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.WORKBENCH_ADV), new ResourceLocation[]{ArcaneRecipeCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.WORKBENCH_VOID), new ResourceLocation[]{ArcaneRecipeCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.ARCANE_BASIN), new ResourceLocation[]{BasinRecipeCategory.ID});
        for (ERitual ritual : ERitual.values()) {
            if (!(ritual.getRitual() instanceof CraftingRitual)) continue;
            ResourceLocation ID = RitualRecipeCategory.getID(ritual);
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.CHALK), new ResourceLocation[]{ID});
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.CHALK_ARCANA), new ResourceLocation[]{ID});
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.RITUAL_CIRCLE), new ResourceLocation[]{ID});
            if (ritual != ERitual.FUSION) continue;
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.FORGE), new ResourceLocation[]{ID});
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        List recipes = world.func_199532_z().func_241447_a_(IRecipeType.field_222149_a);
        recipes.stream().filter(recipe -> recipe instanceof IResearchCraftingRequirement).forEach(r -> jeiRuntime.getRecipeManager().hideRecipe(r, VanillaRecipeCategoryUid.CRAFTING));
    }
}

