/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.JEI;

import com.cobbs.lordcraft.Blocks.Ritual.ERitual;
import com.cobbs.lordcraft.Entries.ModBlocks;
import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.Util.Helpers.ColorHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Recipes.RitualRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class RitualRecipeCategory
implements IRecipeCategory<RitualRecipe> {
    public final ResourceLocation ID;
    public final String title;
    public IJeiHelpers helpers;
    public final IDrawable background;
    public final IDrawable icon;
    public ERitual ritual;

    public static ResourceLocation getID(ERitual ritual) {
        return new ResourceLocation("lordcraft", ModHelper.concat("ritual_", ritual.name));
    }

    public RitualRecipeCategory(IJeiHelpers helpers, ERitual ritual) {
        this.ritual = ritual;
        this.helpers = helpers;
        this.title = ModHelper.concat("lordcraft", ".", "ritual_", ritual.name);
        this.ID = RitualRecipeCategory.getID(ritual);
        IGuiHelper guiHelper = helpers.getGuiHelper();
        ResourceLocation location = new ResourceLocation("lordcraft", "textures/gui/ritual_recipe.png");
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.RITUAL_CIRCLE));
        this.background = guiHelper.createDrawable(location, 0, 0, 166, 87);
    }

    public ResourceLocation getUid() {
        return this.ID;
    }

    public Class<? extends RitualRecipe> getRecipeClass() {
        return RitualRecipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)this.title, (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(RitualRecipe recipe, IIngredients ingredients) {
        ArrayList<Ingredient> stacks = new ArrayList<Ingredient>(recipe.reagent.size() + 1);
        stacks.add(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{recipe.ritual.getRitual().reagent}));
        stacks.addAll((Collection<Ingredient>)recipe.reagent);
        ingredients.setInputIngredients(stacks);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.output);
    }

    public void setRecipe(IRecipeLayout recipeLayout, RitualRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 2, 29);
        guiItemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        int i = 0;
        int[][] poses = new int[][]{{74, 29}, {74, 4}, {53, 8}, {49, 29}, {53, 50}, {74, 54}, {95, 50}, {99, 29}, {95, 8}};
        for (i = 1; i < recipe.reagent.size() + 1; ++i) {
            guiItemStacks.init(i, true, poses[i - 1][0], poses[i - 1][1]);
            guiItemStacks.set(i, (List)ingredients.getInputs(VanillaTypes.ITEM).get(i));
        }
        guiItemStacks.init(i, false, 146, 29);
        guiItemStacks.set(i, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public void draw(RitualRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        EResearch research = recipe.getResearch();
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrixStack, I18n.func_135052_a((String)research.unlocalname(), (Object[])new Object[0]), 5.0f, 77.0f, ColorHelper.ELEMENTALCOLOURS[7]);
        GlStateManager.func_227740_m_();
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

