/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.Network;

import com.cobbs.lordcraft.Blocks.ModTileEntity;
import com.cobbs.lordcraft.Blocks.TEModules.Items.ItemHandlerModule;
import com.cobbs.lordcraft.Entries.ModItems;
import com.cobbs.lordcraft.Items.Artifacts.SuperArtifactItem;
import com.cobbs.lordcraft.Items.SpellCasting.ArcaneBow;
import com.cobbs.lordcraft.Items.SpellCasting.CastingTool;
import com.cobbs.lordcraft.Items.SpellCasting.RuneItem;
import com.cobbs.lordcraft.Items.SpellCasting.SpellCrystal;
import com.cobbs.lordcraft.Passives.Abilities.Dash.DashData;
import com.cobbs.lordcraft.Passives.Abilities.DoubleJump.DoubleJumpData;
import com.cobbs.lordcraft.Passives.EPassive;
import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.Spells.ESpell;
import com.cobbs.lordcraft.Spells.ESpellFocus;
import com.cobbs.lordcraft.Spells.SpellContainer;
import com.cobbs.lordcraft.UI.Containers.TEContainer;
import com.cobbs.lordcraft.Util.DataStorage.Lordic.LordicCollection;
import com.cobbs.lordcraft.Util.DataStorage.Lordic.LordicData;
import com.cobbs.lordcraft.Util.DataStorage.Lordic.LordicSavedData;
import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaCollection;
import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaData;
import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaSavedData;
import com.cobbs.lordcraft.Util.DataStorage.Passives.PassiveCollection;
import com.cobbs.lordcraft.Util.DataStorage.Passives.PassiveData;
import com.cobbs.lordcraft.Util.DataStorage.Passives.PassiveSavedData;
import com.cobbs.lordcraft.Util.EShadowKey;
import com.cobbs.lordcraft.Util.Helpers.DataStorageHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Helpers.SoundHelper;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class CustomC2SMessage {
    private String text;

    public CustomC2SMessage() {
    }

    public CustomC2SMessage(String text) {
        this.text = text;
    }

    protected static CustomC2SMessage decode(PacketBuffer buffer) {
        return new CustomC2SMessage(buffer.func_150789_c(Short.MAX_VALUE));
    }

    protected static void encode(CustomC2SMessage packet, PacketBuffer buffer) {
        buffer.func_180714_a(packet.text);
    }

    public static class Handler {
        public static void handle(CustomC2SMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ItemStack stack;
                String[] parts = message.text.split("~");
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                String pt0 = parts[0];
                if (pt0.charAt(0) == '-') {
                    Object te = ((TEContainer)player.field_71070_bA).te;
                    ((ModTileEntity)((Object)((Object)te))).handleNetworkMessageServer(pt0, Arrays.copyOfRange(parts, 1, parts.length));
                } else if (pt0.equalsIgnoreCase("pb")) {
                    PassiveSavedData passiveSavedData = PassiveSavedData.get((ServerWorld)player.field_70170_p);
                    PassiveData passiveData = (PassiveData)((PassiveCollection)passiveSavedData.data).get(player.func_110124_au().toString());
                    ManaSavedData manaSavedData = ManaSavedData.get((ServerWorld)player.field_70170_p);
                    ManaData manaData = (ManaData)((ManaCollection)manaSavedData.data).get(player.func_110124_au().toString());
                    EPassive passive = EPassive.values()[Integer.parseInt(parts[1])];
                    int val = passiveData.getState(passive);
                    int pips = manaData.maxPips;
                    if (val == 1) {
                        if (pips < passive.pipCost) {
                            val = 0;
                        }
                        if (!passive.getPassive().canEnable(passiveData)) {
                            val = 0;
                        }
                    }
                    if (val == 1) {
                        manaData.maxPips -= passive.pipCost;
                        manaData.pips = Math.max(0, manaData.pips - passive.pipCost);
                        passiveSavedData.activate((PlayerEntity)player, passive);
                        manaSavedData.cleanupAndSync((PlayerEntity)player);
                        passiveSavedData.cleanupAndSync((PlayerEntity)player);
                    } else if (val == 2) {
                        passiveSavedData.deActivate((PlayerEntity)player, passive);
                        manaData.maxPips += passive.pipCost;
                        if (passive.getPassive().allows() != null) {
                            for (EPassive pass : passive.getPassive().allows()) {
                                if (passiveData.getState(pass) != 2) continue;
                                passiveSavedData.deActivate((PlayerEntity)player, pass);
                                manaData.maxPips += passive.pipCost;
                            }
                        }
                        manaSavedData.cleanupAndSync((PlayerEntity)player);
                        passiveSavedData.cleanupAndSync((PlayerEntity)player);
                    }
                } else if (pt0.equalsIgnoreCase("p_dj")) {
                    PassiveSavedData data = PassiveSavedData.get((ServerWorld)player.func_130014_f_());
                    PassiveData passives = (PassiveData)((PassiveCollection)data.data).get(player.func_110124_au().toString());
                    DoubleJumpData djd = (DoubleJumpData)passives.linkedData.get((Object)EPassive.DOUBLE_JUMP);
                    if (passives.getState(EPassive.DOUBLE_JUMP) == 2 && !djd.hasJumped && player.func_226278_cu_() != (double)player.func_233580_cy_().func_177956_o() && !player.field_71075_bZ.field_75100_b) {
                        player.func_70024_g(0.0, (double)0.7f, 0.0);
                        player.field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
                        djd.hasJumped = true;
                        data.cleanupAndSync((PlayerEntity)player);
                    }
                } else if (pt0.equalsIgnoreCase("p_d")) {
                    PassiveSavedData data = PassiveSavedData.get((ServerWorld)player.func_130014_f_());
                    PassiveData passives = (PassiveData)((PassiveCollection)data.data).get(player.func_110124_au().toString());
                    DashData dd = (DashData)passives.linkedData.get((Object)EPassive.DASH);
                    if (passives.getState(EPassive.DASH) == 2 && dd.dash < dd.dashCount) {
                        int val = Integer.parseInt(parts[1]);
                        if ((player.func_226278_cu_() != (double)player.func_233580_cy_().func_177956_o() || val != 0 || player.func_70051_ag()) && !player.field_71075_bZ.field_75100_b) {
                            Vector3d dir = player.func_70040_Z();
                            switch (val) {
                                case 1: {
                                    dir = dir.func_178785_b((float)ModHelper.toRadian(270.0));
                                    break;
                                }
                                case 2: {
                                    dir = dir.func_178785_b((float)ModHelper.toRadian(180.0));
                                    break;
                                }
                                case 3: {
                                    dir = dir.func_178785_b((float)ModHelper.toRadian(90.0));
                                }
                            }
                            player.func_70024_g(dir.field_72450_a * 0.85, 0.085, dir.field_72449_c * 0.85);
                            player.field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
                            ++dd.dash;
                            data.cleanupAndSync((PlayerEntity)player);
                        }
                    }
                } else if (pt0.equalsIgnoreCase("key")) {
                    EShadowKey key = EShadowKey.values()[Integer.parseInt(parts[1])];
                    boolean state = Integer.parseInt(parts[2]) == 1;
                    key.setHolding((PlayerEntity)player, state);
                    if (state) {
                        key.runKeyEvent(key, (PlayerEntity)player);
                    }
                } else if (pt0.equalsIgnoreCase("bse")) {
                    LordicSavedData savedData = LordicSavedData.get((PlayerEntity)player);
                    LordicData data = (LordicData)((LordicCollection)savedData.data).get((PlayerEntity)player);
                    int element = Integer.parseInt(parts[1]);
                    data.setPrimaryElement(element);
                    switch (element) {
                        case 0: {
                            DataStorageHelper.unlockResearch((PlayerEntity)player, EResearch.BASICS, EResearch.WATER);
                            break;
                        }
                        case 1: {
                            DataStorageHelper.unlockResearch((PlayerEntity)player, EResearch.BASICS, EResearch.EARTH);
                            break;
                        }
                        case 2: {
                            DataStorageHelper.unlockResearch((PlayerEntity)player, EResearch.BASICS, EResearch.FIRE);
                            break;
                        }
                        case 3: {
                            DataStorageHelper.unlockResearch((PlayerEntity)player, EResearch.BASICS, EResearch.AIR);
                            break;
                        }
                        case 4: {
                            DataStorageHelper.unlockResearch((PlayerEntity)player, EResearch.BASICS, EResearch.LIGHT);
                            break;
                        }
                        case 5: {
                            DataStorageHelper.unlockResearch((PlayerEntity)player, EResearch.BASICS, EResearch.DARK);
                        }
                    }
                    savedData.cleanupAndSync((PlayerEntity)player);
                } else if (pt0.equalsIgnoreCase("bse2")) {
                    int levels = 30;
                    if (player.func_184812_l_()) {
                        levels = 0;
                    }
                    if (player.field_71068_ca >= levels) {
                        player.func_82242_a(-levels);
                        LordicSavedData savedData = LordicSavedData.get((PlayerEntity)player);
                        LordicData data = (LordicData)((LordicCollection)savedData.data).get((PlayerEntity)player);
                        int element = Integer.parseInt(parts[1]);
                        data.setPrimaryElement2(element);
                        savedData.cleanupAndSync((PlayerEntity)player);
                    }
                } else if (pt0.equalsIgnoreCase("bsl")) {
                    LordicSavedData savedData = LordicSavedData.get((PlayerEntity)player);
                    LordicData data = (LordicData)((LordicCollection)savedData.data).get((PlayerEntity)player);
                    data.legacy = Integer.parseInt(parts[1]);
                    DataStorageHelper.updateLegacyState((PlayerEntity)player, data.legacy, data.legacyLevel);
                    savedData.cleanupAndSync((PlayerEntity)player);
                } else if (pt0.equalsIgnoreCase("bsl2")) {
                    int level = player.field_71068_ca;
                    if (level >= 20 || player.func_184812_l_()) {
                        LordicSavedData savedData = LordicSavedData.get((PlayerEntity)player);
                        LordicData data = (LordicData)((LordicCollection)savedData.data).get((PlayerEntity)player);
                        data.legacy = Integer.parseInt(parts[1]);
                        DataStorageHelper.updateLegacyState((PlayerEntity)player, data.legacy, data.legacyLevel);
                        savedData.cleanupAndSync((PlayerEntity)player);
                        if (!player.func_184812_l_()) {
                            player.func_82242_a(-20);
                        }
                    }
                } else if (pt0.equalsIgnoreCase("brf")) {
                    EResearch research = EResearch.values()[Integer.parseInt(parts[1])];
                    int val = 0;
                    if (!player.func_184812_l_()) {
                        val = research.difficulty;
                    }
                    if (ModHelper.inscriptionCheckAndRemove((PlayerEntity)player, val)) {
                        DataStorageHelper.unlockResearch((PlayerEntity)player, research);
                    }
                } else if (pt0.equalsIgnoreCase("br")) {
                    EResearch research = EResearch.values()[Integer.parseInt(parts[1])];
                    DataStorageHelper.unlockResearch((PlayerEntity)player, research);
                } else if (pt0.equalsIgnoreCase("bhc")) {
                    int i = Integer.parseInt(parts[1]);
                    LordicSavedData savedData = LordicSavedData.get((PlayerEntity)player);
                    LordicData data = (LordicData)((LordicCollection)savedData.data).get((PlayerEntity)player);
                    data.hud_visibility[i] = !data.hud_visibility[i];
                    savedData.cleanupAndSync((PlayerEntity)player);
                } else if (pt0.equalsIgnoreCase("bch")) {
                    LordicSavedData savedData = LordicSavedData.get((PlayerEntity)player);
                    LordicData data = (LordicData)((LordicCollection)savedData.data).get((PlayerEntity)player);
                    data.hud_color = Integer.parseInt(parts[1]);
                    savedData.cleanupAndSync((PlayerEntity)player);
                } else if (pt0.equalsIgnoreCase("sr")) {
                    SpellContainer cont;
                    Hand h = Hand.values()[Integer.parseInt(parts[1])];
                    ItemStack stack2 = player.func_184586_b(h);
                    if (stack2.func_77973_b() instanceof CastingTool && (cont = CastingTool.getSpell(stack2)) != null) {
                        ItemStack drop = SpellCrystal.getCrystalWithSpell(cont);
                        InventoryHelper.func_180173_a((World)player.field_70170_p, (double)player.func_226277_ct_(), (double)player.func_226278_cu_(), (double)player.func_226281_cx_(), (ItemStack)drop);
                        CastingTool.setSpell(stack2, null);
                    }
                } else if (pt0.equalsIgnoreCase("abr")) {
                    SpellContainer cont;
                    Hand h = Hand.values()[Integer.parseInt(parts[1])];
                    ItemStack stack3 = player.func_184586_b(h);
                    if (stack3.func_77973_b() instanceof ArcaneBow && (cont = ArcaneBow.getSpell(stack3)) != null) {
                        ItemStack drop = SpellCrystal.getCrystalWithSpell(cont);
                        InventoryHelper.func_180173_a((World)player.field_70170_p, (double)player.func_226277_ct_(), (double)player.func_226278_cu_(), (double)player.func_226281_cx_(), (ItemStack)drop);
                        ArcaneBow.setSpell(stack3, null);
                    }
                } else if (pt0.equalsIgnoreCase("rn")) {
                    Hand h = Hand.values()[Integer.parseInt(parts[1])];
                    ItemStack stack4 = player.func_184586_b(h);
                    if (stack4.func_77973_b() instanceof RuneItem) {
                        RuneItem.nextIndex(stack4);
                        SpellContainer cont = RuneItem.getSpell(stack4);
                        if (cont != null) {
                            ModHelper.actionBarMessage((PlayerEntity)player, ModHelper.concat("\u00a7b", cont.name));
                        }
                    }
                } else if (pt0.equalsIgnoreCase("rp")) {
                    Hand h = Hand.values()[Integer.parseInt(parts[1])];
                    ItemStack stack5 = player.func_184586_b(h);
                    if (stack5.func_77973_b() instanceof RuneItem) {
                        RuneItem.prevIndex(stack5);
                        SpellContainer cont = RuneItem.getSpell(stack5);
                        if (cont != null) {
                            ModHelper.actionBarMessage((PlayerEntity)player, ModHelper.concat("\u00a7b", cont.name));
                        }
                    }
                } else if (pt0.equalsIgnoreCase("sc")) {
                    String name;
                    ESpellFocus focus = ESpellFocus.values()[Integer.parseInt(parts[1])];
                    ESpell spell = ESpell.values()[Integer.parseInt(parts[2])];
                    boolean focusCheck = Integer.parseInt(parts[3]) == 1;
                    boolean focusCharging = Integer.parseInt(parts[4]) == 1;
                    boolean spellFrugal = Integer.parseInt(parts[5]) == 1;
                    boolean spellMod = Integer.parseInt(parts[6]) == 1;
                    double range = Double.parseDouble(parts[7]);
                    double potency = Double.parseDouble(parts[8]);
                    try {
                        name = parts[9];
                    }
                    catch (Exception e) {
                        name = "";
                    }
                    SpellContainer container = new SpellContainer(name, focus, spell, range, focusCheck, focusCharging, spellFrugal, spellMod, potency);
                    ItemHandlerModule te = ((TEContainer)player.field_71070_bA).te;
                    ItemHandlerModule module = ((ModTileEntity)((Object)((Object)te))).getModule(ItemHandlerModule.class);
                    ItemStack stack6 = module.getStackInSlot(0);
                    if (stack6 != null && !stack6.func_190926_b() && stack6.func_77973_b().equals(ModItems.SPELL_CRYSTAL)) {
                        SpellCrystal.setSpell(stack6, container);
                    }
                } else if (pt0.equalsIgnoreCase("aac")) {
                    ItemStack stack7 = player.func_184586_b(Hand.values()[Integer.parseInt(parts[1])]);
                    if (SuperArtifactItem.increaseCharge(stack7)) {
                        SoundHelper.charge_artifact((PlayerEntity)player, 1.0f);
                    }
                } else if (pt0.equalsIgnoreCase("adc") && SuperArtifactItem.decreaseCharge(stack = player.func_184586_b(Hand.values()[Integer.parseInt(parts[1])]))) {
                    SoundHelper.discharge_artifact((PlayerEntity)player, 1.0f);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

