/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.Network;

import com.cobbs.lordcraft.Util.Network.CustomC2SMessage;
import com.cobbs.lordcraft.Util.Network.CustomS2CMessage;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public final class PacketHandler {
    private static final String S2C_PROTOCOL = Integer.toString(0);
    private static final String C2S_PROTOCOL = Integer.toString(1);
    private static final SimpleChannel S2C_HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("lordcraft", "s2c")).clientAcceptedVersions(S2C_PROTOCOL::equals).serverAcceptedVersions(S2C_PROTOCOL::equals).networkProtocolVersion(() -> S2C_PROTOCOL).simpleChannel();
    private static final SimpleChannel C2S_HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("lordcraft", "c2s")).clientAcceptedVersions(C2S_PROTOCOL::equals).serverAcceptedVersions(C2S_PROTOCOL::equals).networkProtocolVersion(() -> C2S_PROTOCOL).simpleChannel();

    public static void registerServer() {
        int index = 0;
        S2C_HANDLER.registerMessage(index++, CustomS2CMessage.class, CustomS2CMessage::encode, CustomS2CMessage::decode, (i, j) -> {});
        C2S_HANDLER.registerMessage(index++, CustomC2SMessage.class, CustomC2SMessage::encode, CustomC2SMessage::decode, CustomC2SMessage.Handler::handle);
    }

    public static void register() {
        int index = 0;
        S2C_HANDLER.registerMessage(index++, CustomS2CMessage.class, CustomS2CMessage::encode, CustomS2CMessage::decode, CustomS2CMessage.Handler::handle);
        C2S_HANDLER.registerMessage(index++, CustomC2SMessage.class, CustomC2SMessage::encode, CustomC2SMessage::decode, CustomC2SMessage.Handler::handle);
    }

    public static <T> void send(PacketDistributor.PacketTarget target, T message) {
        if (target.getDirection().equals((Object)NetworkDirection.PLAY_TO_CLIENT)) {
            S2C_HANDLER.send(target, message);
        } else if (target.getDirection().equals((Object)NetworkDirection.PLAY_TO_SERVER)) {
            C2S_HANDLER.send(target, message);
        }
    }
}

