/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.Recipes;

import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.Util.Recipes.BasinRecipeType;
import com.cobbs.lordcraft.Util.Recipes.IResearchCraftingRequirement;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BasinRecipe
implements IRecipe<IInventory>,
IResearchCraftingRequirement {
    public static final IRecipeType<BasinRecipe> BASIN_RECIPE_TYPE = new BasinRecipeType();
    public static final String TYPE_ID = "basin";
    public static final Serializer SERIALIZER = new Serializer();
    public NonNullList<Ingredient> reagent;
    public Ingredient collector;
    public ItemStack output;
    public int amount;
    public List<Integer> color;
    public EResearch research;
    private ResourceLocation id;

    public BasinRecipe(ResourceLocation id, NonNullList<Ingredient> reagent, Ingredient collector, ItemStack output, int amount, List<Integer> color, EResearch research) {
        this.id = id;
        this.reagent = reagent;
        this.collector = collector;
        this.output = output;
        this.amount = amount;
        this.research = research;
        this.color = color;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return false;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.func_77571_b();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return BASIN_RECIPE_TYPE;
    }

    public static ItemStack deserializeItem(JsonObject object) {
        String s = JSONUtils.func_151200_h((JsonObject)object, (String)"item");
        Item item = (Item)Registry.field_212630_s.func_241873_b(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (object.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
        return CraftingHelper.getItemStack((JsonObject)object, (boolean)true);
    }

    @Override
    public EResearch getResearch() {
        return this.research;
    }

    public static List<BasinRecipe> getSubset(List<BasinRecipe> recipes, int index, ItemStack stack) {
        if (stack.func_190926_b()) {
            return new LinkedList<BasinRecipe>();
        }
        LinkedList<BasinRecipe> subset = new LinkedList<BasinRecipe>();
        for (BasinRecipe recipe : recipes) {
            if (recipe.reagent.size() <= index || !((Ingredient)recipe.reagent.get(index)).test(stack)) continue;
            subset.add(recipe);
        }
        return subset;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<BasinRecipe> {
        public Serializer() {
            this.setRegistryName("lordcraft", BasinRecipe.TYPE_ID);
        }

        public BasinRecipe read(ResourceLocation recipeId, JsonObject json) {
            String research = JSONUtils.func_151219_a((JsonObject)json, (String)"research", (String)"");
            int amount = JSONUtils.func_151208_a((JsonObject)json, (String)"amount", (int)1);
            if (amount < 1 || amount > 64) {
                throw new JsonParseException("Amount value must be between 1-64");
            }
            NonNullList<Ingredient> reagent = Serializer.readIngredients(json.getAsJsonArray("reagents"));
            if (reagent.isEmpty()) {
                throw new JsonParseException("No ingredients for recipe");
            }
            List<Integer> color = Serializer.readColors(json.getAsJsonArray("colors"), reagent.size());
            Ingredient collector = Ingredient.func_199802_a((JsonElement)json.get("collector"));
            ItemStack itemstack = BasinRecipe.deserializeItem(JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            itemstack.func_190920_e(1);
            return new BasinRecipe(recipeId, reagent, collector, itemstack, amount, color, EResearch.getResearch(research));
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientArray.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        private static List<Integer> readColors(JsonArray array, int len) {
            int i;
            ArrayList<Integer> list = new ArrayList<Integer>(len);
            for (i = 0; i < len; ++i) {
                list.add(0);
            }
            if (array != null) {
                for (i = 0; i < array.size(); ++i) {
                    Integer val = array.get(i).getAsInt();
                    list.set(i, val);
                }
            }
            return list;
        }

        @Nullable
        public BasinRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int amount = buffer.func_150792_a();
            int res = buffer.readInt();
            Ingredient collector = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack stack = buffer.func_150791_c();
            int size = buffer.readInt();
            NonNullList reagent = NonNullList.func_191197_a((int)size, (Object)Ingredient.field_193370_a);
            for (int i = 0; i < size; ++i) {
                reagent.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ArrayList<Integer> color = new ArrayList<Integer>(size);
            for (int i = 0; i < size; ++i) {
                color.add(buffer.readInt());
            }
            return new BasinRecipe(recipeId, (NonNullList<Ingredient>)reagent, collector, stack, amount, color, res == -1 ? null : EResearch.values()[res]);
        }

        public void write(PacketBuffer buffer, BasinRecipe recipe) {
            buffer.func_150787_b(recipe.amount);
            buffer.writeInt(recipe.research == null ? -1 : recipe.research.ordinal());
            recipe.collector.func_199564_a(buffer);
            buffer.func_150788_a(recipe.output);
            buffer.writeInt(recipe.reagent.size());
            for (Ingredient ingredient : recipe.reagent) {
                ingredient.func_199564_a(buffer);
            }
            for (Integer c : recipe.color) {
                buffer.writeInt(c.intValue());
            }
        }
    }
}

