/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.Recipes;

import com.cobbs.lordcraft.Blocks.ArcaneWorkbench.ArcaneCraftingInventory;
import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.Util.Recipes.IArcaneCraftingRecipe;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class LordShapedRecipe
extends ShapedRecipe
implements IArcaneCraftingRecipe {
    public static final String TYPE_ID = "crafting_shaped";
    public static final Serializer SERIALIZER = new Serializer();
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    public EResearch research;
    public boolean needsVoid;
    public int element;

    public LordShapedRecipe(ResourceLocation p_i48162_1_, String p_i48162_2_, int p_i48162_3_, int p_i48162_4_, NonNullList<Ingredient> p_i48162_5_, ItemStack p_i48162_6_, EResearch research, int element, boolean needsVoid) {
        super(p_i48162_1_, p_i48162_2_, p_i48162_3_, p_i48162_4_, p_i48162_5_, p_i48162_6_);
        this.research = research;
        this.element = element;
        this.needsVoid = needsVoid;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean func_77569_a(CraftingInventory p_77569_1_, World p_77569_2_) {
        return p_77569_1_ instanceof ArcaneCraftingInventory && super.func_77569_a(p_77569_1_, p_77569_2_);
    }

    private static NonNullList<Ingredient> deserializeIngredients(String[] pattern, Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)(patternWidth * patternHeight), (Object)Ingredient.field_193370_a);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] shrink(String ... toShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < toShrink.length; ++i1) {
            String s = toShrink[i1];
            i = Math.min(i, LordShapedRecipe.firstNonSpace(s));
            int j1 = LordShapedRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toShrink.length == l) {
            return new String[0];
        }
        String[] astring = new String[toShrink.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = toShrink[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int firstNonSpace(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private static String[] patternFromJson(JsonArray jsonArr) {
        String[] astring = new String[jsonArr.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = JSONUtils.func_151206_a((JsonElement)jsonArr.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    private static Map<String, Ingredient> deserializeKey(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put(entry.getKey(), Ingredient.func_199802_a((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.field_193370_a);
        return map;
    }

    public static ItemStack deserializeItem(JsonObject object) {
        String s = JSONUtils.func_151200_h((JsonObject)object, (String)"item");
        Item item = (Item)Registry.field_212630_s.func_241873_b(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (object.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
        return CraftingHelper.getItemStack((JsonObject)object, (boolean)true);
    }

    @Override
    public EResearch getResearch() {
        return this.research;
    }

    @Override
    public int getElement() {
        return this.element;
    }

    @Override
    public boolean voidRecipe() {
        return this.needsVoid;
    }

    @Override
    public int getRWidth() {
        return this.getRecipeWidth();
    }

    @Override
    public int getRHeight() {
        return this.getRecipeHeight();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<LordShapedRecipe> {
        public Serializer() {
            this.setRegistryName("lordcraft", LordShapedRecipe.TYPE_ID);
        }

        public LordShapedRecipe read(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            String res = JSONUtils.func_151219_a((JsonObject)json, (String)"research", (String)"");
            int element = JSONUtils.func_151208_a((JsonObject)json, (String)"element", (int)0);
            boolean needsVoid = JSONUtils.func_151209_a((JsonObject)json, (String)"void", (boolean)false);
            Map map = LordShapedRecipe.deserializeKey(JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
            String[] astring = LordShapedRecipe.shrink(LordShapedRecipe.patternFromJson(JSONUtils.func_151214_t((JsonObject)json, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList nonnulllist = LordShapedRecipe.deserializeIngredients(astring, map, i, j);
            ItemStack itemstack = LordShapedRecipe.deserializeItem(JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new LordShapedRecipe(recipeId, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack, EResearch.getResearch(res), element, needsVoid);
        }

        public LordShapedRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int i = buffer.func_150792_a();
            int j = buffer.func_150792_a();
            int res = buffer.readInt();
            int element = buffer.func_150792_a();
            boolean needsVoid = buffer.readBoolean();
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            NonNullList nonnulllist = NonNullList.func_191197_a((int)(i * j), (Object)Ingredient.field_193370_a);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack itemstack = buffer.func_150791_c();
            return new LordShapedRecipe(recipeId, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack, res == -1 ? null : EResearch.values()[res], element, needsVoid);
        }

        public void write(PacketBuffer buffer, LordShapedRecipe recipe) {
            buffer.func_150787_b(recipe.getRecipeWidth());
            buffer.func_150787_b(recipe.getRecipeHeight());
            buffer.writeInt(recipe.research == null ? -1 : recipe.research.ordinal());
            buffer.func_150787_b(recipe.element);
            buffer.writeBoolean(recipe.needsVoid);
            buffer.func_180714_a(recipe.func_193358_e());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

