/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.Recipes;

import com.cobbs.lordcraft.Blocks.ArcaneWorkbench.ArcaneCraftingInventory;
import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.Util.Recipes.IArcaneCraftingRecipe;
import com.cobbs.lordcraft.Util.Recipes.LordShapedRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class LordShapelessRecipe
extends ShapelessRecipe
implements IArcaneCraftingRecipe {
    public static final String TYPE_ID = "crafting_shapeless";
    public static final Serializer SERIALIZER = new Serializer();
    public EResearch research;
    public boolean needsVoid;
    public int element;

    public LordShapelessRecipe(ResourceLocation p_i48161_1_, String p_i48161_2_, ItemStack p_i48161_3_, NonNullList<Ingredient> p_i48161_4_, EResearch research, int element, boolean needsVoid) {
        super(p_i48161_1_, p_i48161_2_, p_i48161_3_, p_i48161_4_);
        this.research = research;
        this.element = element;
        this.needsVoid = needsVoid;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean func_77569_a(CraftingInventory p_77569_1_, World p_77569_2_) {
        return p_77569_1_ instanceof ArcaneCraftingInventory && super.func_77569_a(p_77569_1_, p_77569_2_);
    }

    @Override
    public EResearch getResearch() {
        return this.research;
    }

    @Override
    public int getElement() {
        return this.element;
    }

    @Override
    public boolean voidRecipe() {
        return this.needsVoid;
    }

    @Override
    public int getRWidth() {
        return 3;
    }

    @Override
    public int getRHeight() {
        return 3;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<LordShapelessRecipe> {
        public Serializer() {
            this.setRegistryName("lordcraft", LordShapelessRecipe.TYPE_ID);
        }

        public LordShapelessRecipe read(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            String res = JSONUtils.func_151219_a((JsonObject)json, (String)"research", (String)"");
            int element = JSONUtils.func_151208_a((JsonObject)json, (String)"element", (int)0);
            boolean needsVoid = JSONUtils.func_151209_a((JsonObject)json, (String)"void", (boolean)false);
            NonNullList<Ingredient> nonnulllist = Serializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > LordShapedRecipe.MAX_WIDTH * LordShapedRecipe.MAX_HEIGHT) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is " + LordShapedRecipe.MAX_WIDTH * LordShapedRecipe.MAX_HEIGHT);
            }
            ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new LordShapelessRecipe(recipeId, s, itemstack, nonnulllist, EResearch.getResearch(res), element, needsVoid);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientArray.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public LordShapelessRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            int i = buffer.func_150792_a();
            int res = buffer.readInt();
            int element = buffer.func_150792_a();
            boolean needsVoid = buffer.readBoolean();
            NonNullList nonnulllist = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack itemstack = buffer.func_150791_c();
            return new LordShapelessRecipe(recipeId, s, itemstack, (NonNullList<Ingredient>)nonnulllist, res == -1 ? null : EResearch.values()[res], element, needsVoid);
        }

        public void write(PacketBuffer buffer, LordShapelessRecipe recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            buffer.func_150787_b(recipe.func_192400_c().size());
            buffer.writeInt(recipe.research == null ? -1 : recipe.research.ordinal());
            buffer.func_150787_b(recipe.element);
            buffer.writeBoolean(recipe.needsVoid);
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

