/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.Recipes;

import com.cobbs.lordcraft.Blocks.Ritual.ERitual;
import com.cobbs.lordcraft.Blocks.Ritual.RitualTE;
import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Recipes.IResearchCraftingRequirement;
import com.cobbs.lordcraft.Util.Recipes.RitualRecipeType;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RitualRecipe
implements IRecipe<IInventory>,
IResearchCraftingRequirement {
    public static final IRecipeType<RitualRecipe> RITUAL_RECIPE_TYPE = new RitualRecipeType();
    public static final String TYPE_ID = "ritual";
    public static final Serializer SERIALIZER = new Serializer();
    public NonNullList<Ingredient> reagent;
    public ItemStack output;
    public EResearch research;
    public ERitual ritual;
    private ResourceLocation id;

    public RitualRecipe(ResourceLocation id, ERitual ritual, NonNullList<Ingredient> reagent, ItemStack output, EResearch research) {
        this.id = id;
        this.ritual = ritual;
        this.reagent = reagent;
        this.output = output;
        this.research = research;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return false;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.func_77571_b();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return RITUAL_RECIPE_TYPE;
    }

    public static ItemStack deserializeItem(JsonObject object) {
        String s = JSONUtils.func_151200_h((JsonObject)object, (String)"item");
        Item item = (Item)Registry.field_212630_s.func_241873_b(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (object.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
        return CraftingHelper.getItemStack((JsonObject)object, (boolean)true);
    }

    @Override
    public EResearch getResearch() {
        return this.research;
    }

    public static RitualRecipe getRecipe(RitualTE te) {
        ERitual ritual = te.ritual;
        List<ItemStack> stacks = te.stacks;
        ArrayList<ItemStack> working = new ArrayList<ItemStack>();
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = stacks.get(i);
            if (stack.func_190926_b()) continue;
            working.add(stack);
        }
        return RitualRecipe.getRecipe(te, ritual, working);
    }

    public static RitualRecipe getRecipe(RitualTE te, ERitual ritual, List<ItemStack> stacks) {
        List r = te.func_145831_w().func_199532_z().func_241447_a_(RITUAL_RECIPE_TYPE);
        for (RitualRecipe recipe : r) {
            boolean matches = true;
            if (recipe.ritual != ritual) continue;
            for (Ingredient stack : recipe.reagent) {
                if (ModHelper.listContainsAnyStack(stacks, stack)) continue;
                matches = false;
                break;
            }
            if (!matches || stacks.size() != recipe.reagent.size()) continue;
            return recipe;
        }
        return null;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RitualRecipe> {
        public Serializer() {
            this.setRegistryName("lordcraft", RitualRecipe.TYPE_ID);
        }

        public RitualRecipe read(ResourceLocation recipeId, JsonObject json) {
            String research = JSONUtils.func_151219_a((JsonObject)json, (String)"research", (String)"");
            String ritual = JSONUtils.func_151219_a((JsonObject)json, (String)RitualRecipe.TYPE_ID, (String)"");
            NonNullList<Ingredient> reagent = Serializer.readIngredients(json.getAsJsonArray("reagents"));
            if (reagent.isEmpty()) {
                throw new JsonParseException("No ingredients for recipe");
            }
            if (reagent.size() > 9) {
                throw new JsonParseException("Recipe cannot exceed 9 reagents!");
            }
            ItemStack itemstack = RitualRecipe.deserializeItem(JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new RitualRecipe(recipeId, ERitual.getRitual(ritual), reagent, itemstack, EResearch.getResearch(research));
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientArray.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @Nullable
        public RitualRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int res = buffer.readInt();
            int rit = buffer.readInt();
            ItemStack stack = buffer.func_150791_c();
            int size = buffer.readInt();
            NonNullList reagent = NonNullList.func_191197_a((int)size, (Object)Ingredient.field_193370_a);
            for (int i = 0; i < size; ++i) {
                reagent.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            return new RitualRecipe(recipeId, ERitual.values()[rit], (NonNullList<Ingredient>)reagent, stack, res == -1 ? null : EResearch.values()[res]);
        }

        public void write(PacketBuffer buffer, RitualRecipe recipe) {
            buffer.writeInt(recipe.research == null ? -1 : recipe.research.ordinal());
            buffer.writeInt(recipe.ritual.ordinal());
            buffer.func_150788_a(recipe.output);
            buffer.writeInt(recipe.reagent.size());
            for (Ingredient ingredient : recipe.reagent) {
                ingredient.func_199564_a(buffer);
            }
        }
    }
}

