/*
 * Decompiled with CFR 0.152.
 */
package be.ephys.magicfeather;

import be.ephys.cookiecore.config.Config;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class BeaconRangeCalculator {
    @Config(category="range_computation", description="How the beacon range is calculated vertically. Java = Vanilla Java Behavior. Bedrock = Vanilla Bedrock behavior. FullHeight = expand vertical range to maximum")
    public static BeaconVerticalRangeType verticalRangeType = BeaconVerticalRangeType.FullHeight;
    @Config(category="range_computation", description="What is the beacon base range?")
    public static int baseRange = 10;
    @Config(category="range_computation", description="How many blocks are added to the range per level?")
    public static int rangeStep = 10;

    public static boolean isInBeaconRange(Entity entity) {
        World world = entity.func_130014_f_();
        List tileEntities = world.field_147482_g;
        for (TileEntity t : tileEntities) {
            if (!(t instanceof TileEntityBeacon)) continue;
            TileEntityBeacon beacon = (TileEntityBeacon)t;
            int level = beacon.func_174887_a_(0);
            int radius = level * rangeStep + baseRange;
            BlockPos pos = beacon.func_174877_v();
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            if (entity.field_70165_t < (double)(x - radius) || entity.field_70165_t > (double)(x + radius) || entity.field_70161_v < (double)(z - radius) || entity.field_70161_v > (double)(z + radius) || verticalRangeType != BeaconVerticalRangeType.FullHeight && (entity.field_70163_u < (double)(y - radius - verticalRangeType.downRangeExtension) || entity.field_70163_u > (double)(y + radius + verticalRangeType.upRangeExtension))) continue;
            return true;
        }
        return false;
    }

    public static enum BeaconVerticalRangeType {
        Java(0, 256),
        Bedrock(0, 0),
        FullHeight(0, 0);

        private final int downRangeExtension;
        private final int upRangeExtension;

        private BeaconVerticalRangeType(int downRangeExtension, int upRangeExtension) {
            this.downRangeExtension = downRangeExtension;
            this.upRangeExtension = upRangeExtension;
        }
    }
}

