/*
 * Decompiled with CFR 0.152.
 */
package be.ephys.magicfeather;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import be.ephys.cookiecore.config.Config;
import be.ephys.magicfeather.BeaconRangeCalculator;
import be.ephys.magicfeather.ModItems;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class ItemMagicFeather
extends Item
implements IBauble {
    public static final String NAME = "magicfeather";
    private static final WeakHashMap<EntityPlayer, MagicFeatherData> playerData = new WeakHashMap();
    @Config(category="baubles_compat", description="In which bauble slot can the magic feather be put?")
    public static BaubleType baubleType = BaubleType.CHARM;

    public ItemMagicFeather() {
        this.func_77625_d(1);
        this.func_77655_b("magicfeather:magicfeather");
        this.setRegistryName(NAME);
        this.func_77637_a(CreativeTabs.field_78026_f);
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && !BeaconRangeCalculator.isInBeaconRange((Entity)player)) {
            tooltip.add(I18n.func_135052_a((String)"magicfeather.gui.out_of_beacon_range", (Object[])new Object[0]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity entity, ItemStack itemstack) {
        entity.func_184224_h(true);
        return null;
    }

    private static void setMayFly(EntityPlayer player, boolean mayFly) {
        if (player.field_71075_bZ.field_75101_c == mayFly) {
            return;
        }
        player.field_71075_bZ.field_75101_c = mayFly;
        player.func_71016_p();
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side != Side.SERVER) {
            return;
        }
        EntityPlayer player = event.player;
        MagicFeatherData data = playerData.get(player);
        if (data == null || data.player != player) {
            data = new MagicFeatherData(player);
            playerData.put(player, data);
        }
        data.onTick();
    }

    private static boolean hasItem(EntityPlayer player, Item item) {
        if (Loader.isModLoaded((String)"baubles") && BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)item) != -1) {
            return true;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!item.equals(stack.func_77973_b())) continue;
            return true;
        }
        return false;
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return baubleType;
    }

    private static class MagicFeatherData {
        private final EntityPlayer player;
        private boolean isSoftLanding = false;
        private boolean wasGrantedFlight = false;
        private int checkTick = 0;
        private boolean beaconInRangeCache;

        public MagicFeatherData(EntityPlayer player) {
            this.player = player;
            this.beaconInRangeCache = player.field_71075_bZ.field_75101_c;
        }

        public void onTick() {
            boolean mayFly;
            if (this.player.func_175149_v()) {
                return;
            }
            boolean hasItem = ItemMagicFeather.hasItem(this.player, ModItems.magicFeather);
            boolean bl = mayFly = this.player.field_71075_bZ.field_75098_d || hasItem && this.checkBeaconInRange(this.player);
            if (mayFly) {
                ItemMagicFeather.setMayFly(this.player, true);
                this.isSoftLanding = false;
            } else if (this.wasGrantedFlight) {
                System.out.println("wasGrantedFlight");
                this.isSoftLanding = true;
            }
            if (this.isSoftLanding && this.softLand()) {
                System.out.println("softLand");
                this.isSoftLanding = false;
            }
            this.wasGrantedFlight = mayFly;
        }

        private boolean softLand() {
            boolean isPlayerOnGround;
            boolean bl = isPlayerOnGround = this.player.field_70122_E && this.player.field_70143_R < 1.0f;
            if (isPlayerOnGround) {
                ItemMagicFeather.setMayFly(this.player, false);
                return true;
            }
            if (this.player.field_71075_bZ.field_75100_b) {
                this.player.field_71075_bZ.field_75100_b = false;
                this.player.func_71016_p();
            }
            return false;
        }

        private boolean checkBeaconInRange(EntityPlayer player) {
            if (this.checkTick++ % 40 != 0) {
                return this.beaconInRangeCache;
            }
            this.beaconInRangeCache = BeaconRangeCalculator.isInBeaconRange((Entity)player);
            return this.beaconInRangeCache;
        }
    }
}

