/*
 * Decompiled with CFR 0.152.
 */
package be.ephys.magicfeather;

import be.ephys.cookiecore.config.Config;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;

public final class BeaconRangeCalculator {
    @Config(name="range_computation.vertical_range_type", description="How the beacon range is calculated vertically. Java = Vanilla Java Behavior. Bedrock = Vanilla Bedrock behavior. FullHeight = expand vertical range to maximum")
    @Config.EnumDefault(value="FullHeight", enumType=BeaconVerticalRangeType.class)
    public static ForgeConfigSpec.EnumValue<BeaconVerticalRangeType> verticalRangeType;
    @Config(name="range_computation.base_range", description="What is the beacon base range?")
    @Config.IntDefault(value=10)
    public static ForgeConfigSpec.IntValue baseRange;
    @Config(name="range_computation.range_step", description="How many blocks are added to the range per level?")
    @Config.IntDefault(value=10)
    public static ForgeConfigSpec.IntValue rangeStep;

    public static boolean isInBeaconRange(Entity entity) {
        World world = entity.func_130014_f_();
        Vec3d entityPos = entity.func_213303_ch();
        int rangeStep = (Integer)BeaconRangeCalculator.rangeStep.get();
        int baseRange = (Integer)BeaconRangeCalculator.baseRange.get();
        BeaconVerticalRangeType verticalRangeType = (BeaconVerticalRangeType)((Object)BeaconRangeCalculator.verticalRangeType.get());
        List tileEntities = world.field_147482_g;
        for (TileEntity t : tileEntities) {
            if (!(t instanceof BeaconTileEntity)) continue;
            BeaconTileEntity beacon = (BeaconTileEntity)t;
            int level = beacon.func_191979_s();
            int radius = level * rangeStep + baseRange;
            BlockPos pos = beacon.func_174877_v();
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            if (entityPos.field_72450_a < (double)(x - radius) || entityPos.field_72450_a > (double)(x + radius) || entityPos.field_72449_c < (double)(z - radius) || entityPos.field_72449_c > (double)(z + radius) || verticalRangeType != BeaconVerticalRangeType.FullHeight && (entityPos.field_72448_b < (double)(y - radius - verticalRangeType.downRangeExtension) || entityPos.field_72448_b > (double)(y + radius + verticalRangeType.upRangeExtension))) continue;
            return true;
        }
        return false;
    }

    public static enum BeaconVerticalRangeType {
        Java(0, 256),
        FullHeight(0, 0);

        private final int downRangeExtension;
        private final int upRangeExtension;

        private BeaconVerticalRangeType(int downRangeExtension, int upRangeExtension) {
            this.downRangeExtension = downRangeExtension;
            this.upRangeExtension = upRangeExtension;
        }
    }
}

