/*
 * Decompiled with CFR 0.152.
 */
package be.ephys.magicfeather;

import be.ephys.cookiecore.config.Config;
import be.ephys.magicfeather.BeaconRangeCalculator;
import be.ephys.magicfeather.ModItems;
import java.util.List;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;

public class ItemMagicFeather
extends Item {
    public static final String NAME = "magicfeather";
    private static final WeakHashMap<PlayerEntity, MagicFeatherData> playerData = new WeakHashMap();
    @Config(name="item.requires_curios", description="If curios is installed, the magic feather will need to be installed in its charm slot to function.")
    @Config.BooleanDefault(value=true)
    public static ForgeConfigSpec.BooleanValue looseRequiresCurios;

    public ItemMagicFeather() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78029_e));
        this.setRegistryName(NAME);
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    private static void setMayFly(PlayerEntity player, boolean mayFly) {
        if (player.field_71075_bZ.field_75101_c == mayFly) {
            return;
        }
        player.field_71075_bZ.field_75101_c = mayFly;
        player.func_71016_p();
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    private static boolean requiresCurios() {
        return ItemMagicFeather.isCuriosInstalled() && (Boolean)looseRequiresCurios.get() != false;
    }

    private static boolean isCuriosInstalled() {
        return ModList.get().isLoaded("curios");
    }

    private static boolean isCuriosEquipped(PlayerEntity player, Item item) {
        return CuriosApi.getCuriosHelper().findEquippedCurio(item, (LivingEntity)player).isPresent();
    }

    private static boolean hasItem(PlayerEntity player, Item item) {
        if (ItemMagicFeather.isCuriosInstalled()) {
            if (ItemMagicFeather.isCuriosEquipped(player, item)) {
                return true;
            }
            if (((Boolean)looseRequiresCurios.get()).booleanValue()) {
                return false;
            }
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!item.equals(stack.func_77973_b())) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            if (ItemMagicFeather.requiresCurios() && !ItemMagicFeather.isCuriosEquipped((PlayerEntity)player, ModItems.magicFeather)) {
                tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77667_c(stack) + ".tooltip.requires_curios").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY)));
            }
            if (!BeaconRangeCalculator.isInBeaconRange((Entity)player)) {
                tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77667_c(stack) + ".tooltip.out_of_beacon_range").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY)));
            }
        }
    }

    public Entity createEntity(World world, Entity entity, ItemStack itemstack) {
        entity.func_184224_h(true);
        return null;
    }

    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        PlayerEntity player = event.player;
        MagicFeatherData data = playerData.get(player);
        if (data == null || data.player != player) {
            data = new MagicFeatherData(player);
            playerData.put(player, data);
        }
        data.onTick();
    }

    private static class MagicFeatherData {
        private final PlayerEntity player;
        private boolean isSoftLanding = false;
        private boolean wasGrantedFlight = false;
        private int checkTick = 0;
        private boolean beaconInRangeCache;

        public MagicFeatherData(PlayerEntity player) {
            this.player = player;
            this.beaconInRangeCache = player.field_71075_bZ.field_75101_c;
        }

        public void onTick() {
            boolean mayFly;
            if (this.player.func_175149_v()) {
                return;
            }
            boolean hasItem = ItemMagicFeather.hasItem(this.player, ModItems.magicFeather);
            boolean bl = mayFly = this.player.field_71075_bZ.field_75098_d || hasItem && this.checkBeaconInRange(this.player);
            if (mayFly) {
                ItemMagicFeather.setMayFly(this.player, true);
                this.isSoftLanding = false;
            } else if (this.wasGrantedFlight) {
                this.isSoftLanding = true;
            }
            if (this.isSoftLanding && this.softLand()) {
                this.isSoftLanding = false;
            }
            this.wasGrantedFlight = mayFly;
        }

        private boolean softLand() {
            boolean isPlayerOnGround;
            boolean bl = isPlayerOnGround = this.player.func_233570_aj_() && this.player.field_70143_R < 1.0f;
            if (isPlayerOnGround) {
                ItemMagicFeather.setMayFly(this.player, false);
                return true;
            }
            if (this.player.field_71075_bZ.field_75100_b) {
                this.player.field_71075_bZ.field_75100_b = false;
                this.player.func_71016_p();
            }
            return false;
        }

        private boolean checkBeaconInRange(PlayerEntity player) {
            if (this.checkTick++ % 40 != 0) {
                return this.beaconInRangeCache;
            }
            this.beaconInRangeCache = BeaconRangeCalculator.isInBeaconRange((Entity)player);
            return this.beaconInRangeCache;
        }
    }
}

