/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.blocks;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.torocraft.minecoprocessors.Minecoprocessors;
import net.torocraft.minecoprocessors.blocks.TileEntityMinecoprocessor;
import net.torocraft.minecoprocessors.items.IMetaBlockName;
import net.torocraft.minecoprocessors.items.ItemBlockMeta;
import net.torocraft.minecoprocessors.util.RedstoneUtil;

@Mod.EventBusSubscriber
public class BlockMinecoprocessor
extends BlockRedstoneDiode
implements ITileEntityProvider,
IMetaBlockName {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final PropertyBool OVERCLOCKED = PropertyBool.func_177716_a((String)"overclocked");
    public static final String NAME = "minecoprocessor";
    private static ResourceLocation REGISTRY_NAME = new ResourceLocation("minecoprocessors", "minecoprocessor");
    private static ResourceLocation REGISTRY_OVERCLOCKED_NAME = new ResourceLocation("minecoprocessors", "minecoprocessor_overclocked");
    public static BlockMinecoprocessor INSTANCE = (BlockMinecoprocessor)new BlockMinecoprocessor().func_149663_c("minecoprocessor").setRegistryName(REGISTRY_NAME);
    public static ItemBlockMeta ITEM_INSTANCE = (ItemBlockMeta)new ItemBlockMeta((Block)INSTANCE).setRegistryName(REGISTRY_NAME);

    @SubscribeEvent
    public static void initBlock(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE);
    }

    @SubscribeEvent
    public static void initItem(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)ITEM_INSTANCE);
    }

    public static void preRegisterRenders() {
        ModelBakery.registerItemVariants((Item)ITEM_INSTANCE, (ResourceLocation[])new ResourceLocation[]{REGISTRY_NAME, REGISTRY_OVERCLOCKED_NAME});
    }

    public static void registerRenders() {
        BlockMinecoprocessor.registerRender(REGISTRY_NAME.toString(), 0);
        BlockMinecoprocessor.registerRender(REGISTRY_OVERCLOCKED_NAME.toString(), 4);
    }

    private static void registerRender(String file, int meta) {
        ModelResourceLocation model = new ModelResourceLocation(file, "inventory");
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)ITEM_INSTANCE, meta, model);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state) & 4;
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Item)ITEM_INSTANCE));
        items.add((Object)new ItemStack((Item)ITEM_INSTANCE, 1, 4));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)OVERCLOCKED, (Comparable)Boolean.valueOf((meta & 4) > 0)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, ACTIVE, OVERCLOCKED});
    }

    protected IBlockState func_180674_e(IBlockState unpoweredState) {
        return this.func_180675_k(unpoweredState);
    }

    protected IBlockState func_180675_k(IBlockState poweredState) {
        Boolean obool = (Boolean)poweredState.func_177229_b((IProperty)ACTIVE);
        EnumFacing enumfacing = (EnumFacing)poweredState.func_177229_b((IProperty)field_185512_D);
        return INSTANCE.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing).func_177226_a((IProperty)ACTIVE, (Comparable)obool);
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 8) > 0)).func_177226_a((IProperty)OVERCLOCKED, (Comparable)Boolean.valueOf((meta & 4) > 0));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            i |= 8;
        }
        if (((Boolean)state.func_177229_b((IProperty)OVERCLOCKED)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public BlockMinecoprocessor() {
        super(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)OVERCLOCKED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(CreativeTabs.field_78028_d);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMinecoprocessor();
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    protected void func_176398_g(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175654_a(pos, (Block)this, 0, -1);
    }

    public void onPortChange(World worldIn, BlockPos pos, IBlockState state, int portIndex) {
        this.notifyNeighborsOnSide(worldIn, pos, RedstoneUtil.convertPortIndexToFacing(((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176734_d(), portIndex));
    }

    protected void notifyNeighborsOnSide(World worldIn, BlockPos pos, EnumFacing side) {
        BlockPos neighborPos = pos.func_177972_a(side);
        if (ForgeEventFactory.onNeighborNotify((World)worldIn, (BlockPos)pos, (IBlockState)worldIn.func_180495_p(pos), EnumSet.of(side), (boolean)false).isCanceled()) {
            return;
        }
        worldIn.func_190524_a(neighborPos, (Block)this, pos);
        worldIn.func_175695_a(neighborPos, (Block)this, side.func_176734_d());
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        boolean processorActive;
        super.func_180650_b(world, pos, state, rand);
        BlockMinecoprocessor.updateInputPorts(world, pos, state);
        if (world.field_72995_K) {
            return;
        }
        TileEntityMinecoprocessor te = (TileEntityMinecoprocessor)world.func_175625_s(pos);
        boolean changed = false;
        boolean blockActive = (Boolean)state.func_177229_b((IProperty)ACTIVE);
        boolean bl = processorActive = !te.getProcessor().isWait() && !te.getProcessor().isFault();
        if (blockActive && !processorActive) {
            state = state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
            changed = true;
        } else if (!blockActive && processorActive) {
            state = state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(true));
            changed = true;
        }
        if (changed) {
            world.func_180501_a(pos, state, 2);
        }
    }

    public static void updateInputPorts(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            return;
        }
        EnumFacing facing = ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176734_d();
        int e = BlockMinecoprocessor.calculateInputStrength(world, pos.func_177972_a(EnumFacing.EAST), EnumFacing.EAST);
        int w = BlockMinecoprocessor.calculateInputStrength(world, pos.func_177972_a(EnumFacing.WEST), EnumFacing.WEST);
        int n = BlockMinecoprocessor.calculateInputStrength(world, pos.func_177972_a(EnumFacing.NORTH), EnumFacing.NORTH);
        int s = BlockMinecoprocessor.calculateInputStrength(world, pos.func_177972_a(EnumFacing.SOUTH), EnumFacing.SOUTH);
        int[] values = new int[4];
        values[RedstoneUtil.convertFacingToPortIndex((EnumFacing)facing, (EnumFacing)EnumFacing.NORTH)] = n;
        values[RedstoneUtil.convertFacingToPortIndex((EnumFacing)facing, (EnumFacing)EnumFacing.SOUTH)] = s;
        values[RedstoneUtil.convertFacingToPortIndex((EnumFacing)facing, (EnumFacing)EnumFacing.WEST)] = w;
        values[RedstoneUtil.convertFacingToPortIndex((EnumFacing)facing, (EnumFacing)EnumFacing.EAST)] = e;
        ((TileEntityMinecoprocessor)world.func_175625_s(pos)).updateInputPorts(values);
    }

    protected static int calculateInputStrength(World worldIn, BlockPos pos, EnumFacing enumfacing) {
        IBlockState adjacentState = worldIn.func_180495_p(pos);
        Block block = adjacentState.func_177230_c();
        int i = worldIn.func_175651_c(pos, enumfacing);
        if (i >= 15) {
            return 15;
        }
        int redstoneWirePower = 0;
        if (block == Blocks.field_150488_af) {
            redstoneWirePower = (Integer)adjacentState.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
        }
        return Math.max(i, redstoneWirePower);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityMinecoprocessor) {
            ((TileEntityMinecoprocessor)tileentity).setName(stack.func_82833_r());
        }
    }

    public int func_176211_b(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return state.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntityMinecoprocessor te = (TileEntityMinecoprocessor)blockAccess.func_175625_s(pos);
        if (te.func_145831_w().field_72995_K) {
            return 0;
        }
        if (RedstoneUtil.isFrontPort(state, side)) {
            return RedstoneUtil.portToPower(te.getFrontPortSignal());
        }
        if (RedstoneUtil.isBackPort(state, side)) {
            return RedstoneUtil.portToPower(te.getBackPortSignal());
        }
        if (RedstoneUtil.isLeftPort(state, side)) {
            return RedstoneUtil.portToPower(te.getLeftPortSignal());
        }
        if (RedstoneUtil.isRightPort(state, side)) {
            return RedstoneUtil.portToPower(te.getRightPortSignal());
        }
        return 0;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.openGui((Object)Minecoprocessors.INSTANCE, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    protected int func_176403_d(IBlockState state) {
        return 0;
    }

    public boolean func_176405_b(IBlockAccess worldIn, BlockPos pos, IBlockState state) {
        return true;
    }

    protected boolean func_185545_A(IBlockState state) {
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        this.func_176400_h(worldIn, pos, state);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityMinecoprocessor) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityMinecoprocessor)tileentity));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return this.func_149739_a() + ((stack.func_77952_i() & 4) == 0 ? "" : "_overclocked");
    }
}

