/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.blocks;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.torocraft.minecoprocessors.Minecoprocessors;
import net.torocraft.minecoprocessors.blocks.BlockMinecoprocessor;
import net.torocraft.minecoprocessors.items.ItemBookCode;
import net.torocraft.minecoprocessors.network.MessageProcessorUpdate;
import net.torocraft.minecoprocessors.processor.Processor;
import net.torocraft.minecoprocessors.processor.Register;
import net.torocraft.minecoprocessors.util.ByteUtil;
import net.torocraft.minecoprocessors.util.InstructionUtil;
import net.torocraft.minecoprocessors.util.RedstoneUtil;

public class TileEntityMinecoprocessor
extends TileEntity
implements ITickable,
IInventory {
    private static final String NAME = "minecoprocessor_tile_entity";
    private static final String NBT_PROCESSOR = "processor";
    private static final String NBT_LOAD_TIME = "loadTime";
    private static final String NBT_CUSTOM_NAME = "CustomName";
    private final Processor processor = new Processor();
    private NonNullList<ItemStack> codeItemStacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private String customName;
    private int loadTime;
    private boolean loaded;
    private Set<EntityPlayerMP> playersToUpdate = new HashSet<EntityPlayerMP>();
    private final byte[] prevPortValues = new byte[4];
    private byte prevPortsRegister = (byte)15;
    private boolean prevIsInactive;
    private boolean overClocked;

    public static void init() {
        GameRegistry.registerTileEntity(TileEntityMinecoprocessor.class, (String)NAME);
    }

    public void onLoad() {
        this.overClocked = (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockMinecoprocessor.OVERCLOCKED);
    }

    public boolean shouldRefresh(World worldIn, BlockPos blockPos, IBlockState oldState, IBlockState newState) {
        return BlockMinecoprocessor.INSTANCE != oldState.func_177230_c() || BlockMinecoprocessor.INSTANCE != newState.func_177230_c();
    }

    public void func_145839_a(NBTTagCompound c) {
        super.func_145839_a(c);
        this.processor.readFromNBT(c.func_74775_l(NBT_PROCESSOR));
        this.codeItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)c, this.codeItemStacks);
        this.loadTime = c.func_74765_d(NBT_LOAD_TIME);
        if (c.func_150297_b(NBT_CUSTOM_NAME, 8)) {
            this.customName = c.func_74779_i(NBT_CUSTOM_NAME);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound cIn) {
        NBTTagCompound c = super.func_189515_b(cIn);
        c.func_74782_a(NBT_PROCESSOR, (NBTBase)this.processor.writeToNBT());
        c.func_74777_a(NBT_LOAD_TIME, (short)this.loadTime);
        ItemStackHelper.func_191282_a((NBTTagCompound)c, this.codeItemStacks);
        if (this.func_145818_k_()) {
            c.func_74778_a(NBT_CUSTOM_NAME, this.customName);
        }
        return c;
    }

    public void func_73660_a() {
        boolean isInactive;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.overClocked && this.field_145850_b.func_82737_E() % 2L != 0L) {
            return;
        }
        boolean bl = isInactive = this.processor.isWait() || this.processor.isFault();
        if (this.prevIsInactive != isInactive) {
            this.prevIsInactive = isInactive;
            int priority = -1;
            this.field_145850_b.func_175654_a(this.field_174879_c, (Block)BlockMinecoprocessor.INSTANCE, 0, priority);
        }
        if (!this.loaded) {
            Processor.reset(this.prevPortValues);
            this.prevPortsRegister = (byte)15;
            BlockMinecoprocessor.updateInputPorts(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c));
            this.loaded = true;
        }
        if (this.processor.tick()) {
            this.updatePlayers();
            this.detectOutputChanges();
        }
        if (this.prevPortsRegister != this.processor.getRegisters()[Register.PORTS.ordinal()]) {
            BlockMinecoprocessor.updateInputPorts(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c));
            this.prevPortsRegister = this.processor.getRegisters()[Register.PORTS.ordinal()];
        }
    }

    public void updatePlayers() {
        for (EntityPlayerMP player : this.playersToUpdate) {
            Minecoprocessors.NETWORK.sendTo((IMessage)new MessageProcessorUpdate(this.processor.writeToNBT(), this.field_174879_c, this.func_70005_c_()), player);
        }
    }

    private void detectOutputChanges() {
        this.detectOutputChange(0);
        this.detectOutputChange(1);
        this.detectOutputChange(2);
        this.detectOutputChange(3);
    }

    private boolean detectOutputChange(int portIndex) {
        byte[] registers = this.processor.getRegisters();
        byte ports = registers[Register.PORTS.ordinal()];
        byte curVal = registers[Register.PF.ordinal() + portIndex];
        if (TileEntityMinecoprocessor.isInOutputMode(ports, portIndex) && this.prevPortValues[portIndex] != curVal) {
            this.prevPortValues[portIndex] = curVal;
            BlockMinecoprocessor.INSTANCE.onPortChange(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), portIndex);
            return true;
        }
        return false;
    }

    public boolean updateInputPorts(int[] values) {
        boolean updated = false;
        for (int i = 0; i < 4; ++i) {
            updated = this.updateInputPort(i, values[i]) || updated;
        }
        if (updated) {
            this.processor.wake();
        }
        return updated;
    }

    public static boolean isInInputMode(byte ports, int portIndex) {
        return ByteUtil.getBit(ports, portIndex) && !ByteUtil.getBit(ports, portIndex + 4);
    }

    public static boolean isInOutputMode(byte ports, int portIndex) {
        return !ByteUtil.getBit(ports, portIndex) && !ByteUtil.getBit(ports, portIndex + 4);
    }

    public static boolean isADCMode(byte adc, int portIndex) {
        return ByteUtil.getBit(adc, portIndex);
    }

    public static boolean isInResetMode(byte ports, int portIndex) {
        return ByteUtil.getBit(ports, portIndex) && ByteUtil.getBit(ports, portIndex + 4);
    }

    private boolean updateInputPort(int portIndex, int powerValue) {
        byte[] registers = this.processor.getRegisters();
        byte ports = registers[Register.PORTS.ordinal()];
        byte adc = registers[Register.ADC.ordinal()];
        byte value = TileEntityMinecoprocessor.isADCMode(adc, portIndex) ? RedstoneUtil.powerToPort(powerValue) : (powerValue == 0 ? (byte)0 : -1);
        if (TileEntityMinecoprocessor.isInInputMode(ports, portIndex) && this.prevPortValues[portIndex] != value) {
            this.prevPortValues[portIndex] = value;
            registers[Register.PF.ordinal() + portIndex] = value;
            return true;
        }
        if (TileEntityMinecoprocessor.isInResetMode(ports, portIndex) && this.prevPortValues[portIndex] != value) {
            this.prevPortValues[portIndex] = value;
            if (value != 0) {
                this.processor.reset();
                return true;
            }
        }
        return false;
    }

    private byte getPortSignal(int portIndex) {
        if (!TileEntityMinecoprocessor.isInOutputMode(this.processor.getRegisters()[Register.PORTS.ordinal()], portIndex)) {
            return 0;
        }
        byte signal = this.processor.getRegisters()[Register.PF.ordinal() + portIndex];
        if (!TileEntityMinecoprocessor.isADCMode(this.processor.getRegisters()[Register.ADC.ordinal()], portIndex)) {
            return signal == 0 ? (byte)0 : -1;
        }
        return signal;
    }

    public byte getFrontPortSignal() {
        return this.getPortSignal(0);
    }

    public byte getBackPortSignal() {
        return this.getPortSignal(1);
    }

    public byte getLeftPortSignal() {
        return this.getPortSignal(2);
    }

    public byte getRightPortSignal() {
        return this.getPortSignal(3);
    }

    public void reset() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.processor.reset();
        for (int portIndex = 0; portIndex < 4; ++portIndex) {
            this.detectOutputChange(portIndex);
        }
        this.loaded = false;
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.codeItemStacks.size() ? (ItemStack)this.codeItemStacks.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        this.func_70296_d();
        return ItemStackHelper.func_188382_a(this.codeItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        this.func_70296_d();
        return ItemStackHelper.func_188383_a(this.codeItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index != 0) {
            return;
        }
        this.codeItemStacks.set(index, (Object)stack);
        if (stack.func_190926_b()) {
            this.unloadBook();
        } else {
            this.loadBook(stack);
        }
        this.func_70296_d();
    }

    private void unloadBook() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.processor.load(null);
        this.loaded = false;
        this.setName(null);
        this.updatePlayers();
    }

    private static void addLines(List<String> lines, String toAdd) {
        for (String s : toAdd.split("\\n\\r?")) {
            lines.add(s);
        }
    }

    private void loadBook(ItemStack stack) {
        List<String> code;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!TileEntityMinecoprocessor.isBook(stack.func_77973_b()) || !stack.func_77942_o()) {
            return;
        }
        NBTTagList pages = stack.func_77978_p().func_150295_c("pages", 8);
        if (pages == null) {
            return;
        }
        boolean signed = stack.func_77978_p().func_74764_b("author");
        JsonParser parser = null;
        if (ItemBookCode.isBookCode(stack)) {
            code = ItemBookCode.Data.loadFromStack(stack).getContinuousProgram();
        } else {
            code = new ArrayList<String>(pages.func_74745_c());
            for (int i = 0; i < pages.func_74745_c(); ++i) {
                if (signed) {
                    if (parser == null) {
                        parser = new JsonParser();
                    }
                    JsonObject o = parser.parse(pages.func_150307_f(i)).getAsJsonObject();
                    TileEntityMinecoprocessor.addLines(code, o.get("text").getAsString());
                    continue;
                }
                TileEntityMinecoprocessor.addLines(code, pages.func_150307_f(i));
            }
        }
        this.updateNameFromCode(code);
        this.processor.load(code);
        this.loaded = false;
        this.updatePlayers();
    }

    private void updateNameFromCode(List<String> code) {
        String name = TileEntityMinecoprocessor.readNameFromHeader(code);
        if ("".equals(name)) {
            this.setName(null);
        } else {
            this.setName(name);
        }
    }

    public static String readNameFromHeader(List<String> code) {
        try {
            List<String> nameSearch = InstructionUtil.regex("^\\s*;\\s*(.*)", code.get(0), 2);
            if (nameSearch.size() != 1) {
                return null;
            }
            String name = nameSearch.get(0);
            if (name != null && !name.isEmpty()) {
                return name;
            }
        }
        catch (Exception e) {
            Minecoprocessors.proxy.handleUnexpectedException(e);
        }
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public static boolean isBook(Item item) {
        return item == ItemBookCode.INSTANCE || item == Items.field_151099_bA || item == Items.field_151164_bB;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return TileEntityMinecoprocessor.isBook(stack.func_77973_b());
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 1;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.minecoprocessor";
    }

    public void setName(String name) {
        this.customName = name;
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70302_i_() {
        return this.codeItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.codeItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_174888_l() {
        this.codeItemStacks.clear();
        this.func_70296_d();
    }

    public void enablePlayerGuiUpdates(EntityPlayerMP player, boolean enable) {
        if (enable) {
            this.playersToUpdate.add(player);
            this.updatePlayers();
        } else {
            this.playersToUpdate.remove(player);
        }
    }

    public Processor getProcessor() {
        return this.processor;
    }
}

