/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class BookCreator {
    private static final String PATH = "/assets/minecoprocessors/books/";
    private static final String PAGE_DELIMITER = "~~~";
    public static final ItemStack manual;

    private static ItemStack loadBook(String name) throws IOException {
        ItemStack book = new ItemStack(Items.field_151164_bB);
        int lineNumber = 1;
        StringBuilder page = BookCreator.newPage();
        try (BufferedReader reader = BookCreator.openBookReader(name);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (lineNumber == 1) {
                    book.func_77983_a("title", (NBTBase)new NBTTagString(line));
                } else if (lineNumber == 2) {
                    book.func_77983_a("author", (NBTBase)new NBTTagString(line));
                } else if (PAGE_DELIMITER.equals(line)) {
                    BookCreator.writePage(book, page);
                    page = BookCreator.newPage();
                } else {
                    page.append(line).append("\n");
                }
                ++lineNumber;
            }
        }
        BookCreator.writePage(book, page);
        return book;
    }

    private static BufferedReader openBookReader(String name) throws FileNotFoundException {
        String path = PATH + name + ".txt";
        InputStream is = BookCreator.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("Book file not found [" + path + "]");
        }
        return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    private static void writePage(ItemStack book, StringBuilder page) {
        NBTTagList pages = BookCreator.getPagesNbt(book);
        pages.func_74742_a((NBTBase)BookCreator.createPage(page.toString()));
        book.func_77983_a("pages", (NBTBase)pages);
    }

    private static NBTTagList getPagesNbt(ItemStack book) {
        if (book.func_77978_p() == null) {
            book.func_77982_d(new NBTTagCompound());
        }
        return book.func_77978_p().func_150295_c("pages", 8);
    }

    private static StringBuilder newPage() {
        return new StringBuilder(256);
    }

    private static NBTTagString createPage(String page) {
        return new NBTTagString(ITextComponent.Serializer.func_150696_a((ITextComponent)new TextComponentString(page)));
    }

    static {
        try {
            manual = BookCreator.loadBook("manual");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

