/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors;

import net.minecraftforge.common.ForgeConfigSpec;
import net.torocraft.minecoprocessors.ModMinecoprocessors;
import org.apache.commons.lang3.tuple.Pair;

public class ModConfig {
    private static final String MODID = "minecoprocessors";
    public static final CommonConfig COMMON;
    public static final ServerConfig SERVER;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec COMMON_CONFIG_SPEC;
    public static final ForgeConfigSpec SERVER_CONFIG_SPEC;
    public static final ForgeConfigSpec CLIENT_CONFIG_SPEC;
    public static int maxColumnsPerLine;
    public static int maxLinesPerPage;
    public static int codeBookTextColor;
    public static int codeBookSelectedTextColor;
    public static int codeBookSelectedBackgroundColor;
    public static int codeBookInstructionNoColor;
    public static int maxUndoSteps;

    public static void onLoad(net.minecraftforge.fml.config.ModConfig config) {
        try {
            ModConfig.apply();
        }
        catch (Exception ex) {
            ModMinecoprocessors.logger().error("Failed to apply config file data {}", (Object)config.getFileName());
        }
    }

    public static void onFileChange(net.minecraftforge.fml.config.ModConfig config) {
    }

    public static final void apply() {
        maxColumnsPerLine = (Integer)ModConfig.CLIENT.code_book_max_columns_per_line.get();
    }

    static {
        Pair common_ = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_CONFIG_SPEC = (ForgeConfigSpec)common_.getRight();
        COMMON = (CommonConfig)common_.getLeft();
        Pair server_ = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_CONFIG_SPEC = (ForgeConfigSpec)server_.getRight();
        SERVER = (ServerConfig)server_.getLeft();
        Pair client_ = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_CONFIG_SPEC = (ForgeConfigSpec)client_.getRight();
        CLIENT = (ClientConfig)client_.getLeft();
        maxColumnsPerLine = 20;
        maxLinesPerPage = 20;
        codeBookTextColor = -13421773;
        codeBookSelectedTextColor = -1118482;
        codeBookSelectedBackgroundColor = -869059687;
        codeBookInstructionNoColor = -5592406;
        maxUndoSteps = 8;
    }

    public static class CommonConfig {
        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings affecting the logical server side, but are also configurable in single player.").push("server");
            builder.pop();
        }
    }

    public static class ServerConfig {
        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings not loaded on clients.").push("server");
            builder.pop();
        }
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.IntValue code_book_max_columns_per_line;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings not loaded on servers.").push("client");
            this.code_book_max_columns_per_line = builder.translation("minecoprocessors.config.code_book_max_columns_per_line").comment("Defines the maximum line length in the Code Book.").defineInRange("code_book_max_columns_per_line", 18, 10, 80);
            builder.pop();
        }
    }
}

