/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.torocraft.minecoprocessors.ModConfig;
import net.torocraft.minecoprocessors.ModContent;
import net.torocraft.minecoprocessors.network.Networking;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="minecoprocessors")
public class ModMinecoprocessors {
    public static final String MODID = "minecoprocessors";
    public static final String MODNAME = "Minecoprocessors";
    public static final int VERSION_DATAFIXER = 0;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ISidedProxy proxy = (ISidedProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final ItemGroup ITEMGROUP = new ItemGroup("tabminecoprocessors"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModContent.MINECOPROCESSOR);
        }
    };

    public ModMinecoprocessors() {
        ModMinecoprocessors.logGitVersion();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ModConfig.CLIENT_CONFIG_SPEC);
    }

    public static final Logger logger() {
        return LOGGER;
    }

    public static void logGitVersion() {
        try {
            InputStream is = ModMinecoprocessors.class.getResourceAsStream("/.gitversion-minecoprocessors");
            if (is == null) {
                return;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String version = br.lines().collect(Collectors.joining("\n"));
            LOGGER.info(MODNAME + (version.isEmpty() ? " (dev build)" : " GIT id #" + version) + ".");
        }
        finally {
            return;
        }
    }

    public static final class ServerProxy
    implements ISidedProxy {
        @Override
        @Nullable
        public PlayerEntity getPlayerClientSide() {
            return null;
        }

        @Override
        @Nullable
        public World getWorldClientSide() {
            return null;
        }

        @Override
        @Nullable
        public Minecraft mc() {
            return null;
        }
    }

    public static final class ClientProxy
    implements ISidedProxy {
        private static boolean toldPlayerAboutException = false;

        @Override
        @Nullable
        public PlayerEntity getPlayerClientSide() {
            return Minecraft.func_71410_x().field_71439_g;
        }

        @Override
        @Nullable
        public World getWorldClientSide() {
            return Minecraft.func_71410_x().field_71441_e;
        }

        @Override
        @Nullable
        public Minecraft mc() {
            return Minecraft.func_71410_x();
        }

        @Override
        public void handleUnexpectedException(Exception e) {
            if (!toldPlayerAboutException) {
                toldPlayerAboutException = true;
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TranslationTextComponent("minecoprocessors.error_chat", new Object[0]));
            }
        }
    }

    public static interface ISidedProxy {
        @Nullable
        default public PlayerEntity getPlayerClientSide() {
            return null;
        }

        @Nullable
        default public World getWorldClientSide() {
            return null;
        }

        @Nullable
        default public Minecraft mc() {
            return null;
        }

        default public void handleUnexpectedException(Exception e) {
            e.printStackTrace();
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class ForgeEvents {
        @SubscribeEvent
        public static final void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            ModContent.registerBlocks(event);
        }

        @SubscribeEvent
        public static final void onItemRegistry(RegistryEvent.Register<Item> event) {
            ModContent.registerBlockItems(event);
            ModContent.registerItems(event);
        }

        @SubscribeEvent
        public static final void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
            ModContent.registerTileEntities(event);
        }

        @SubscribeEvent
        public static final void onRegisterContainerTypes(RegistryEvent.Register<ContainerType<?>> event) {
            ModContent.registerContainers(event);
        }

        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
            ModConfig.apply();
            Networking.init();
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ModContent.registerGuis(event);
        }

        @SubscribeEvent
        public static void onConfigLoad(ModConfig.Loading event) {
            ModConfig.onLoad(event.getConfig());
        }

        @SubscribeEvent
        public static void onConfigChanged(ModConfig.ConfigReloading event) {
            ModConfig.onFileChange(event.getConfig());
        }
    }
}

