/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.blocks;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.torocraft.minecoprocessors.ModContent;
import net.torocraft.minecoprocessors.blocks.MinecoprocessorTileEntity;
import net.torocraft.minecoprocessors.network.Networking;
import net.torocraft.minecoprocessors.processor.Processor;

public class MinecoprocessorContainer
extends Container
implements Networking.INetworkSynchronisableContainer {
    private static final int PLAYER_INV_START_SLOTNO = 1;
    private final IInventory inventory_;
    private final PlayerEntity player_;
    private final IWorldPosCallable wpc_;
    private final MinecoprocessorTileEntity.ContainerSyncFields fields_;
    private final Processor processor_;
    private String name_ = new String();
    private String transl_ = new String();
    private String error_ = new String();
    private CompoundNBT nbt_ = new CompoundNBT();
    private byte fault_code_ = 0;
    private boolean loaded_state_ = false;
    private boolean resync_pending_ = false;

    public MinecoprocessorContainer(int cid, PlayerInventory player_inventory) {
        this(cid, player_inventory, (IInventory)new Inventory(1), IWorldPosCallable.field_221489_a, new MinecoprocessorTileEntity.ContainerSyncFields(), new Processor());
    }

    public MinecoprocessorContainer(int cid, PlayerInventory player_inventory, IInventory block_inventory, IWorldPosCallable wpc, MinecoprocessorTileEntity.ContainerSyncFields fields, Processor processor) {
        super(ModContent.CT_MINECOPROCESSOR, cid);
        this.fields_ = fields;
        this.wpc_ = wpc;
        this.player_ = player_inventory.field_70458_d;
        this.inventory_ = block_inventory;
        this.processor_ = processor;
        int i = -1;
        this.func_75146_a(new Slot(this.inventory_, ++i, 80, 35){

            public boolean func_75214_a(ItemStack stack) {
                return MinecoprocessorTileEntity.isValidBook(stack);
            }
        });
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)player_inventory, x, 8 + x * 18, 142));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)player_inventory, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        this.func_216961_a((IIntArray)this.fields_);
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.inventory_.func_70300_a(player);
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return false;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        Slot slot = this.func_75139_a(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack slot_stack = slot.func_75211_c();
        ItemStack transferred = slot_stack.func_77946_l();
        if (index >= 0 && index < 1) {
            if (!this.func_75135_a(slot_stack, 1, 37, false)) {
                return ItemStack.field_190927_a;
            }
        } else if (index >= 1 && index <= 37) {
            if (!this.func_75135_a(slot_stack, 0, 1, false)) {
                return ItemStack.field_190927_a;
            }
        } else {
            return ItemStack.field_190927_a;
        }
        if (slot_stack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        slot.func_190901_a(player, slot_stack);
        return transferred;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onGuiAction(CompoundNBT nbt) {
        Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onGuiAction(String key, int value) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a(key, value);
        Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
    }

    @Override
    public void onClientPacketReceived(int windowId, PlayerEntity player, CompoundNBT nbt) {
        MinecoprocessorTileEntity te = this.getTe();
        if (te == null) {
            return;
        }
        boolean dirty = false;
        if (nbt.func_74764_b("sleep")) {
            dirty = true;
            te.getProcessor().setWait(!te.getProcessor().isWait());
        }
        if (nbt.func_74764_b("reset")) {
            dirty = true;
            te.resetProcessor();
        }
        if (nbt.func_74764_b("step")) {
            dirty = true;
            te.getProcessor().setStep(true);
        }
        if (nbt.func_74764_b("sync")) {
            Networking.PacketContainerSyncServerToClient.sendToPlayer(player, this.field_75152_c, this.getSyncData());
        }
        if (dirty) {
            te.func_70296_d();
        }
    }

    @Override
    public void onServerPacketReceived(int windowId, CompoundNBT nbt) {
        this.resync_pending_ = false;
        if (nbt.func_74764_b("sync_data")) {
            this.nbt_ = nbt.func_74775_l("sync_data");
            if (this.nbt_.func_74764_b("name")) {
                this.name_ = this.nbt_.func_74779_i("name");
            }
            if (this.nbt_.func_74764_b("error")) {
                this.error_ = this.nbt_.func_74779_i("error");
            }
            if (this.nbt_.func_74764_b("transl")) {
                this.transl_ = this.nbt_.func_74779_i("transl");
            }
            if (this.nbt_.func_74764_b("processor")) {
                this.processor_.setNBT(this.nbt_.func_74775_l("processor"));
            }
        }
    }

    public MinecoprocessorTileEntity getTe() {
        return this.inventory_ instanceof MinecoprocessorTileEntity ? (MinecoprocessorTileEntity)this.inventory_ : null;
    }

    public MinecoprocessorTileEntity.ContainerSyncFields getFields() {
        return this.fields_;
    }

    public String getDisplayName() {
        if (!this.name_.isEmpty() && this.getFields().isLoaded()) {
            return this.name_;
        }
        if (this.transl_.isEmpty()) {
            return "Processor";
        }
        return new TranslationTextComponent(this.transl_, new Object[0]).func_150261_e();
    }

    public Processor getProcessor() {
        return this.processor_;
    }

    public String getProcessorError() {
        return this.error_;
    }

    private CompoundNBT getSyncData() {
        CompoundNBT msg = new CompoundNBT();
        MinecoprocessorTileEntity te = this.getTe();
        if (te == null) {
            return msg;
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("name", te.func_145818_k_() ? te.func_200201_e().getString() : "");
        nbt.func_74778_a("error", te.getProcessor().getError());
        nbt.func_74778_a("transl", te.func_195044_w().func_177230_c().func_149739_a());
        nbt.func_218657_a("processor", (INBT)this.processor_.getNBT());
        msg.func_218657_a("sync_data", (INBT)nbt);
        return msg;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkResync() {
        if (this.resync_pending_) {
            return;
        }
        if (this.fields_.isLoaded() != this.loaded_state_ || this.fields_.fault() != this.fault_code_) {
            this.fault_code_ = this.fields_.fault();
            this.loaded_state_ = this.fields_.isLoaded();
            if (this.fault_code_ == 0) {
                this.error_ = "";
            }
            this.resync_pending_ = true;
            this.onGuiAction("sync", 1);
        }
    }
}

