/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.blocks;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ReadBookScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.torocraft.minecoprocessors.ModMinecoprocessors;
import net.torocraft.minecoprocessors.blocks.MinecoprocessorContainer;
import net.torocraft.minecoprocessors.blocks.MinecoprocessorTileEntity;
import net.torocraft.minecoprocessors.processor.Processor;
import net.torocraft.minecoprocessors.processor.Register;
import net.torocraft.minecoprocessors.util.BookCreator;
import net.torocraft.minecoprocessors.util.GuiWidgets;
import net.torocraft.minecoprocessors.util.InstructionUtil;
import net.torocraft.minecoprocessors.util.StringUtil;

@OnlyIn(value=Dist.CLIENT)
public class MinecoprocessorGui
extends ContainerScreen<MinecoprocessorContainer> {
    private static final ResourceLocation BACKGROUND_IMAGE = new ResourceLocation("minecoprocessors", "textures/gui/minecoprocessor.png");
    private static final double GUI_SCALE = 0.5;
    private Button buttonSleep;
    private Button buttonStep;
    private Button buttonReset;
    private Button buttonHelp;
    private final PlayerEntity player_;
    private final List<String> hoveredFeature = new ArrayList<String>(5);

    public MinecoprocessorGui(MinecoprocessorContainer container, PlayerInventory player_inventory, ITextComponent title) {
        super((Container)container, player_inventory, title);
        this.player_ = player_inventory.field_70458_d;
    }

    public void init() {
        super.init();
        int x0 = this.getGuiLeft();
        int y0 = this.getGuiTop();
        int w = 49;
        int h = 10;
        this.buttons.clear();
        this.buttonSleep = (Button)this.addButton((Widget)new GuiWidgets.ScaledButton(0.5, x0 + 8, y0 + 34 + 0, 49, 10, new TranslationTextComponent("minecoprocessors.gui.button.sleep", new Object[0]).func_150254_d(), bt -> ((MinecoprocessorContainer)this.func_212873_a_()).onGuiAction("sleep", 1)));
        this.buttons.add(this.buttonSleep);
        this.buttonReset = (Button)this.addButton((Widget)new GuiWidgets.ScaledButton(0.5, x0 + 8, y0 + 34 + 12, 49, 10, new TranslationTextComponent("minecoprocessors.gui.button.reset", new Object[0]).func_150254_d(), bt -> ((MinecoprocessorContainer)this.func_212873_a_()).onGuiAction("reset", 1)));
        this.buttons.add(this.buttonReset);
        this.buttonStep = (Button)this.addButton((Widget)new GuiWidgets.ScaledButton(0.5, x0 + 8, y0 + 34 + 24, 49, 10, new TranslationTextComponent("minecoprocessors.gui.button.step", new Object[0]).func_150254_d(), bt -> ((MinecoprocessorContainer)this.func_212873_a_()).onGuiAction("step", 1)));
        this.buttons.add(this.buttonStep);
        this.buttonHelp = (Button)this.addButton((Widget)new GuiWidgets.ScaledButton(0.5, x0 + 133, y0 + 66, 35, 10, new TranslationTextComponent("minecoprocessors.gui.button.help", new Object[0]).func_150254_d(), bt -> Minecraft.func_71410_x().func_147108_a((Screen)new ReadBookScreen(ReadBookScreen.IBookInfo.func_216917_a((ItemStack)BookCreator.getManual())))));
        this.buttons.add(this.buttonHelp);
        this.buttonStep.active = false;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        ((MinecoprocessorContainer)this.func_212873_a_()).checkResync();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(BACKGROUND_IMAGE);
        int x0 = this.getGuiLeft();
        int y0 = this.getGuiTop();
        int w = this.getXSize();
        int h = this.getYSize();
        this.blit(x0, y0, 0, 0, w, h);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.hoveredFeature.clear();
        MinecoprocessorTileEntity.ContainerSyncFields fields = ((MinecoprocessorContainer)this.func_212873_a_()).getFields();
        GlStateManager.pushMatrix();
        GlStateManager.scaled((double)0.5, (double)0.5, (double)0.5);
        mouseX = (int)((double)(mouseX - this.getGuiLeft()) / 0.5);
        mouseY = (int)((double)(mouseY - this.getGuiTop()) / 0.5);
        int y = 50;
        this.drawRegister(Register.A, 260, y, mouseX, mouseY);
        this.drawRegister(Register.B, 278, y, mouseX, mouseY);
        this.drawRegister(Register.C, 296, y, mouseX, mouseY);
        this.drawRegister(Register.D, 314, y, mouseX, mouseY);
        y = 82;
        this.drawFlag("Z", fields.isZero(), 260, y, mouseX, mouseY);
        this.drawFlag("C", fields.isCarry() || fields.isOverflow(), 278, y, mouseX, mouseY);
        this.drawFlag("F", fields.isFault(), 296, y, 0xFF0000, mouseX, mouseY);
        this.drawFlag("S", fields.isWait(), 314, y, 65280, mouseX, mouseY);
        y = 114;
        boolean mouseIsOver = this.drawLabeledValue("IP", StringUtil.toHex(fields.ip()), 256, y, null, mouseX, mouseY);
        if (mouseIsOver) {
            this.hoveredFeature.add("Instruction Pointer");
        }
        this.drawRegister(Register.ADC, 284, y, mouseX, mouseY);
        this.drawRegister(Register.PORTS, 316, y, mouseX, mouseY);
        this.drawPortRegister(Register.PF, 176, 47, mouseX, mouseY);
        this.drawPortRegister(Register.PR, 216, 86, mouseX, mouseY);
        this.drawPortRegister(Register.PL, 137, 86, mouseX, mouseY);
        this.drawPortRegister(Register.PB, 176, 125, mouseX, mouseY);
        this.drawCode();
        this.drawGuiTitle();
        GlStateManager.popMatrix();
        if (fields.isWait()) {
            this.buttonSleep.setMessage(new TranslationTextComponent("minecoprocessors.gui.button.wake", new Object[0]).func_150254_d());
            this.buttonStep.active = true;
        } else {
            this.buttonSleep.setMessage(new TranslationTextComponent("minecoprocessors.gui.button.sleep", new Object[0]).func_150254_d());
            this.buttonStep.active = false;
        }
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        super.func_191948_b(mouseX, mouseY);
        if (!this.hoveredFeature.isEmpty()) {
            GlStateManager.pushMatrix();
            GlStateManager.scaled((double)0.5, (double)0.5, (double)0.5);
            this.renderTooltip(this.hoveredFeature, (int)((double)mouseX / 0.5), (int)((double)mouseY / 0.5));
            GlStateManager.popMatrix();
        }
    }

    private void drawRegister(Register register, int x, int y, int mouseX, int mouseY) {
        byte value;
        String label = register.toString();
        boolean mouseIsOver = this.drawLabeledValue(label, StringUtil.toHex(value = ((MinecoprocessorContainer)this.func_212873_a_()).getFields().register(register.ordinal() - Register.A.ordinal())), x, y, null, mouseX, mouseY);
        if (mouseIsOver) {
            this.hoveredFeature.add(label + " Register");
            if (Register.PORTS.equals((Object)register)) {
                this.hoveredFeature.add("I/O port direction");
            } else if (Register.ADC.equals((Object)register)) {
                this.hoveredFeature.add("ADC/DAC switch");
            } else {
                this.hoveredFeature.add("General Purpose");
            }
            this.hoveredFeature.add(String.format("0x%s %sb %s", StringUtil.toHex(value), StringUtil.toBinary(value), Integer.toString(value, 10)));
        }
    }

    private void drawPortRegister(Register register, int x, int y, int mouseX, int mouseY) {
        int portIndex;
        MinecoprocessorTileEntity.ContainerSyncFields fields = ((MinecoprocessorContainer)this.func_212873_a_()).getFields();
        byte value = fields.port(portIndex = register.ordinal() - Register.PF.ordinal());
        boolean mouseIsOver = this.centered(StringUtil.toHex(value), x, y, mouseX, mouseY);
        if (mouseIsOver) {
            switch (register) {
                case PF: {
                    this.hoveredFeature.add("Front Port - PF");
                    break;
                }
                case PB: {
                    this.hoveredFeature.add("Back Port - PB");
                    break;
                }
                case PL: {
                    this.hoveredFeature.add("Left Port - PL");
                    break;
                }
                case PR: {
                    this.hoveredFeature.add("Right Port - PR");
                }
            }
            if (MinecoprocessorTileEntity.isInOutputMode(fields.ports(), portIndex)) {
                this.hoveredFeature.add("Output Port");
            } else if (MinecoprocessorTileEntity.isInInputMode(fields.ports(), portIndex)) {
                this.hoveredFeature.add("Input Port");
            } else if (MinecoprocessorTileEntity.isInResetMode(fields.ports(), portIndex)) {
                this.hoveredFeature.add("Reset Port");
            }
            if (MinecoprocessorTileEntity.isADCMode(fields.adc(), portIndex)) {
                this.hoveredFeature.add("Analog Mode");
            } else {
                this.hoveredFeature.add("Digital Mode");
            }
            this.hoveredFeature.add(String.format("0x%s %sb %s", StringUtil.toHex(value), StringUtil.toBinary(value), Integer.toString(value, 10)));
        }
    }

    private void drawFlag(String label, Boolean flag, int x, int y, int mouseX, int mouseY) {
        this.drawFlag(label, flag, x, y, null, mouseX, mouseY);
    }

    private void drawFlag(String label, Boolean flag, int x, int y, Integer flashColor, int mouseX, int mouseY) {
        boolean mouseIsOver;
        if (flag == null) {
            flag = false;
        }
        if (mouseIsOver = this.drawLabeledValue(label, flag != false ? "1" : "0", x, y, flag != false ? flashColor : null, mouseX, mouseY)) {
            switch (label) {
                case "Z": {
                    this.hoveredFeature.add("Zero Flag");
                    break;
                }
                case "C": {
                    this.hoveredFeature.add("Carry Flag");
                    break;
                }
                case "F": {
                    this.hoveredFeature.add("Fault Indicator");
                    this.hoveredFeature.add("STATUS 0x" + StringUtil.toHex(((MinecoprocessorContainer)this.func_212873_a_()).getFields().fault()).toUpperCase());
                    break;
                }
                case "S": {
                    this.hoveredFeature.add("Sleep Indicator");
                }
            }
            this.hoveredFeature.add(Boolean.toString(flag).toUpperCase());
        }
    }

    private boolean drawLabeledValue(String label, String value, int x, int y, Integer flashColor, int mouseX, int mouseY) {
        int wMax;
        int wLabel = this.font.func_78256_a(label) / 2;
        int wValue = 0;
        if (!value.isEmpty()) {
            wValue = this.font.func_78256_a(value) / 2;
        }
        int color = 0xFFFFFF;
        if (flashColor != null && (ModMinecoprocessors.proxy.getWorldClientSide().func_82737_E() & 0xFL) < 4L) {
            color = flashColor;
        }
        this.font.func_211126_b(label, (float)(x - wLabel), (float)(y - 14), 0x404040);
        if (!value.isEmpty()) {
            this.font.func_211126_b(value, (float)(x - wValue), (float)y, color);
        }
        boolean mouseIsOver = mouseX > x - (wMax = Math.max(wLabel, wValue)) && mouseX < x + wMax;
        mouseIsOver = mouseIsOver && mouseY > y - 14 && mouseY < y + 14;
        return mouseIsOver;
    }

    private boolean centered(String s, float x, float y, int mouseX, int mouseY) {
        int hWidth = this.font.func_78256_a(s) / 2;
        this.font.getClass();
        int hHeight = 9 / 2;
        int xs = (int)x - hWidth;
        int ys = (int)y - hHeight;
        this.font.func_211126_b(s, (float)xs, (float)ys, 0xFFFFFF);
        boolean mouseIsOver = (float)mouseX > x - (float)hWidth && (float)mouseX < x + (float)hWidth;
        mouseIsOver = mouseIsOver && (float)mouseY > y - (float)hHeight - 2.0f && (float)mouseY < y + (float)hHeight + 2.0f;
        return mouseIsOver;
    }

    private void drawGuiTitle() {
        String s = ((MinecoprocessorContainer)this.func_212873_a_()).getDisplayName();
        this.font.func_211126_b(s, (float)this.getXSize() - 0.5f * (float)this.font.func_78256_a(s), 10.0f, 0x404040);
    }

    private void drawCode() {
        int x = 22;
        int y = 50;
        String label = "NEXT";
        String value = "";
        int color = 0xFFFFFF;
        if (!((MinecoprocessorContainer)this.func_212873_a_()).getProcessorError().isEmpty() || ((MinecoprocessorContainer)this.func_212873_a_()).getFields().isFault()) {
            label = "ERROR";
            value = ((MinecoprocessorContainer)this.func_212873_a_()).getProcessorError();
            color = 0xFF0000;
        } else if (((MinecoprocessorContainer)this.func_212873_a_()).getFields().isLoaded()) {
            Processor processor = ((MinecoprocessorContainer)this.func_212873_a_()).getProcessor();
            byte[] a = null;
            if (processor != null) {
                try {
                    short ip = ((MinecoprocessorContainer)this.func_212873_a_()).getFields().ip();
                    List<byte[]> program = processor.getProgram();
                    if (ip < program.size()) {
                        a = program.get(ip);
                    }
                }
                catch (Exception e) {
                    ModMinecoprocessors.proxy.handleUnexpectedException(e);
                }
            }
            if (a != null) {
                value = InstructionUtil.compileLine(a, processor.getLabels(), (short)-1);
            }
        }
        this.font.func_211126_b(label, (float)(x - 4), (float)(y - 14), 0x404040);
        this.font.func_211126_b(value, (float)x, (float)y, color);
    }
}

