/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.items;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.torocraft.minecoprocessors.ModContent;
import net.torocraft.minecoprocessors.items.CodeBookItem;
import net.torocraft.minecoprocessors.network.Networking;

public class CodeBookContainer
extends Container
implements Networking.INetworkSynchronisableContainer {
    private PlayerEntity player;
    private PlayerInventory inventory;
    private final ItemStack book;
    private CodeBookItem.Data data = new CodeBookItem.Data();
    public boolean saved = false;
    public boolean close = false;

    public CodeBookContainer(int cid, PlayerInventory player_inventory) {
        this(cid, player_inventory, player_inventory.field_70458_d);
    }

    public CodeBookContainer(int cid, PlayerInventory player_inventory, PlayerEntity player) {
        super(ModContent.CT_CODEBOOK, cid);
        this.inventory = player_inventory;
        this.player = player;
        if (player_inventory.field_70461_c < 0 || player_inventory.field_70461_c >= player_inventory.func_70302_i_()) {
            this.close = true;
            this.book = new ItemStack((IItemProvider)Items.field_190931_a);
        } else {
            this.book = player_inventory.func_70301_a(player_inventory.field_70461_c);
        }
        if (this.book.func_77973_b() instanceof CodeBookItem) {
            this.data = CodeBookItem.Data.loadFromStack(this.book);
        } else {
            this.close = true;
        }
    }

    public boolean func_75145_c(PlayerEntity player) {
        return player == this.player;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void save() {
        this.saved = false;
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("bookdata", (INBT)this.data.writeNBT(new CompoundNBT()));
        Networking.PacketContainerSyncClientToServer.sendToServer(this, nbt);
    }

    @Override
    public void onClientPacketReceived(int windowId, PlayerEntity player, CompoundNBT nbt) {
        if (nbt.func_74764_b("bookdata")) {
            CompoundNBT booknbt = nbt.func_74775_l("bookdata");
            this.data.readNBT(booknbt);
            if (this.book.func_77973_b() instanceof CodeBookItem) {
                this.book.func_77982_d(booknbt);
                player.field_71071_by.func_70296_d();
                nbt = new CompoundNBT();
                nbt.func_74757_a("saved", true);
                Networking.PacketContainerSyncServerToClient.sendToPlayer(player, this, nbt);
            }
        }
    }

    @Override
    public void onServerPacketReceived(int windowId, CompoundNBT nbt) {
        if (nbt.func_74767_n("saved")) {
            this.saved = true;
            this.close = true;
        }
    }

    public CodeBookItem.Data getData() {
        return this.data;
    }
}

