/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.items;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.torocraft.minecoprocessors.ModConfig;
import net.torocraft.minecoprocessors.items.CodeBookContainer;
import net.torocraft.minecoprocessors.items.CodeBookItem;
import net.torocraft.minecoprocessors.util.InstructionUtil;
import net.torocraft.minecoprocessors.util.Label;
import net.torocraft.minecoprocessors.util.ParseException;
import net.torocraft.minecoprocessors.util.StringUtil;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class CodeBookGui
extends ContainerScreen<CodeBookContainer> {
    private static final ResourceLocation BACKGROUND_IMAGE = new ResourceLocation("minecoprocessors", "textures/gui/codebook_gui.png");
    private static final int MAX_LINES_PER_PAGE = 25;
    private static final int GUI_WIDTH = 180;
    private static final int GUI_HEIGHT = 230;
    private static final int BUTTON_PAGE_CHANGE_PREV_X = 28;
    private static final int BUTTON_PAGE_CHANGE_NEXT_X = 136;
    private static final int BUTTON_PAGE_CHANGE_Y = 224;
    private static final int BUTTON_PAGE_DELETE_X = 86;
    private static final int BUTTON_PAGE_DELETE_Y = 224;
    private static final int CODE_POS_X = 48;
    private static final int CODE_POS_Y = 16;
    private static final int CODE_WIDTH = 120;
    private static final int CODE_MARGIN = 10;
    private static final int CODE_POS_X_IP_HINT_OFFSET = -28;
    private static final int PAGE_NUMBER_X = 92;
    private static final int PAGE_NUMBER_Y = 212;
    private static final int BUTTON_CLOSE_X = 153;
    private static final int BUTTON_CLOSE_Y = 7;
    private ImageButton buttonNextPage;
    private ImageButton buttonPreviousPage;
    private ImageButton buttonDeletePage;
    private ImageButton buttonClose;
    private final CodeBookItem.Data data;
    private final List<StringBuilder> lines = new ArrayList<StringBuilder>();
    private final Deque<String> undoBuffer = new ArrayDeque<String>();
    private final List<String> redoBuffer = new ArrayList<String>();
    private final List<String> tooltip = new ArrayList<String>();
    private final List<ParseException> compileError = new ArrayList<ParseException>();
    private final List<Integer> instructionIds = new ArrayList<Integer>();
    private final PlayerEntity player;
    private final boolean isEditingCode = true;
    private int selectionStart = 0;
    private int selectionEnd = 0;
    private boolean hasMouseClicked = false;

    private static int getMaxColumns() {
        return MathHelper.func_76125_a((int)ModConfig.maxColumnsPerLine, (int)8, (int)20);
    }

    private static int getMaxLinesPerPage() {
        return MathHelper.func_76125_a((int)ModConfig.maxLinesPerPage, (int)12, (int)25);
    }

    private static int getCodeColor() {
        return ModConfig.codeBookTextColor;
    }

    private static int getSelectionColor() {
        return ModConfig.codeBookSelectedTextColor;
    }

    private static int getSelectionBackgroundColor() {
        return ModConfig.codeBookSelectedBackgroundColor;
    }

    private static int getInstructionNoColor() {
        return ModConfig.codeBookInstructionNoColor;
    }

    private static int getMaxUndoSteps() {
        return ModConfig.maxUndoSteps;
    }

    public CodeBookGui(CodeBookContainer container, PlayerInventory player_inventory, ITextComponent title) {
        super((Container)container, player_inventory, title);
        this.player = player_inventory.field_70458_d;
        this.data = container.getData();
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init() {
        super.init();
        this.field_146999_f = 180;
        this.field_147000_g = 230;
        this.field_147009_r = 2;
        this.field_147003_i = (this.width - this.field_146999_f) / 2;
        int x0 = this.getGuiLeft();
        int y0 = this.getGuiTop();
        this.buttons.clear();
        this.buttonPreviousPage = (ImageButton)this.addButton((Widget)new ImageButton(x0 + 28, y0 + 224, 20, 12, 220, 5, 12, BACKGROUND_IMAGE, bt -> this.changePage(-1)));
        this.buttons.add(this.buttonPreviousPage);
        this.buttonNextPage = (ImageButton)this.addButton((Widget)new ImageButton(x0 + 136, y0 + 224, 20, 12, 220, 30, 12, BACKGROUND_IMAGE, bt -> this.changePage(1)));
        this.buttons.add(this.buttonNextPage);
        this.buttonDeletePage = (ImageButton)this.addButton((Widget)new ImageButton(x0 + 86, y0 + 224, 12, 12, 220, 55, 12, BACKGROUND_IMAGE, bt -> this.removePage(this.data.getSelectedPage())));
        this.buttons.add(this.buttonDeletePage);
        this.buttonClose = (ImageButton)this.addButton((Widget)new ImageButton(x0 + 153, y0 + 7, 12, 12, 220, 80, 12, BACKGROUND_IMAGE, bt -> this.saveToServer()));
        this.buttons.add(this.buttonClose);
        this.rebuildLines();
        this.minecraft.field_195559_v.func_197967_a(true);
        this.selectionStart = this.selectionEnd = Math.max(0, this.pageCharacterCount());
    }

    public void onClose() {
        super.onClose();
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (((CodeBookContainer)this.field_147002_h).close) {
            this.minecraft.field_71439_g.func_71053_j();
            return;
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.tooltip.clear();
        this.renderBackground();
        this.buttonPreviousPage.visible = this.data.getSelectedPage() > 0 && this.data.getPageCount() > 0;
        this.buttonNextPage.visible = this.data.getSelectedPage() < this.data.getPageCount() - 1 || this.data.getSelectedPage() == this.data.getPageCount() - 1 && this.isCurrentProgramNonEmpty();
        this.buttonDeletePage.visible = this.data.getPageCount() > 1 || this.isCurrentProgramNonEmpty();
        super.render(mouseX, mouseY, partialTicks);
        if (!this.tooltip.isEmpty()) {
            this.renderTooltip(this.tooltip, mouseX, mouseY);
        } else {
            this.func_191948_b(mouseX, mouseY);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(BACKGROUND_IMAGE);
        int x0 = this.getGuiLeft();
        int y0 = this.getGuiTop();
        int w = this.getXSize();
        int h = this.getYSize();
        this.blit(x0, y0, 0, 0, w, h);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawProgram(mouseX, mouseY);
        this.drawPageInfo();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (Widget b : this.buttons) {
            if (!b.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        this.hasMouseClicked = true;
        if (this.isMouseInCodeArea((int)mouseX, (int)mouseY)) {
            int line = this.cursorToLine((int)mouseY);
            int column = this.cursorToColumn((int)mouseX, (int)mouseY);
            this.selectionStart = this.selectionEnd = this.positionToIndex(line, column);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean clicked = this.hasMouseClicked;
        this.hasMouseClicked = false;
        super.mouseReleased(mouseX, mouseY, button);
        if (clicked && this.isMouseInCodeArea((int)mouseX, (int)mouseY)) {
            int line = this.cursorToLine((int)mouseY);
            int column = this.cursorToColumn((int)mouseX, (int)mouseY);
            this.selectionEnd = this.positionToIndex(line, column);
            return true;
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double mouseX0, double mouseY0) {
        boolean clicked = this.hasMouseClicked;
        if (clicked && this.isMouseInCodeArea((int)mouseX, (int)mouseY)) {
            int line = this.cursorToLine((int)mouseY);
            int column = this.cursorToColumn((int)mouseX, (int)mouseY);
            this.selectionEnd = this.positionToIndex(line, column);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, mouseX0, mouseY0);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double direction) {
        if (super.mouseScrolled(mouseX, mouseY, direction)) {
            return true;
        }
        if (direction <= -1.0) {
            this.changePage(1);
        } else if (direction >= 1.0) {
            this.changePage(-1);
        }
        return true;
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (super.charTyped(typedChar, keyCode)) {
            return true;
        }
        int line = this.indexToLine(this.getSelectionStart());
        int column = this.indexToColumn(this.getSelectionStart());
        if (!Character.isISOControl(typedChar)) {
            if (!CodeBookGui.hasControlDown()) {
                this.undoPush(this.lines);
            }
            this.deleteSelection();
            if (this.lines.get(line).length() < CodeBookGui.getMaxColumns()) {
                this.lines.get(line).insert(column, String.valueOf(typedChar));
                this.selectionStart = ++this.selectionEnd;
            }
            this.recompile();
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        int line = this.indexToLine(this.getSelectionStart());
        int column = this.indexToColumn(this.getSelectionStart());
        ArrayList<StringBuilder> prev_lines = new ArrayList<StringBuilder>(this.lines);
        boolean noUndoTracking = false;
        if (CodeBookGui.hasControlDown()) {
            String key = GLFW.glfwGetKeyName((int)keyCode, (int)scanCode);
            if (keyCode == 65) {
                this.selectionStart = 0;
                this.selectionEnd = this.positionToIndex(Integer.MAX_VALUE, Integer.MAX_VALUE);
            } else if (keyCode == 67) {
                this.setClipboardString(this.selectionToString());
            } else if (keyCode == 88) {
                Minecraft.func_71410_x().field_195559_v.func_197960_a(this.selectionToString());
                this.deleteSelection();
                this.recompile();
            } else if (keyCode == 86) {
                this.deleteSelection();
                String[] pastedLines = StringUtil.splitLines(this.getClipboardString());
                if (!this.isValidPaste(pastedLines)) {
                    return true;
                }
                this.lines.get(line).insert(this.indexToColumn(column), pastedLines[0]);
                this.lines.addAll(line + 1, Arrays.stream(pastedLines).skip(1L).map(StringBuilder::new).collect(Collectors.toList()));
                this.selectionStart = this.selectionEnd += pastedLines[0].length();
                for (int i = 1; i < pastedLines.length; ++i) {
                    this.selectionStart = this.selectionEnd = this.selectionEnd + 1 + pastedLines[i].length();
                }
                this.recompile();
            } else if ("z".equals(key)) {
                noUndoTracking = true;
                this.undo();
                this.recompile();
            } else if ("y".equals(key)) {
                noUndoTracking = true;
                this.redo();
                this.recompile();
            }
        } else {
            if (keyCode == 256) {
                this.saveToServer();
                return true;
            }
            if (keyCode == 263) {
                if (column > 0 || line > 0) {
                    if (CodeBookGui.hasShiftDown()) {
                        --this.selectionEnd;
                    } else {
                        this.selectionStart = --this.selectionEnd;
                    }
                }
            } else if (keyCode == 262) {
                if (column < this.lines.get(line).length() || line < this.lines.size()) {
                    if (CodeBookGui.hasShiftDown()) {
                        ++this.selectionEnd;
                    } else {
                        this.selectionStart = ++this.selectionEnd;
                    }
                }
            } else if (keyCode == 265) {
                int currLine = this.indexToLine(this.selectionEnd);
                if (currLine > 0) {
                    int currColumn = this.indexToColumn(this.selectionEnd);
                    int x = this.columnToX(currLine, currColumn) + 2;
                    int prevLine = currLine - 1;
                    int prevColumn = this.xToColumn(x, prevLine);
                    int index = this.positionToIndex(prevLine, prevColumn);
                    if (CodeBookGui.hasShiftDown()) {
                        this.selectionEnd = index;
                    } else {
                        this.selectionStart = this.selectionEnd = index;
                    }
                }
            } else if (keyCode == 266) {
                int currLine = this.indexToLine(this.selectionEnd);
                if (currLine > 0) {
                    if (CodeBookGui.hasShiftDown()) {
                        this.selectionEnd = 0;
                    } else {
                        this.selectionEnd = 0;
                        this.selectionStart = 0;
                    }
                }
            } else if (keyCode == 264) {
                int currLine = this.indexToLine(this.selectionEnd);
                if (currLine < this.lines.size() - 1) {
                    int currColumn = this.indexToColumn(this.selectionEnd);
                    int x = this.columnToX(currLine, currColumn) + 2;
                    int nextLine = currLine + 1;
                    int nextColumn = this.xToColumn(x, nextLine);
                    int index = this.positionToIndex(nextLine, nextColumn);
                    if (CodeBookGui.hasShiftDown()) {
                        this.selectionEnd = index;
                    } else {
                        this.selectionStart = this.selectionEnd = index;
                    }
                }
            } else if (keyCode == 267) {
                int currLine = this.indexToLine(this.selectionEnd);
                if (currLine < this.lines.size() - 1) {
                    int index;
                    int n = index = this.lines.isEmpty() ? 0 : this.positionToIndex(this.lines.size() - 1, this.lines.get(this.lines.size() - 1).length());
                    if (CodeBookGui.hasShiftDown()) {
                        this.selectionEnd = index;
                    } else {
                        this.selectionStart = this.selectionEnd = index;
                    }
                }
            } else if (keyCode == 268) {
                int currLine = this.indexToLine(this.selectionEnd);
                if (CodeBookGui.hasShiftDown()) {
                    this.selectionEnd = this.positionToIndex(currLine, 0);
                } else {
                    this.selectionStart = this.selectionEnd = this.positionToIndex(currLine, 0);
                }
            } else if (keyCode == 269) {
                int currLine = this.indexToLine(this.selectionEnd);
                if (CodeBookGui.hasShiftDown()) {
                    this.selectionEnd = this.positionToIndex(currLine, this.lines.get(currLine).length());
                } else {
                    this.selectionStart = this.selectionEnd = this.positionToIndex(currLine, this.lines.get(currLine).length());
                }
            } else if (keyCode == 261) {
                if (this.isEmptyPage(this.data.getSelectedPage())) {
                    this.removePage(this.data.getSelectedPage());
                } else if (!this.deleteSelection()) {
                    if (CodeBookGui.hasShiftDown()) {
                        if (this.lines.size() > 1) {
                            this.lines.remove(line);
                        } else {
                            this.lines.get(0).setLength(0);
                        }
                        this.selectionStart = this.selectionEnd = this.positionToIndex(Math.min(this.lines.size() - 1, line), 0);
                    } else if (column < this.lines.get(line).length()) {
                        this.lines.get(line).deleteCharAt(column);
                    } else if (line < this.lines.size() - 1) {
                        StringBuilder currLine = this.lines.get(line);
                        StringBuilder nextLine = this.lines.get(line + 1);
                        if (currLine.length() + nextLine.length() < CodeBookGui.getMaxColumns()) {
                            currLine.append((CharSequence)nextLine);
                            this.lines.remove(line + 1);
                        }
                    }
                }
                this.recompile();
            } else if (keyCode == 259) {
                if (!this.deleteSelection()) {
                    if (column > 0) {
                        this.lines.get(line).deleteCharAt(column - 1);
                    } else if (line > 0) {
                        StringBuilder prevLine = this.lines.get(line - 1);
                        StringBuilder currLine = this.lines.get(line);
                        if (prevLine.length() + currLine.length() < CodeBookGui.getMaxColumns()) {
                            prevLine.append((CharSequence)currLine);
                            this.lines.remove(line);
                        }
                    }
                    this.selectionStart = this.selectionEnd = Math.max(0, this.selectionEnd - 1);
                }
                this.recompile();
            } else if (keyCode == 257 || keyCode == 335) {
                this.deleteSelection();
                if (this.lines.size() < CodeBookGui.getMaxLinesPerPage()) {
                    StringBuilder oldLine = this.lines.get(line);
                    StringBuilder newLine = new StringBuilder();
                    if (column < oldLine.length()) {
                        newLine.append(oldLine.substring(column));
                        oldLine.setLength(column);
                    }
                    this.lines.add(line + 1, newLine);
                    this.selectionStart = ++this.selectionEnd;
                }
                this.recompile();
            } else if (keyCode == 258) {
                this.deleteSelection();
                if (this.lines.get(line).length() < CodeBookGui.getMaxColumns() - 1) {
                    this.lines.get(line).insert(column, "  ");
                    this.selectionStart = this.selectionEnd += 2;
                }
                this.recompile();
            } else {
                noUndoTracking = true;
            }
        }
        if (!noUndoTracking) {
            this.undoPush(prev_lines);
        }
        return false;
    }

    private int drawString(String text, int x, int y, int color) {
        return this.font.func_211126_b(text, (float)x, (float)y, color);
    }

    private void drawRect(int x, int y, int w, int h, int color) {
        CodeBookGui.fill((int)x, (int)y, (int)w, (int)h, (int)color);
    }

    void setClipboardString(String text) {
        Minecraft.func_71410_x().field_195559_v.func_197960_a(text);
    }

    String getClipboardString() {
        return Minecraft.func_71410_x().field_195559_v.func_197965_a();
    }

    private void saveToServer() {
        this.saveProgram();
        ((CodeBookContainer)this.field_147002_h).save();
    }

    private void saveProgram() {
        this.data.setPage(this.data.getSelectedPage(), this.lines.stream().map(StringBuilder::toString).collect(Collectors.toList()));
    }

    private void rebuildLines() {
        if (this.data.getPageCount() < 1) {
            this.data.addPage();
        }
        List<String> program = this.data.getPage(this.data.getSelectedPage());
        this.lines.clear();
        if (!program.isEmpty()) {
            program.forEach(line -> this.lines.add(new StringBuilder((String)line)));
            if (program.size() < 25 && !program.get(program.size() - 1).trim().isEmpty()) {
                this.lines.add(new StringBuilder());
            }
        }
        this.recompile();
    }

    private void recompile() {
        this.saveProgram();
        this.compileError.clear();
        this.instructionIds.clear();
        int currentPageNo = this.data.getSelectedPage();
        List<List<String>> program = this.data.getProgram();
        ArrayList<Label> labels = new ArrayList<Label>();
        for (int pageNumber = 0; pageNumber < program.size(); ++pageNumber) {
            List<String> page = program.get(pageNumber);
            for (int lineNumber = 0; lineNumber < page.size(); ++lineNumber) {
                try {
                    InstructionUtil.parseLineForLabels(page.get(lineNumber), labels, (short)0);
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        int program_ip = 0;
        for (int pageNumber = 0; pageNumber < program.size() && pageNumber <= currentPageNo; ++pageNumber) {
            List<String> page = program.get(pageNumber);
            ArrayList pageInstructionIds = new ArrayList();
            for (int lineNumber = 0; lineNumber < page.size(); ++lineNumber) {
                int ip = -1;
                try {
                    if (InstructionUtil.parseLine(page.get(lineNumber), labels, (short)0) != null) {
                        ip = program_ip++;
                    }
                }
                catch (ParseException e) {
                    e.lineNumber = lineNumber;
                    e.pageNumber = pageNumber;
                    this.compileError.add(e);
                }
                if (pageNumber != currentPageNo) continue;
                this.instructionIds.add(ip);
            }
        }
    }

    private StringBuilder getLine(int index) {
        return index < this.lines.size() ? this.lines.get(index) : new StringBuilder();
    }

    private boolean isCurrentProgramNonEmpty() {
        return this.lines.size() > 1 || !this.lines.isEmpty() && this.getLine(0).length() > 0;
    }

    private int getSelectionStart() {
        return Math.min(this.selectionStart, this.selectionEnd);
    }

    private int getSelectionEnd() {
        return Math.max(this.selectionStart, this.selectionEnd);
    }

    private boolean intersectsSelection(int start, int end) {
        return start < this.getSelectionEnd() && end > this.getSelectionStart();
    }

    private String selectionToString() {
        int startLine = this.indexToLine(this.getSelectionStart());
        int endLine = this.indexToLine(this.getSelectionEnd());
        if (this.selectionStart == this.selectionEnd) {
            return this.getLine(startLine).toString();
        }
        int startColumn = this.indexToColumn(this.getSelectionStart());
        int endColumn = this.indexToColumn(this.getSelectionEnd());
        if (startLine == endLine) {
            return this.getLine(startLine).substring(startColumn, endColumn);
        }
        StringBuilder selection = new StringBuilder();
        selection.append(this.getLine(startLine).subSequence(startColumn, this.getLine(startLine).length())).append('\n');
        for (int line = startLine + 1; line < endLine; ++line) {
            selection.append(this.getLine(line).toString()).append('\n');
        }
        selection.append(this.getLine(endLine).subSequence(0, endColumn)).append('\n');
        return selection.toString();
    }

    private int cursorToLine(int y) {
        int n = Math.min(this.lines.size() - 1, CodeBookGui.getMaxLinesPerPage());
        int n2 = y - 16 - this.getGuiTop();
        this.font.getClass();
        return Math.max(0, Math.min(n, n2 / 9));
    }

    private int cursorToColumn(int x, int y) {
        return this.xToColumn(x - this.getGuiLeft() + 2, this.cursorToLine(y));
    }

    private int xToColumn(int x, int line) {
        return this.font.func_78269_a(this.getLine(line).toString(), Math.max(0, x - 48)).length();
    }

    private int columnToX(int line, int column) {
        return 48 + this.font.func_78256_a(this.getLine(line).substring(0, Math.min(column, this.getLine(line).length())));
    }

    private int positionToIndex(int line, int column) {
        int index = 0;
        for (int l = 0; l < Math.min(line, this.lines.size()); ++l) {
            index += this.getLine(l).length() + 1;
        }
        return index += Math.min(column, this.getLine(Math.min(line, this.lines.size() - 1)).length());
    }

    private int indexToLine(int index) {
        int position = 0;
        for (int line = 0; line < this.lines.size(); ++line) {
            if ((position += this.getLine(line).length() + 1) <= index) continue;
            return line;
        }
        return Math.max(0, this.lines.size() - 1);
    }

    private int indexToColumn(int index) {
        if (this.lines.isEmpty()) {
            return 0;
        }
        int position = 0;
        for (StringBuilder line : this.lines) {
            if (position + line.length() + 1 > index) {
                return index - position;
            }
            position += line.length() + 1;
        }
        return this.getLine(this.lines.size() - 1).length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMouseInCodeArea(int mouseX, int mouseY) {
        if (mouseX < this.getGuiLeft() + 48 - 10) return false;
        if (mouseX > this.getGuiLeft() + 48 + 120 + 10) return false;
        if (mouseY < this.getGuiTop() + 16 - 10) return false;
        int n = this.getGuiTop() + 16;
        this.font.getClass();
        if (mouseY > n + 9 * CodeBookGui.getMaxLinesPerPage() + 10) return false;
        return true;
    }

    private boolean deleteSelection() {
        if (this.selectionStart == this.selectionEnd) {
            return false;
        }
        int startLine = this.indexToLine(this.getSelectionStart());
        int endLine = this.indexToLine(this.getSelectionEnd());
        int startColumn = this.indexToColumn(this.getSelectionStart());
        int endColumn = this.indexToColumn(this.getSelectionEnd());
        if (startLine == endLine) {
            this.getLine(startLine).delete(startColumn, endColumn);
        } else {
            this.getLine(startLine).delete(startColumn, this.getLine(startLine).length());
            this.getLine(endLine).delete(0, endColumn);
            this.getLine(startLine).append((CharSequence)this.getLine(endLine));
            for (int line = endLine; line > startLine; --line) {
                this.lines.remove(line);
            }
        }
        this.selectionStart = this.selectionEnd = this.getSelectionStart();
        return true;
    }

    private boolean isValidPaste(String[] pastedLines) {
        int selectedLine = this.indexToLine(this.selectionEnd);
        if (pastedLines.length == 0) {
            return false;
        }
        if (pastedLines.length - 1 + this.lines.size() > CodeBookGui.getMaxLinesPerPage()) {
            return false;
        }
        if (pastedLines[0].length() + this.getLine(selectedLine).length() > CodeBookGui.getMaxColumns()) {
            return false;
        }
        for (String pastedLine : pastedLines) {
            if (pastedLine.length() <= CodeBookGui.getMaxColumns()) continue;
            return false;
        }
        return true;
    }

    private boolean isEmptyPage(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.data.getPageCount()) {
            return true;
        }
        for (String s : this.data.getPage(pageIndex)) {
            if (s.trim().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private int pageCharacterCount() {
        return this.lines.stream().mapToInt(l -> l.toString().length()).sum() + this.lines.size();
    }

    private void changePage(int delta) {
        this.saveProgram();
        int page_index = MathHelper.func_76125_a((int)(this.data.getSelectedPage() + delta), (int)0, (int)(this.data.getPageCount() + 1));
        if (!(page_index < this.data.getPageCount() || this.data.getPageCount() >= 2 && this.isEmptyPage(this.data.getPageCount() - 1))) {
            this.data.addPage();
        }
        this.data.setSelectedPage(page_index);
        this.rebuildLines();
        this.selectionStart = this.selectionEnd = Math.max(0, this.pageCharacterCount());
        this.undoBuffer.clear();
        this.redoBuffer.clear();
    }

    private void removePage(int index) {
        this.data.removePage(index);
        this.rebuildLines();
        this.selectionStart = this.selectionEnd = Math.max(0, this.pageCharacterCount());
    }

    private void drawProgram(int mouseX, int mouseY) {
        int position = 0;
        for (int lineNumber = 0; lineNumber < this.lines.size(); ++lineNumber) {
            int ip;
            StringBuilder line = this.getLine(lineNumber);
            int end = position + line.length();
            this.font.getClass();
            int offsetY = lineNumber * 9;
            int lineX = 48;
            int lineY = 16 + offsetY;
            if (this.selectionStart != this.selectionEnd && this.intersectsSelection(position, end)) {
                int currX = 48;
                int prefix = Math.max(0, this.getSelectionStart() - position);
                int selected = Math.min(line.length() - prefix, this.getSelectionEnd() - (position + prefix));
                String prefixText = line.substring(0, prefix);
                this.drawString(prefixText, currX, lineY, CodeBookGui.getCodeColor());
                String selectedText = line.substring(prefix, prefix + selected);
                int selectedWidth = this.font.func_78256_a(selectedText);
                this.font.getClass();
                this.drawRect((currX += this.font.func_78256_a(prefixText)) - 1, lineY - 1, currX + selectedWidth, lineY + 9 - 1, CodeBookGui.getSelectionBackgroundColor());
                this.drawString(selectedText, currX, lineY, CodeBookGui.getSelectionColor());
                String postfixString = line.substring(prefix + selected);
                this.drawString(postfixString, currX += selectedWidth, lineY, CodeBookGui.getCodeColor());
            } else {
                this.drawString(line.toString(), 48, lineY, CodeBookGui.getCodeColor());
            }
            position += line.length() + 1;
            if (lineNumber > this.instructionIds.size() || (ip = this.instructionIds.get(lineNumber).intValue()) < 0) continue;
            this.drawString(String.format("%03X", ip & 0xFFF), 20, lineY + 1, CodeBookGui.getInstructionNoColor());
        }
        if (this.compileError.size() > 0) {
            for (ParseException exception : this.compileError) {
                this.drawError(exception, mouseX, mouseY);
            }
        }
        this.drawTextCursor();
    }

    private void drawError(ParseException exception, int mouseX, int mouseY) {
        if (exception.pageNumber != this.data.getSelectedPage()) {
            return;
        }
        int localLineNumber = exception.lineNumber;
        int startX = this.columnToX(localLineNumber, 0);
        int rawEndX = this.columnToX(localLineNumber, CodeBookGui.getMaxColumns());
        this.font.getClass();
        int startY = 16 + localLineNumber * 9 - 1;
        int endX = Math.max(rawEndX, startX + (int)this.font.func_211125_a(' '));
        this.font.getClass();
        this.font.getClass();
        this.drawRect(startX - 1, startY + 9 - 1, endX, startY + 9, -52429);
        if (mouseX >= startX && mouseX <= endX && mouseY >= startY) {
            this.font.getClass();
            if (mouseY <= startY + 9) {
                this.tooltip.add(exception.message);
            }
        }
    }

    private void drawTextCursor() {
        if (System.currentTimeMillis() % 800L <= 400L) {
            int line = this.indexToLine(this.selectionEnd);
            int column = this.indexToColumn(this.selectionEnd);
            StringBuilder sb = line < this.lines.size() ? this.getLine(line) : new StringBuilder();
            int x = 48 + this.font.func_78256_a(sb.substring(0, column)) - 1;
            this.font.getClass();
            int y = 16 + line * 9 - 1;
            this.font.getClass();
            this.drawRect(x + 1, y + 1, x + 2 + 1, y + 9 + 1, -869059789);
            this.font.getClass();
            this.drawRect(x, y, x + 2, y + 9, CodeBookGui.getSelectionColor());
        }
    }

    private void drawPageInfo() {
        String pageInfo = String.format("%d/%d", this.data.getSelectedPage() + 1, this.data.getPageCount());
        this.drawString(pageInfo, 92 - this.font.func_78256_a(pageInfo) / 2, 212, CodeBookGui.getCodeColor());
    }

    private void undo() {
        if (!this.undoBuffer.isEmpty()) {
            this.redoBuffer.clear();
            this.redoBuffer.add(this.lines.stream().map(s -> s.toString()).collect(Collectors.joining("\n")));
            this.lines.clear();
            this.lines.addAll(Arrays.stream(StringUtil.splitLines(this.undoBuffer.pop())).map(s -> new StringBuilder((String)s)).collect(Collectors.toList()));
        }
    }

    private void redo() {
        if (!this.redoBuffer.isEmpty()) {
            this.lines.clear();
            this.lines.addAll(Arrays.stream(StringUtil.splitLines(this.redoBuffer.get(0))).map(s -> new StringBuilder((String)s)).collect(Collectors.toList()));
            this.redoBuffer.clear();
        }
    }

    private void undoPush(List<StringBuilder> lines) {
        this.undoBuffer.addLast(lines.stream().map(s -> s.toString()).collect(Collectors.joining("\n")));
        if (this.undoBuffer.size() > CodeBookGui.getMaxUndoSteps()) {
            this.undoBuffer.removeFirst();
        }
    }
}

