/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.torocraft.minecoprocessors.ModMinecoprocessors;

public class Networking {
    private static final String PROTOCOL = "1";
    private static final SimpleChannel DEFAULT_CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("minecoprocessors", "default_ch")).clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).networkProtocolVersion(() -> "1").simpleChannel();

    public static void init() {
        int discr = -1;
        DEFAULT_CHANNEL.registerMessage(++discr, PacketTileNotifyClientToServer.class, PacketTileNotifyClientToServer::compose, PacketTileNotifyClientToServer::parse, PacketTileNotifyClientToServer.Handler::handle);
        DEFAULT_CHANNEL.registerMessage(++discr, PacketTileNotifyServerToClient.class, PacketTileNotifyServerToClient::compose, PacketTileNotifyServerToClient::parse, PacketTileNotifyServerToClient.Handler::handle);
        DEFAULT_CHANNEL.registerMessage(++discr, PacketContainerSyncClientToServer.class, PacketContainerSyncClientToServer::compose, PacketContainerSyncClientToServer::parse, PacketContainerSyncClientToServer.Handler::handle);
        DEFAULT_CHANNEL.registerMessage(++discr, PacketContainerSyncServerToClient.class, PacketContainerSyncServerToClient::compose, PacketContainerSyncServerToClient::parse, PacketContainerSyncServerToClient.Handler::handle);
    }

    public static class PacketItemSyncServerToClient {
    }

    public static class PacketItemSyncClientToServer {
    }

    public static interface INetworkSynchronisableItem {
        public void onServerPacketReceived(int var1, PlayerEntity var2, CompoundNBT var3);

        public void onClientPacketReceived(int var1, PlayerEntity var2, CompoundNBT var3);
    }

    public static class PacketContainerSyncServerToClient {
        int id = -1;
        CompoundNBT nbt = null;

        public static void sendToPlayer(PlayerEntity player, int windowId, CompoundNBT nbt) {
            if (!(player instanceof ServerPlayerEntity) || player instanceof FakePlayer || nbt == null) {
                return;
            }
            DEFAULT_CHANNEL.sendTo((Object)new PacketContainerSyncServerToClient(windowId, nbt), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }

        public static void sendToPlayer(PlayerEntity player, Container container, CompoundNBT nbt) {
            if (!(player instanceof ServerPlayerEntity) || player instanceof FakePlayer || nbt == null) {
                return;
            }
            DEFAULT_CHANNEL.sendTo((Object)new PacketContainerSyncServerToClient(container.field_75152_c, nbt), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }

        public static <C extends Container> void sendToListeners(World world, C container, CompoundNBT nbt) {
            for (PlayerEntity player : world.func_217369_A()) {
                if (player.field_71070_bA.field_75152_c != container.field_75152_c) continue;
                PacketContainerSyncServerToClient.sendToPlayer(player, container.field_75152_c, nbt);
            }
        }

        public PacketContainerSyncServerToClient() {
        }

        public PacketContainerSyncServerToClient(int id, CompoundNBT nbt) {
            this.nbt = nbt;
            this.id = id;
        }

        public static PacketContainerSyncServerToClient parse(PacketBuffer buf) {
            return new PacketContainerSyncServerToClient(buf.readInt(), buf.func_150793_b());
        }

        public static void compose(PacketContainerSyncServerToClient pkt, PacketBuffer buf) {
            buf.writeInt(pkt.id);
            buf.func_150786_a(pkt.nbt);
        }

        public static class Handler {
            public static void handle(PacketContainerSyncServerToClient pkt, Supplier<NetworkEvent.Context> ctx) {
                ctx.get().enqueueWork(() -> {
                    PlayerEntity player = ModMinecoprocessors.proxy.getPlayerClientSide();
                    if (!(player.field_71070_bA instanceof INetworkSynchronisableContainer)) {
                        return;
                    }
                    if (player.field_71070_bA.field_75152_c != pkt.id || pkt.nbt == null) {
                        return;
                    }
                    ((INetworkSynchronisableContainer)player.field_71070_bA).onServerPacketReceived(pkt.id, pkt.nbt);
                });
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public static class PacketContainerSyncClientToServer {
        int id = -1;
        CompoundNBT nbt = null;

        public static void sendToServer(int windowId, CompoundNBT nbt) {
            if (nbt != null) {
                DEFAULT_CHANNEL.sendToServer((Object)new PacketContainerSyncClientToServer(windowId, nbt));
            }
        }

        public static void sendToServer(Container container, CompoundNBT nbt) {
            if (nbt != null) {
                DEFAULT_CHANNEL.sendToServer((Object)new PacketContainerSyncClientToServer(container.field_75152_c, nbt));
            }
        }

        public PacketContainerSyncClientToServer() {
        }

        public PacketContainerSyncClientToServer(int id, CompoundNBT nbt) {
            this.nbt = nbt;
            this.id = id;
        }

        public static PacketContainerSyncClientToServer parse(PacketBuffer buf) {
            return new PacketContainerSyncClientToServer(buf.readInt(), buf.func_150793_b());
        }

        public static void compose(PacketContainerSyncClientToServer pkt, PacketBuffer buf) {
            buf.writeInt(pkt.id);
            buf.func_150786_a(pkt.nbt);
        }

        public static class Handler {
            public static void handle(PacketContainerSyncClientToServer pkt, Supplier<NetworkEvent.Context> ctx) {
                ctx.get().enqueueWork(() -> {
                    ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                    if (!(player.field_71070_bA instanceof INetworkSynchronisableContainer)) {
                        return;
                    }
                    if (player.field_71070_bA.field_75152_c != pkt.id) {
                        return;
                    }
                    ((INetworkSynchronisableContainer)player.field_71070_bA).onClientPacketReceived(pkt.id, (PlayerEntity)player, pkt.nbt);
                });
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public static interface INetworkSynchronisableContainer {
        public void onServerPacketReceived(int var1, CompoundNBT var2);

        public void onClientPacketReceived(int var1, PlayerEntity var2, CompoundNBT var3);
    }

    public static class PacketTileNotifyServerToClient {
        CompoundNBT nbt = null;
        BlockPos pos = BlockPos.field_177992_a;

        public static void sendToPlayer(PlayerEntity player, TileEntity te, CompoundNBT nbt) {
            if (!(player instanceof ServerPlayerEntity) || player instanceof FakePlayer || te == null || nbt == null) {
                return;
            }
            DEFAULT_CHANNEL.sendTo((Object)new PacketTileNotifyServerToClient(te, nbt), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }

        public PacketTileNotifyServerToClient() {
        }

        public PacketTileNotifyServerToClient(BlockPos pos, CompoundNBT nbt) {
            this.nbt = nbt;
            this.pos = pos;
        }

        public PacketTileNotifyServerToClient(TileEntity te, CompoundNBT nbt) {
            this.nbt = nbt;
            this.pos = te.func_174877_v();
        }

        public static PacketTileNotifyServerToClient parse(PacketBuffer buf) {
            return new PacketTileNotifyServerToClient(buf.func_179259_c(), buf.func_150793_b());
        }

        public static void compose(PacketTileNotifyServerToClient pkt, PacketBuffer buf) {
            buf.func_179255_a(pkt.pos);
            buf.func_150786_a(pkt.nbt);
        }

        public static class Handler {
            public static void handle(PacketTileNotifyServerToClient pkt, Supplier<NetworkEvent.Context> ctx) {
                ctx.get().enqueueWork(() -> {
                    World world = ModMinecoprocessors.proxy.getWorldClientSide();
                    if (world == null) {
                        return;
                    }
                    TileEntity te = world.func_175625_s(pkt.pos);
                    if (!(te instanceof IPacketTileNotifyReceiver)) {
                        return;
                    }
                    ((IPacketTileNotifyReceiver)te).onServerPacketReceived(pkt.nbt);
                });
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public static class PacketTileNotifyClientToServer {
        CompoundNBT nbt = null;
        BlockPos pos = BlockPos.field_177992_a;

        public static void sendToServer(BlockPos pos, CompoundNBT nbt) {
            if (pos != null && nbt != null) {
                DEFAULT_CHANNEL.sendToServer((Object)new PacketTileNotifyClientToServer(pos, nbt));
            }
        }

        public static void sendToServer(TileEntity te, CompoundNBT nbt) {
            if (te != null && nbt != null) {
                DEFAULT_CHANNEL.sendToServer((Object)new PacketTileNotifyClientToServer(te, nbt));
            }
        }

        public PacketTileNotifyClientToServer() {
        }

        public PacketTileNotifyClientToServer(BlockPos pos, CompoundNBT nbt) {
            this.nbt = nbt;
            this.pos = pos;
        }

        public PacketTileNotifyClientToServer(TileEntity te, CompoundNBT nbt) {
            this.nbt = nbt;
            this.pos = te.func_174877_v();
        }

        public static PacketTileNotifyClientToServer parse(PacketBuffer buf) {
            return new PacketTileNotifyClientToServer(buf.func_179259_c(), buf.func_150793_b());
        }

        public static void compose(PacketTileNotifyClientToServer pkt, PacketBuffer buf) {
            buf.func_179255_a(pkt.pos);
            buf.func_150786_a(pkt.nbt);
        }

        public static class Handler {
            public static void handle(PacketTileNotifyClientToServer pkt, Supplier<NetworkEvent.Context> ctx) {
                ctx.get().enqueueWork(() -> {
                    ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                    World world = player.field_70170_p;
                    if (world == null) {
                        return;
                    }
                    TileEntity te = world.func_175625_s(pkt.pos);
                    if (!(te instanceof IPacketTileNotifyReceiver)) {
                        return;
                    }
                    ((IPacketTileNotifyReceiver)te).onClientPacketReceived((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), pkt.nbt);
                });
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public static interface IPacketTileNotifyReceiver {
        default public void onServerPacketReceived(CompoundNBT nbt) {
        }

        default public void onClientPacketReceived(PlayerEntity player, CompoundNBT nbt) {
        }
    }
}

