/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.torocraft.minecoprocessors.ModMinecoprocessors;

public class BookCreator {
    private static final String PATH = "/data/minecoprocessors/books/";
    private static final String PAGE_DELIMITER = "~~~";
    private static ItemStack manualBook;

    public static ItemStack getManual() {
        try {
            manualBook = BookCreator.loadBook("manual");
        }
        catch (Exception e) {
            manualBook = new ItemStack((IItemProvider)Items.field_151099_bA);
            ModMinecoprocessors.logger().error("Failed to load manual: " + e.toString());
        }
        return manualBook;
    }

    private static ItemStack loadBook(String name) throws IOException {
        ItemStack book = new ItemStack((IItemProvider)Items.field_151164_bB);
        int lineNumber = 1;
        StringBuilder page = BookCreator.newPage();
        try (BufferedReader reader = BookCreator.openBookReader(name);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (lineNumber == 1) {
                    book.func_77983_a("title", (INBT)new StringNBT(line));
                } else if (lineNumber == 2) {
                    book.func_77983_a("author", (INBT)new StringNBT(line));
                } else if (PAGE_DELIMITER.equals(line)) {
                    BookCreator.writePage(book, page);
                    page = BookCreator.newPage();
                } else {
                    page.append(line).append("\n");
                }
                ++lineNumber;
            }
        }
        BookCreator.writePage(book, page);
        return book;
    }

    private static BufferedReader openBookReader(String name) throws FileNotFoundException {
        String path = PATH + name + ".txt";
        InputStream is = BookCreator.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("Book file not found [" + path + "]");
        }
        return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    private static void writePage(ItemStack book, StringBuilder page) {
        ListNBT pages = BookCreator.getPagesNbt(book);
        pages.add((Object)BookCreator.createPage(page.toString()));
        book.func_77983_a("pages", (INBT)pages);
    }

    private static ListNBT getPagesNbt(ItemStack book) {
        if (book.func_77978_p() == null) {
            book.func_77982_d(new CompoundNBT());
        }
        return book.func_77978_p().func_150295_c("pages", 8);
    }

    private static StringBuilder newPage() {
        return new StringBuilder(256);
    }

    private static StringNBT createPage(String page) {
        return new StringNBT(ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent(page)));
    }
}

