/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.util;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.config.GuiUtils;

@OnlyIn(value=Dist.CLIENT)
public class GuiWidgets {

    @OnlyIn(value=Dist.CLIENT)
    public static class ScaledButton
    extends Button {
        private final double scale;

        public ScaledButton(double scale, int x, int y, int w, int h, String text, Button.IPressable onPress) {
            super(x, y, w, h, text, onPress);
            this.scale = scale;
        }

        public void renderButton(int mouseX, int mouseY, float partial) {
            if (!this.visible) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            int ist = this.getYImage(this.isHovered);
            GlStateManager.pushMatrix();
            GlStateManager.scaled((double)this.scale, (double)this.scale, (double)this.scale);
            int bx = (int)Math.floor((double)this.x / this.scale);
            int by = (int)Math.floor((double)this.y / this.scale);
            int bw = (int)Math.ceil((double)this.width / this.scale);
            int bh = (int)Math.ceil((double)this.height / this.scale);
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)WIDGETS_LOCATION, (int)bx, (int)by, (int)0, (int)(46 + ist * 20), (int)bw, (int)bh, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.blitOffset);
            this.renderBg(mc, mouseX, mouseY);
            int color = this.packedFGColor != 0 ? this.packedFGColor : (!this.active ? 0xA0A0A0 : (this.isHovered ? 0xFFFFA0 : 0xE0E0E0));
            String txt = this.getMessage();
            int txt_width = mc.field_71466_p.func_78256_a(txt);
            int ellipsis_width = mc.field_71466_p.func_78256_a("...");
            if (txt_width > bw - 6 && txt_width > ellipsis_width) {
                txt = mc.field_71466_p.func_78269_a(txt, bw - 6 - ellipsis_width).trim() + "...";
            }
            this.drawCenteredString(mc.field_71466_p, txt, bx + bw / 2, by + (bh - 8) / 2, color);
            GlStateManager.popMatrix();
        }
    }
}

