/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.torocraft.minecoprocessors.ModMinecoprocessors;
import net.torocraft.minecoprocessors.processor.InstructionCode;
import net.torocraft.minecoprocessors.processor.Processor;
import net.torocraft.minecoprocessors.processor.Register;
import net.torocraft.minecoprocessors.util.ByteUtil;
import net.torocraft.minecoprocessors.util.Label;
import net.torocraft.minecoprocessors.util.ParseException;

public class InstructionUtil {
    public static final String ERROR_DOUBLE_REFERENCE = "only one memory reference allowed";
    public static final String ERROR_NON_REFERENCE_OFFSET = "offsets can only be used with labels and references";
    public static final String ERROR_LABEL_IN_FIRST_OPERAND = "labels can not be the first of two operands";

    public static List<String> compileFile(List<byte[]> instructions, List<Label> labels) {
        ArrayList<String> file = new ArrayList<String>();
        for (short address = 0; address < instructions.size(); address = (short)(address + 1)) {
            file.add(InstructionUtil.compileLine(instructions.get(address), labels, address));
        }
        return file;
    }

    public static String compileLine(byte[] instruction, List<Label> labels, short lineAddress) {
        Label label2;
        if (instruction == null) {
            return "";
        }
        StringBuilder line = new StringBuilder();
        for (Label label2 : labels) {
            if (label2.address != lineAddress) continue;
            line.append(label2.name).append(": ");
        }
        InstructionCode command = InstructionCode.values()[instruction[0]];
        line.append(command.toString().toLowerCase());
        switch (command) {
            case MOV: 
            case ADD: 
            case AND: 
            case OR: 
            case XOR: 
            case CMP: 
            case SHL: 
            case SHR: 
            case SUB: 
            case ROR: 
            case ROL: 
            case SAL: 
            case SAR: {
                line.append(" ");
                line.append(InstructionUtil.compileVariableOperand(instruction, 0, labels));
                line.append(", ");
                line.append(InstructionUtil.compileVariableOperand(instruction, 1, labels));
                break;
            }
            case DJNZ: {
                line.append(" ");
                line.append(InstructionUtil.lower(Register.values()[instruction[1]]));
                line.append(", ");
                label2 = labels.get(instruction[2]);
                if (label2 == null) break;
                line.append(label2.name.toLowerCase());
                break;
            }
            case JMP: 
            case JNZ: 
            case JZ: 
            case JE: 
            case JNE: 
            case JG: 
            case JGE: 
            case JL: 
            case JLE: 
            case JC: 
            case JNC: 
            case LOOP: 
            case CALL: {
                label2 = labels.get(instruction[1]);
                if (label2 == null) break;
                line.append(" ");
                line.append(label2.name.toLowerCase());
                break;
            }
            case MUL: 
            case DIV: 
            case NOT: 
            case POP: 
            case PUSH: 
            case INT: 
            case INC: 
            case DEC: {
                line.append(" ");
                if (ByteUtil.getBit(instruction[3], 0)) {
                    line.append(Integer.toString(instruction[1], 10));
                    break;
                }
                line.append(InstructionUtil.lower(Register.values()[instruction[1]]));
                break;
            }
            case POPA: 
            case PUSHA: 
            case RET: 
            case NOP: 
            case WFE: 
            case HLT: 
            case CLZ: 
            case CLC: 
            case SEZ: 
            case SEC: 
            case DUMP: {
                break;
            }
            default: {
                throw new RuntimeException("Command enum had unexpected value");
            }
        }
        return line.toString();
    }

    static String compileMemoryReference(String operand, byte[] instruction, int operandIndex) {
        if (Processor.isMemoryReferenceOperand(instruction, operandIndex)) {
            return "[" + operand + "]";
        }
        return operand;
    }

    static String compileOffset(String operand, byte[] instruction, int operandIndex) {
        if (Processor.isOffsetOperand(instruction, operandIndex)) {
            if (instruction[4] < 0) {
                return operand + Byte.toString(instruction[4]);
            }
            return operand + "+" + Byte.toString(instruction[4]);
        }
        return operand;
    }

    static String compileVariableOperand(byte[] instruction, int operandIndex, List<Label> labels) {
        Label label;
        byte value = instruction[operandIndex + 1];
        String operand = "";
        if (Processor.isLiteralOperand(instruction, operandIndex)) {
            operand = Integer.toString(value, 10);
        } else if (Processor.isRegisterOperand(instruction, operandIndex)) {
            operand = InstructionUtil.lower(Register.values()[value]);
        } else if (Processor.isLabelOperand(instruction, operandIndex) && value < labels.size() && (label = labels.get(value)) != null) {
            operand = label.name.toLowerCase();
        }
        operand = InstructionUtil.compileOffset(operand, instruction, operandIndex);
        return InstructionUtil.compileMemoryReference(operand, instruction, operandIndex);
    }

    private static String lower(Enum<?> e) {
        return e.toString().toLowerCase();
    }

    public static List<byte[]> parseFile(List<String> lines, List<Label> labels) throws ParseException {
        ArrayList<byte[]> instructions = new ArrayList<byte[]>();
        for (String line : lines) {
            InstructionUtil.parseLineForLabels(line, labels, (short)instructions.size());
        }
        for (String line : lines) {
            byte[] instruction = InstructionUtil.parseLine(line, labels, (short)instructions.size());
            if (instruction == null) continue;
            instructions.add(instruction);
        }
        return instructions;
    }

    public static void parseLineForLabels(String line, List<Label> labels, short lineAddress) throws ParseException {
        if (!(line = InstructionUtil.removeComments(line)).trim().isEmpty() && InstructionUtil.isLabelInstruction(line)) {
            InstructionUtil.parseLabelLine(line, labels, lineAddress);
        }
    }

    public static byte[] parseLine(String line, List<Label> labels, short lineAddress) throws ParseException {
        if ((line = InstructionUtil.removeComments(line)).trim().length() < 1) {
            return null;
        }
        if (InstructionUtil.isLabelInstruction(line)) {
            InstructionUtil.setLabelAddress(line, labels, lineAddress);
        }
        if ((line = InstructionUtil.removeLabels(line)).trim().length() < 1) {
            return null;
        }
        return InstructionUtil.parseCommandLine(line, labels);
    }

    static String removeComments(String line) {
        List<String> l = InstructionUtil.regex("^([^;]*);.*", line, 2);
        if (l.size() == 1) {
            return l.get(0);
        }
        return line;
    }

    static String removeLabels(String line) {
        List<String> l = InstructionUtil.regex("^\\s*[A-Za-z0-9-_]+:\\s*(.*)$", line, 2);
        if (l.size() == 1) {
            return l.get(0);
        }
        return line;
    }

    private static void setLabelAddress(String line, List<Label> labels, short lineAddress) throws ParseException {
        List<String> l = InstructionUtil.regex("^\\s*([A-Za-z0-9-_]+):.*$", line, 2);
        if (l.size() != 1) {
            throw new ParseException(line, "incorrect label format");
        }
        String label = l.get(0).toLowerCase();
        InstructionUtil.setLabelAddress(line, labels, label, lineAddress);
    }

    private static void parseLabelLine(String line, List<Label> labels, short lineAddress) throws ParseException {
        List<String> l = InstructionUtil.regex("^\\s*([A-Za-z0-9-_]+):.*$", line, 2);
        if (l.size() != 1) {
            throw new ParseException(line, "incorrect label format");
        }
        String label = l.get(0).toLowerCase();
        InstructionUtil.verifyLabelIsUnique(line, labels, label);
        labels.add(new Label(lineAddress, label));
    }

    private static void setLabelAddress(String line, List<Label> labels, String label, short address) throws ParseException {
        for (Label l : labels) {
            if (!l.name.equalsIgnoreCase(label)) continue;
            l.address = address;
            return;
        }
        throw new ParseException(line, "label not found");
    }

    private static void verifyLabelIsUnique(String line, List<Label> labels, String label) throws ParseException {
        for (Label l : labels) {
            if (!l.name.equalsIgnoreCase(label)) continue;
            throw new ParseException(line, "label already defined");
        }
    }

    private static boolean isLabelInstruction(String line) {
        return line.matches("^\\s*[A-Za-z0-9-_]+:.*$");
    }

    private static byte[] parseCommandLine(String line, List<Label> labels) throws ParseException {
        byte[] instruction;
        InstructionCode instructionCode = InstructionUtil.parseInstructionCode(line);
        switch (instructionCode) {
            case MOV: 
            case ADD: 
            case AND: 
            case OR: 
            case XOR: 
            case CMP: 
            case SHL: 
            case SHR: 
            case SUB: 
            case ROR: 
            case ROL: 
            case SAL: 
            case SAR: 
            case DJNZ: {
                instruction = InstructionUtil.parseDoubleOperands(line, labels);
                break;
            }
            case JMP: 
            case JNZ: 
            case JZ: 
            case JE: 
            case JNE: 
            case JG: 
            case JGE: 
            case JL: 
            case JLE: 
            case JC: 
            case JNC: 
            case LOOP: 
            case CALL: {
                instruction = InstructionUtil.parseLabelOperand(line, labels);
                break;
            }
            case MUL: 
            case DIV: 
            case NOT: 
            case POP: 
            case PUSH: 
            case INT: 
            case INC: 
            case DEC: {
                instruction = InstructionUtil.parseSingleOperand(line, labels);
                break;
            }
            case POPA: 
            case PUSHA: 
            case RET: 
            case NOP: 
            case WFE: 
            case HLT: 
            case CLZ: 
            case CLC: 
            case SEZ: 
            case SEC: 
            case DUMP: {
                instruction = new byte[1];
                break;
            }
            default: {
                throw new RuntimeException("instructionCode enum had unexpected value");
            }
        }
        instruction[0] = (byte)instructionCode.ordinal();
        return instruction;
    }

    private static byte[] parseSingleOperand(String line, List<Label> labels) throws ParseException {
        byte[] instruction = new byte[4];
        List<String> l = InstructionUtil.regex("^\\s*[A-Z]+\\s+([A-Z0-9]+)\\s*$", line, 2);
        if (l.size() != 1) {
            throw new ParseException(line, "incorrect operand format");
        }
        instruction = InstructionUtil.parseVariableOperand(line, instruction, l.get(0), 0, labels);
        return instruction;
    }

    static List<String> splitDoubleOperandString(String line) {
        return InstructionUtil.regex("^\\s*[A-Z]+\\s+([^,]+)\\s*,\\s*(.+?)\\s*$", line, 2);
    }

    static byte[] parseDoubleOperands(String line, List<Label> labels) throws ParseException {
        byte[] instruction = new byte[4];
        List<String> l = InstructionUtil.splitDoubleOperandString(line);
        if (l.size() != 2) {
            throw new ParseException(line, "incorrect operand format");
        }
        instruction = InstructionUtil.parseVariableOperand(line, instruction, l.get(0), 0, labels);
        if (ByteUtil.getBit((instruction = InstructionUtil.parseVariableOperand(line, instruction, l.get(1), 1, labels))[3], 3) && ByteUtil.getBit(instruction[3], 7)) {
            throw new ParseException(line, ERROR_DOUBLE_REFERENCE);
        }
        return instruction;
    }

    static byte[] parseVariableOperand(String line, byte[] instruction, String operand, int operandIndex, List<Label> labels) throws ParseException {
        boolean isMemoryReference = InstructionUtil.isMemoryReference(operand);
        boolean hasMemoryOffset = InstructionUtil.hasMemoryOffset(operand);
        if (isMemoryReference) {
            instruction[3] = ByteUtil.setBit(instruction[3], true, operandIndex * 4 + 3);
            operand = InstructionUtil.stripMemoryReferenceBrackets(operand);
        }
        if (hasMemoryOffset) {
            int offset = InstructionUtil.getMemoryOffset(line, operand);
            instruction = InstructionUtil.setMemoryOffset(instruction, offset, operandIndex);
            operand = InstructionUtil.stripMemoryOffset(operand);
        }
        if (InstructionUtil.isLiteral(operand)) {
            instruction[operandIndex + 1] = InstructionUtil.parseLiteral(line, operand);
            instruction[3] = ByteUtil.setBit(instruction[3], true, operandIndex * 4);
        } else if (InstructionUtil.isRegister(operand)) {
            if (!isMemoryReference && hasMemoryOffset) {
                throw new ParseException(line, ERROR_NON_REFERENCE_OFFSET);
            }
            instruction[operandIndex + 1] = (byte)InstructionUtil.parseRegister(line, operand).ordinal();
        } else {
            instruction[operandIndex + 1] = InstructionUtil.parseLabel(line, operand.toLowerCase(), labels);
            instruction[3] = ByteUtil.setBit(instruction[3], true, operandIndex * 4 + 1);
        }
        return instruction;
    }

    static boolean hasMemoryOffset(String operand) {
        return operand.matches("[^+^-]+[+-]\\s*[0-9]{1,3}]?");
    }

    static byte[] setMemoryOffset(byte[] instructionIn, int offset, int operandIndex) {
        byte[] instruction = new byte[5];
        System.arraycopy(instructionIn, 0, instruction, 0, instructionIn.length);
        instruction[3] = ByteUtil.setBit(instruction[3], true, operandIndex * 4 + 2);
        instruction[4] = (byte)offset;
        return instruction;
    }

    static int getMemoryOffset(String line, String operand) throws ParseException {
        String sOffset = operand.replaceAll("[^+^-]*([+-])\\s*([0-9]{1,2})]?", "$1$2");
        try {
            return Integer.parseInt(sOffset);
        }
        catch (NumberFormatException e) {
            throw new ParseException(line, "Invalid memory offset", e);
        }
    }

    static String stripMemoryOffset(String operand) {
        return operand.replaceAll("([^+-^\\s]+)\\s*[+-]\\s*[0-9]{1,3}(]?)", "$1$2");
    }

    static boolean isMemoryReference(String operand) {
        return operand.matches("\\[[^]]+]");
    }

    static String stripMemoryReferenceBrackets(String operand) {
        return operand.replaceAll("^\\[", "").replaceAll("]$", "");
    }

    private static byte[] parseLabelOperand(String line, List<Label> labels) throws ParseException {
        byte[] instruction = new byte[2];
        List<String> l = InstructionUtil.regex("^\\s*[A-Z]+\\s+([A-Z_-]+)\\s*$", line, 2);
        if (l.size() != 1) {
            throw new ParseException(line, "incorrect label format");
        }
        instruction[1] = InstructionUtil.parseLabel(line, l.get(0).toLowerCase(), labels);
        return instruction;
    }

    private static byte parseLabel(String line, String label, List<Label> labels) throws ParseException {
        try {
            for (int i = 0; i < labels.size(); ++i) {
                if (!labels.get((int)i).name.equalsIgnoreCase(label)) continue;
                return (byte)i;
            }
        }
        catch (Exception e) {
            ModMinecoprocessors.proxy.handleUnexpectedException(e);
            throw new ParseException(line, "[" + label + "] is not a valid label", e);
        }
        throw new ParseException(line, "[" + label + "] has not been defined");
    }

    private static Register parseRegister(String line, String s) throws ParseException {
        s = InstructionUtil.stripMemoryOffset(s).trim().toUpperCase();
        try {
            return Register.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(line, "[" + s + "] is not a valid register", e);
        }
    }

    static boolean isRegister(String operand) {
        if (operand == null) {
            return false;
        }
        operand = InstructionUtil.stripMemoryOffset(operand);
        try {
            Register.valueOf(operand.toUpperCase());
            return true;
        }
        catch (IllegalArgumentException ignore) {
            return false;
        }
    }

    static boolean isLiteral(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).matches("^[0-9-]+$")) {
            return true;
        }
        if (s.matches("^0o[0-7]+$")) {
            return true;
        }
        if (s.matches("^0x[0-9A-Fa-f]+$")) {
            return true;
        }
        if (s.matches("^[0-9-]+d$")) {
            return true;
        }
        return s.matches("^[0-1]+b$");
    }

    static byte parseLiteral(String line, String s) throws ParseException {
        int i = InstructionUtil.parseLiteralToInt(line, s);
        if (i < 0) {
            i += 256;
        }
        if (i > 255 || i < 0) {
            throw new ParseException(line, "operand too large [" + s + "]");
        }
        return (byte)i;
    }

    private static int parseInt(String s, int radix, String line) throws ParseException {
        try {
            return Integer.parseInt(s, radix);
        }
        catch (NumberFormatException e) {
            throw new ParseException(line, "[" + s + "] is not a valid operand literal", e);
        }
    }

    private static int parseLiteralToInt(String line, String s) throws ParseException {
        List<String> l = InstructionUtil.regex("^([0-9-]+)d?$", s = s.trim(), 2);
        if (l.size() == 1) {
            return InstructionUtil.parseInt(l.get(0), 10, line);
        }
        l = InstructionUtil.regex("^0o([0-7]+)$", s, 2);
        if (l.size() == 1) {
            return InstructionUtil.parseInt(l.get(0), 8, line);
        }
        l = InstructionUtil.regex("^0x([0-9A-Fa-f]+)$", s, 2);
        if (l.size() == 1) {
            return InstructionUtil.parseInt(l.get(0), 16, line);
        }
        l = InstructionUtil.regex("^([0-1]+)b$", s, 2);
        if (l.size() == 1) {
            return InstructionUtil.parseInt(l.get(0), 2, line);
        }
        throw new ParseException(line, "invalid operand literal type [" + s + "]");
    }

    public static List<String> regex(String pattern, String screen, int flags) {
        Pattern p = Pattern.compile(pattern, flags);
        Matcher m = p.matcher(screen);
        ArrayList<String> l = new ArrayList<String>();
        if (m.find() && m.groupCount() > 0) {
            for (int i = 1; i <= m.groupCount(); ++i) {
                String s = m.group(i);
                if (s == null) continue;
                l.add(s.replaceAll("\\s+", " ").trim());
            }
            return l;
        }
        return l;
    }

    private static InstructionCode parseInstructionCode(String line) throws ParseException {
        line = line.toUpperCase().trim().split("\\s+")[0];
        try {
            return InstructionCode.valueOf(line);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(line, "invalid command", e);
        }
    }
}

