/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.blocks;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkHooks;
import net.torocraft.minecoprocessors.ModContent;
import net.torocraft.minecoprocessors.blocks.MinecoprocessorTileEntity;

public class MinecoprocessorBlock
extends HorizontalBlock {
    public static final long CONFIG_DEFAULT = 0L;
    public static final long CONFIG_OVERCLOCKED = 1L;
    public final long config;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public MinecoprocessorBlock(long config, AbstractBlock.Properties properties) {
        super(properties);
        this.config = config;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext selectionContext) {
        return SHAPE;
    }

    public boolean func_181623_g() {
        return false;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{field_185512_D, POWERED});
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return MinecoprocessorBlock.func_220064_c((IBlockReader)world, (BlockPos)pos.func_177977_b());
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_195992_f();
        return (BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)field_185512_D, (Comparable)facing)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (world.func_201670_d()) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof MinecoprocessorTileEntity)) {
            return;
        }
        if (stack.func_82837_s()) {
            ((MinecoprocessorTileEntity)te).setCustomName(stack.func_200301_q());
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, world, pos, newState, isMoving);
        if (!world.func_201670_d() && newState.func_177230_c() != state.func_177230_c()) {
            world.func_195593_d(pos, newState.func_177230_c());
            for (Direction side : Direction.values()) {
                world.func_175695_a(pos.func_177972_a(side), newState.func_177230_c(), side.func_176734_d());
            }
        }
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)field_185512_D, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)field_185512_D)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state;
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    public boolean func_149740_M(BlockState state) {
        return false;
    }

    public boolean getWeakChanges(BlockState state, IWorldReader world, BlockPos pos) {
        return true;
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.getPower(state, world, pos, side, false);
    }

    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.getPower(state, world, pos, side, true);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new MinecoprocessorTileEntity(ModContent.TET_MINECOPROCESSOR);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (world.func_201670_d()) {
            return;
        }
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
        BlockPos directionVector = fromPos.func_177973_b((Vector3i)pos);
        if (isMoving || directionVector.func_177956_o() != 0) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MinecoprocessorTileEntity) {
            ((MinecoprocessorTileEntity)te).neighborChanged(fromPos);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof MinecoprocessorTileEntity)) {
            return ActionResultType.FAIL;
        }
        if (!(player instanceof ServerPlayerEntity) && !(player instanceof FakePlayer)) {
            return ActionResultType.FAIL;
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te));
        return ActionResultType.SUCCESS;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        return MinecoprocessorBlock.dropBlock(state, world, pos, player);
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        MinecoprocessorBlock.dropBlock(world.func_180495_p(pos), world, pos, null);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return Collections.singletonList(ItemStack.field_190927_a);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
    }

    private int getPower(BlockState state, IBlockReader world, BlockPos pos, Direction side, boolean strong) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof MinecoprocessorTileEntity)) {
            return 0;
        }
        return ((MinecoprocessorTileEntity)te).getPower(state, side, strong);
    }

    private static boolean dropBlock(BlockState state, World world, BlockPos pos, @Nullable PlayerEntity player) {
        if (!(state.func_177230_c() instanceof MinecoprocessorBlock)) {
            world.func_217377_a(pos, false);
            return true;
        }
        if (!world.func_201670_d()) {
            ItemStack book;
            if (player == null || !player.func_184812_l_()) {
                world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack((IItemProvider)state.func_177230_c().func_199767_j())));
            }
            if (world.func_175625_s(pos) instanceof MinecoprocessorTileEntity && !(book = ((MinecoprocessorTileEntity)world.func_175625_s(pos)).func_70301_a(0)).func_190926_b()) {
                world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, book));
            }
        }
        world.func_175713_t(pos);
        world.func_217377_a(pos, false);
        return true;
    }
}

