/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.WritableBookItem;
import net.minecraft.item.WrittenBookItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.torocraft.minecoprocessors.ModContent;
import net.torocraft.minecoprocessors.ModMinecoprocessors;
import net.torocraft.minecoprocessors.blocks.MinecoprocessorBlock;
import net.torocraft.minecoprocessors.blocks.MinecoprocessorContainer;
import net.torocraft.minecoprocessors.items.CodeBookItem;
import net.torocraft.minecoprocessors.processor.Processor;
import net.torocraft.minecoprocessors.processor.Register;
import net.torocraft.minecoprocessors.util.ByteUtil;
import net.torocraft.minecoprocessors.util.InstructionUtil;
import net.torocraft.minecoprocessors.util.RedstoneUtil;

public class MinecoprocessorTileEntity
extends TileEntity
implements ITickableTileEntity,
INameable,
IInventory,
INamedContainerProvider {
    public static final int NUM_OF_SLOTS = 1;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private final Processor processor = new Processor();
    private final byte[] prevPortValues = new byte[4];
    private final int[] outputPower = new int[Direction.values().length];
    private byte prevPortsRegister = (byte)-1;
    private byte prevAdcRegister = (byte)-1;
    private boolean inventoryChanged = false;
    private boolean inputsChanged = false;
    private boolean outputsChanged = false;
    private boolean initialized = false;
    private String customName = "";
    private int loadTime;
    private int tickTimer = 0;
    protected final ContainerSyncFields fields = new ContainerSyncFields();

    public MinecoprocessorTileEntity() {
        super(ModContent.TET_MINECOPROCESSOR);
    }

    public MinecoprocessorTileEntity(TileEntityType<?> te_type) {
        super(te_type);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.processor.setNBT(nbt.func_74775_l("processor"));
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
        this.loadTime = nbt.func_74765_d("loadTime");
        this.customName = nbt.func_74779_i("CustomName");
        if (this.customName == null) {
            this.customName = "";
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.inventory);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
        nbt.func_218657_a("processor", (INBT)this.processor.getNBT());
        nbt.func_74777_a("loadTime", (short)this.loadTime);
        return nbt;
    }

    public ITextComponent func_200200_C_() {
        if (this.func_145818_k_()) {
            return new StringTextComponent(this.customName);
        }
        BlockState state = this.func_195044_w();
        return new StringTextComponent(state != null ? state.func_177230_c().func_149739_a() : "Minecoprocessor");
    }

    public boolean func_145818_k_() {
        return !this.customName.isEmpty();
    }

    public ITextComponent func_200201_e() {
        return new StringTextComponent(this.customName);
    }

    public ITextComponent func_145748_c_() {
        return super.func_145748_c_();
    }

    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
        return new MinecoprocessorContainer(id, inventory, this, IWorldPosCallable.func_221488_a((World)this.field_145850_b, (BlockPos)this.field_174879_c), this.fields, this.processor);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return index < this.func_70302_i_() ? (ItemStack)this.inventory.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        this.onInventoryChanged();
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        this.onInventoryChanged();
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.onInventoryChanged();
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.func_174877_v().func_177951_i((Vector3i)player.func_233580_cy_()) < 36.0;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
        this.func_70296_d();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return MinecoprocessorTileEntity.isValidBook(stack);
    }

    public void func_174888_l() {
        this.onInventoryChanged();
        this.inventory.clear();
        this.func_70296_d();
    }

    public void func_73660_a() {
        BlockState new_state;
        int i;
        boolean hasBook;
        if (this.field_145850_b.func_201670_d() || --this.tickTimer > 0) {
            return;
        }
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!(state.func_177230_c() instanceof MinecoprocessorBlock)) {
            this.tickTimer = 20;
            return;
        }
        MinecoprocessorBlock block = (MinecoprocessorBlock)state.func_177230_c();
        this.tickTimer = (block.config & 1L) != 0L ? 1 : 2;
        boolean dirty = false;
        boolean bl = hasBook = !((ItemStack)this.inventory.get(0)).func_190926_b();
        if (!this.initialized) {
            this.initialized = true;
            this.updateInputPorts(state, true);
        }
        if (this.inventoryChanged) {
            this.inventoryChanged = false;
            this.customName = MinecoprocessorTileEntity.loadBook((ItemStack)this.inventory.get(0), this.processor);
            this.prevPortsRegister = this.processor.getRegister(Register.PORTS);
            this.prevAdcRegister = this.processor.getRegister(Register.ADC);
            for (i = 0; i < this.prevPortValues.length; ++i) {
                this.prevPortValues[i] = 0;
            }
            for (i = 0; i < this.outputPower.length; ++i) {
                this.outputPower[i] = 0;
            }
            this.inputsChanged = true;
            this.outputsChanged = true;
            dirty = true;
        } else if (hasBook && !this.processor.isFault()) {
            if (this.inputsChanged) {
                this.inputsChanged = false;
                this.updateInputPorts(state, false);
            }
            if (this.processor.tick()) {
                this.outputsChanged = true;
            }
            if (this.prevPortsRegister != this.processor.getRegister(Register.PORTS) || this.prevAdcRegister != this.processor.getRegister(Register.ADC)) {
                this.prevPortsRegister = this.processor.getRegister(Register.PORTS);
                this.prevAdcRegister = this.processor.getRegister(Register.ADC);
                for (i = 0; i < this.prevPortValues.length; ++i) {
                    this.prevPortValues[i] = 0;
                }
                for (i = 0; i < this.outputPower.length; ++i) {
                    this.outputPower[i] = 0;
                }
                this.inputsChanged = true;
                this.outputsChanged = true;
            }
        }
        if (this.outputsChanged) {
            this.outputsChanged = false;
            this.updateOutputs(state, (Block)block);
        }
        if (state != (new_state = (BlockState)state.func_206870_a((Property)MinecoprocessorBlock.POWERED, (Comparable)Boolean.valueOf(hasBook && !this.processor.isWait() && !this.processor.isFault())))) {
            this.field_145850_b.func_180501_a(this.field_174879_c, new_state, 3);
        }
        this.fields.writeServerSide(this.processor);
        if (dirty) {
            this.func_70296_d();
        }
    }

    public static boolean isValidBook(ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() == ModContent.CODE_BOOK || stack.func_77973_b() == Items.field_151164_bB || stack.func_77973_b() == Items.field_151099_bA);
    }

    public static boolean isInInputMode(byte ports, int portIndex) {
        return ByteUtil.getBit(ports, portIndex) && !ByteUtil.getBit(ports, portIndex + 4);
    }

    public static boolean isInOutputMode(byte ports, int portIndex) {
        return !ByteUtil.getBit(ports, portIndex) && !ByteUtil.getBit(ports, portIndex + 4);
    }

    public static boolean isADCMode(byte adc, int portIndex) {
        return ByteUtil.getBit(adc, portIndex);
    }

    public static boolean isInResetMode(byte ports, int portIndex) {
        return ByteUtil.getBit(ports, portIndex) && ByteUtil.getBit(ports, portIndex + 4);
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void resetProcessor() {
        this.inventoryChanged = true;
    }

    public void setCustomName(ITextComponent name) {
        this.customName = name.getString();
    }

    public void neighborChanged(BlockPos fromPos) {
        this.inputsChanged = true;
    }

    public int getPower(BlockState state, Direction side, boolean strong) {
        return this.outputPower[side.func_176734_d().func_176745_a()];
    }

    private void onInventoryChanged() {
        this.inventoryChanged = true;
        this.tickTimer = 0;
    }

    private byte getPortSignal(int portIndex) {
        if (!MinecoprocessorTileEntity.isInOutputMode(this.processor.getRegister(Register.PORTS), portIndex)) {
            return 0;
        }
        byte signal = this.processor.getRegisters()[Register.PF.ordinal() + portIndex];
        return (byte)(MinecoprocessorTileEntity.isADCMode(this.processor.getRegister(Register.ADC), portIndex) ? MathHelper.func_76125_a((int)signal, (int)0, (int)15) : (signal == 0 ? 0 : 15));
    }

    private boolean updateOutputs(BlockState state, Block block) {
        Direction front = (Direction)state.func_177229_b((Property)MinecoprocessorBlock.field_185512_D);
        byte[] registers = this.processor.getRegisters();
        byte ports = this.processor.getRegister(Register.PORTS);
        boolean[] to_update = new boolean[Direction.values().length];
        boolean updated = false;
        for (int portIndex = 0; portIndex < 4; ++portIndex) {
            byte value = registers[Register.PF.ordinal() + portIndex];
            if (this.prevPortValues[portIndex] == value) continue;
            this.prevPortValues[portIndex] = value;
            if (!MinecoprocessorTileEntity.isInOutputMode(ports, portIndex)) continue;
            Direction side = RedstoneUtil.convertPortIndexToFacing(front, portIndex);
            this.outputPower[side.func_176745_a()] = this.getPortSignal(portIndex);
            to_update[side.func_176745_a()] = true;
            updated = true;
        }
        for (Direction side : Direction.values()) {
            if (!to_update[side.func_176745_a()]) continue;
            to_update[side.func_176745_a()] = false;
            BlockPos neighborPos = this.field_174879_c.func_177972_a(side);
            if (ForgeEventFactory.onNeighborNotify((World)this.field_145850_b, (BlockPos)this.field_174879_c, (BlockState)state, EnumSet.of(side), (boolean)false).isCanceled()) continue;
            this.field_145850_b.func_190524_a(neighborPos, block, this.field_174879_c);
            this.field_145850_b.func_175695_a(neighborPos, block, side.func_176734_d());
        }
        return updated;
    }

    private boolean updateInputPorts(BlockState state, boolean initialLoading) {
        Direction front = (Direction)state.func_177229_b((Property)MinecoprocessorBlock.field_185512_D);
        byte[] registers = this.processor.getRegisters();
        byte ports = this.processor.getRegister(Register.PORTS);
        byte adc = this.processor.getRegister(Register.ADC);
        boolean updated = false;
        boolean reset = false;
        for (int portIndex = 0; portIndex < 4; ++portIndex) {
            Direction side = RedstoneUtil.convertPortIndexToFacing(front, portIndex);
            int power = this.getInputPower(this.field_174879_c.func_177972_a(side), side);
            byte value = (byte)(MinecoprocessorTileEntity.isADCMode(adc, portIndex) ? RedstoneUtil.powerToPort(power) : (power == 0 ? 0 : 255));
            if (this.prevPortValues[portIndex] == value) continue;
            this.prevPortValues[portIndex] = value;
            if (MinecoprocessorTileEntity.isInInputMode(ports, portIndex)) {
                registers[Register.PF.ordinal() + portIndex] = value;
                updated = true;
                continue;
            }
            if (value == 0 || !MinecoprocessorTileEntity.isInResetMode(ports, portIndex)) continue;
            updated = true;
            reset = true;
        }
        if (!initialLoading) {
            if (reset) {
                this.processor.reset();
            }
            if (updated) {
                this.processor.wake();
            }
        }
        return updated;
    }

    private int getInputPower(BlockPos pos, Direction side) {
        BlockState adjacent = this.field_145850_b.func_180495_p(pos);
        Block block = adjacent.func_177230_c();
        int p = this.field_145850_b.func_175651_c(pos, side);
        if (p >= 15) {
            return 15;
        }
        return Math.max(p, block instanceof RedstoneWireBlock ? (Integer)adjacent.func_177229_b((Property)RedstoneWireBlock.field_176351_O) : 0);
    }

    public static String loadBook(ItemStack stack, Processor processor) {
        int i;
        ListNBT pages;
        processor.reset();
        if (!MinecoprocessorTileEntity.isValidBook(stack)) {
            processor.load(null);
            return "";
        }
        String title = "";
        if (!stack.func_77942_o()) {
            return title;
        }
        ArrayList<String> code = new ArrayList();
        if (stack.func_77973_b() instanceof CodeBookItem) {
            CodeBookItem.Data data = CodeBookItem.Data.loadFromStack(stack);
            code = data.getContinuousProgram();
            title = data.getProgramName();
        } else if (stack.func_77973_b() instanceof WritableBookItem) {
            pages = stack.func_77978_p().func_150295_c("pages", 8);
            for (i = 0; i < pages.size(); ++i) {
                Collections.addAll(code, pages.func_150307_f(i).split("\\r?\\n"));
            }
        } else if (stack.func_77973_b() instanceof WrittenBookItem) {
            pages = stack.func_77978_p().func_150295_c("pages", 8);
            for (i = 0; i < pages.size(); ++i) {
                try {
                    IFormattableTextComponent tc = ITextComponent.Serializer.func_240644_b_((String)pages.func_150307_f(i));
                    Collections.addAll(code, tc.func_150261_e().split("\\r?\\n"));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (title.isEmpty()) {
            try {
                String name;
                List<String> nameSearch = InstructionUtil.regex("^\\s*;\\s*(.*)", (String)code.get(0), 2);
                if (nameSearch.size() == 1 && (name = nameSearch.get(0)) != null && !name.isEmpty()) {
                    title = name;
                }
            }
            catch (Exception e) {
                ModMinecoprocessors.proxy.handleUnexpectedException(e);
            }
        }
        processor.load(code);
        return title;
    }

    public static final class ContainerSyncFields
    extends IntArray {
        public static int NUM_OF_FIELDS = 8;

        public ContainerSyncFields() {
            super(NUM_OF_FIELDS);
        }

        public void writeServerSide(Processor processor) {
            byte[] regs = processor.getRegisters();
            this.func_221477_a(0, 0 | processor.getIp());
            this.func_221477_a(1, (0 | processor.getSp()) & 0xFF | ((0 | processor.getFaultCode()) & 0xFF) << 8);
            this.func_221477_a(2, (0 | regs[0]) & 0xFF | (0 | regs[1]) << 8);
            this.func_221477_a(3, (0 | regs[2]) & 0xFF | (0 | regs[3]) << 8);
            this.func_221477_a(4, (0 | regs[4]) & 0xFF | (0 | regs[5]) << 8);
            this.func_221477_a(5, (0 | regs[6]) & 0xFF | (0 | regs[7]) << 8);
            this.func_221477_a(6, (0 | regs[8]) & 0xFF | (0 | regs[9]) << 8);
            this.func_221477_a(7, 0 | (processor.isFault() ? 1 : 0) | (processor.isZero() ? 2 : 0) | (processor.isOverflow() ? 4 : 0) | (processor.isCarry() ? 8 : 0) | (processor.isWait() ? 16 : 0) | (processor.isStep() ? 32 : 0) | (processor.hasProgram() ? 64 : 0));
        }

        public short ip() {
            return (short)this.func_221476_a(0);
        }

        public byte sp() {
            return (byte)(this.func_221476_a(0) & 0xFF);
        }

        public byte fault() {
            return (byte)(this.func_221476_a(0) >> 8 & 0xFF);
        }

        public byte register(int i) {
            return (byte)(this.func_221476_a(2 + (i >> 1)) >> 8 * (i & 1) & 0xFF);
        }

        public byte port(int i) {
            return this.register(i + 4);
        }

        public byte ports() {
            return this.register(8);
        }

        public byte adc() {
            return this.register(9);
        }

        public boolean isFault() {
            return (this.func_221476_a(7) & 1) != 0;
        }

        public boolean isZero() {
            return (this.func_221476_a(7) & 2) != 0;
        }

        public boolean isOverflow() {
            return (this.func_221476_a(7) & 4) != 0;
        }

        public boolean isCarry() {
            return (this.func_221476_a(7) & 8) != 0;
        }

        public boolean isWait() {
            return (this.func_221476_a(7) & 0x10) != 0;
        }

        public boolean isStep() {
            return (this.func_221476_a(7) & 0x20) != 0;
        }

        public boolean isLoaded() {
            return (this.func_221476_a(7) & 0x40) != 0;
        }
    }
}

