/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.items;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.WrittenBookItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.torocraft.minecoprocessors.items.CodeBookContainer;
import net.torocraft.minecoprocessors.util.StringUtil;

public final class CodeBookItem
extends WrittenBookItem {
    public CodeBookItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        Data data = Data.loadFromStack(stack);
        if (data.getProgram().isEmpty()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.minecoprocessors.code_book.tooltip.noprogram"));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.minecoprocessors.code_book.tooltip"));
        } else if ((InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)344)) && (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)341) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)345))) {
            String txt = data.getPage(0).stream().limit(10L).filter(s -> !s.isEmpty()).collect(Collectors.joining("\n")).trim();
            if (!txt.isEmpty()) {
                tooltip.add((ITextComponent)new StringTextComponent(txt));
            }
        } else {
            String program_name = data.getProgramName();
            if (!program_name.isEmpty()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.minecoprocessors.code_book.tooltip.program", new Object[]{program_name}));
            }
            tooltip.add((ITextComponent)new TranslationTextComponent("item.minecoprocessors.code_book.tooltip.numpages", new Object[]{String.format("%d", data.getPageCount())}));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.minecoprocessors.code_book.tooltip"));
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.func_201670_d()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent(CodeBookItem.this.getRegistryName().toString());
                }

                public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
                    return new CodeBookContainer(id, inventory, player);
                }
            });
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public static class Data {
        private static final String TAG_PAGES = "pages";
        private static final String TAG_SELECTED = "selected";
        private final List<List<String>> pages = new ArrayList<List<String>>();
        private int selectedPage = 0;

        public String getProgramName() {
            for (List<String> page : this.pages) {
                for (String line : page) {
                    String name = line.trim();
                    if (name.isEmpty()) continue;
                    return name.charAt(0) != ';' ? "" : name.substring(1).trim();
                }
            }
            return "";
        }

        public int getSelectedPage() {
            return this.selectedPage;
        }

        public void setSelectedPage(int index) {
            this.selectedPage = index;
            this.validateSelectedPage();
        }

        public int getPageCount() {
            return this.pages.size();
        }

        public List<String> getPage(int index) {
            return Collections.unmodifiableList(this.pages.get(index));
        }

        public void addPage() {
            this.pages.add(Collections.singletonList(""));
            this.setSelectedPage(this.pages.size() - 1);
        }

        public void setPage(int page, List<String> code) {
            this.pages.set(page, new ArrayList<String>(code));
        }

        public void removePage(int index) {
            this.pages.remove(index);
            this.validateSelectedPage();
        }

        public List<List<String>> getProgram() {
            return Collections.unmodifiableList(this.pages);
        }

        public List<String> getContinuousProgram() {
            ArrayList<String> program = new ArrayList<String>();
            for (int i = 0; i < this.pages.size(); ++i) {
                program.addAll(this.getPage(i));
            }
            return program;
        }

        public void readNBT(CompoundNBT nbt) {
            this.pages.clear();
            ListNBT pagesNbt = nbt.func_150295_c(TAG_PAGES, 8);
            for (int index = 0; index < pagesNbt.size(); ++index) {
                this.pages.add(Arrays.asList(StringUtil.splitLines(pagesNbt.func_150307_f(index))));
            }
            this.selectedPage = nbt.func_74762_e(TAG_SELECTED);
            this.validateSelectedPage();
        }

        public CompoundNBT writeNBT(CompoundNBT nbt) {
            ListNBT pagesNbt = new ListNBT();
            int removed = 0;
            for (int index = 0; index < this.pages.size(); ++index) {
                List<String> program = this.pages.get(index);
                if (program.size() > 1 || program.get(0).length() > 0) {
                    pagesNbt.add((Object)StringNBT.func_229705_a_((String)String.join((CharSequence)"\n", program)));
                    continue;
                }
                if (index >= this.selectedPage) continue;
                ++removed;
            }
            nbt.func_218657_a(TAG_PAGES, (INBT)pagesNbt);
            nbt.func_74768_a(TAG_SELECTED, this.selectedPage - removed);
            return nbt;
        }

        private void validateSelectedPage() {
            this.selectedPage = Math.max(0, Math.min(this.pages.size() - 1, this.selectedPage));
        }

        private boolean areAllPagesEqual(List<List<String>> newPages, int startPage) {
            for (int offset = 0; offset < newPages.size(); ++offset) {
                List<String> want;
                List<String> have = this.pages.get(startPage + offset);
                if (Objects.equals(have, want = newPages.get(offset))) continue;
                return false;
            }
            return true;
        }

        public static Data loadFromNBT(@Nullable CompoundNBT nbt) {
            Data data = new Data();
            if (nbt != null) {
                data.readNBT(nbt);
            }
            return data;
        }

        public static Data loadFromStack(ItemStack stack) {
            return Data.loadFromNBT(stack.func_77978_p());
        }

        public static void saveToStack(ItemStack stack, Data data) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new CompoundNBT();
                stack.func_77982_d(nbt);
            }
            data.writeNBT(nbt);
        }
    }
}

