/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.processor;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.torocraft.minecoprocessors.ModMinecoprocessors;
import net.torocraft.minecoprocessors.processor.InstructionCode;
import net.torocraft.minecoprocessors.processor.Register;
import net.torocraft.minecoprocessors.util.ByteUtil;
import net.torocraft.minecoprocessors.util.InstructionUtil;
import net.torocraft.minecoprocessors.util.Label;
import net.torocraft.minecoprocessors.util.ParseException;

public class Processor {
    private static final int MEMORY_SIZE = 64;
    List<Label> labels = new ArrayList<Label>();
    List<byte[]> program = new ArrayList<byte[]>();
    byte[] instruction;
    protected byte[] stack = new byte[64];
    byte[] registers = new byte[Register.values().length];
    byte faultCode = (byte)-1;
    short ip;
    byte sp;
    boolean fault;
    boolean zero;
    boolean overflow;
    boolean carry;
    boolean wait;
    private boolean step;
    private String error = "";

    void flush() {
        this.reset();
        this.stack = new byte[64];
        this.labels.clear();
        this.program.clear();
    }

    public void reset() {
        this.fault = false;
        this.zero = false;
        this.overflow = false;
        this.carry = false;
        this.wait = false;
        this.step = false;
        this.error = "";
        this.ip = 0;
        this.sp = 0;
        this.registers = new byte[Register.values().length];
        this.registers[Register.PORTS.ordinal()] = 16;
        this.faultCode = (byte)-1;
    }

    public void wake() {
        this.wait = false;
    }

    public boolean load(List<String> file) {
        try {
            this.flush();
            if (file != null) {
                this.program = InstructionUtil.parseFile(file, this.labels);
                return !this.program.isEmpty();
            }
            this.program = new ArrayList<byte[]>();
            this.labels = new ArrayList<Label>();
        }
        catch (ParseException e) {
            this.error = e.getMessage();
            this.faultCode = (byte)4;
            this.fault = true;
        }
        return false;
    }

    long packFlags() {
        long flags = 0L;
        flags = ByteUtil.setShort(flags, this.ip, 3);
        flags = ByteUtil.setByte(flags, this.sp, 5);
        flags = ByteUtil.setBit(flags, this.fault, 0);
        flags = ByteUtil.setBit(flags, this.zero, 1);
        flags = ByteUtil.setBit(flags, this.overflow, 2);
        flags = ByteUtil.setBit(flags, this.carry, 3);
        flags = ByteUtil.setBit(flags, this.wait, 4);
        return flags;
    }

    void unPackFlags(long flags) {
        this.ip = ByteUtil.getShort(flags, 3);
        this.sp = ByteUtil.getByte(flags, 5);
        this.fault = ByteUtil.getBit(flags, 0);
        this.zero = ByteUtil.getBit(flags, 1);
        this.overflow = ByteUtil.getBit(flags, 2);
        this.carry = ByteUtil.getBit(flags, 3);
        this.wait = ByteUtil.getBit(flags, 4);
    }

    private static byte[] addRegistersIfMissing(byte[] registersIn) {
        if (registersIn.length >= Register.values().length) {
            return registersIn;
        }
        byte[] registersNew = new byte[Register.values().length];
        System.arraycopy(registersIn, 0, registersNew, 0, registersIn.length);
        return registersNew;
    }

    public void setNBT(CompoundNBT nbt) {
        this.stack = nbt.func_74770_j("stack");
        this.registers = Processor.addRegistersIfMissing(nbt.func_74770_j("registers"));
        this.faultCode = nbt.func_74771_c("faultCode");
        this.unPackFlags(nbt.func_74763_f("flags"));
        this.error = nbt.func_74779_i("error");
        this.program = new ArrayList<byte[]>();
        ListNBT programTag = (ListNBT)nbt.func_74781_a("program");
        if (programTag != null) {
            for (INBT tag : programTag) {
                this.program.add(((ByteArrayNBT)tag).func_150292_c());
            }
        }
        this.labels = new ArrayList<Label>();
        ListNBT labelTag = (ListNBT)nbt.func_74781_a("labels");
        if (labelTag != null) {
            for (INBT tag : labelTag) {
                this.labels.add(Label.fromNbt((CompoundNBT)tag));
            }
        }
    }

    public CompoundNBT getNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74773_a("stack", this.stack);
        nbt.func_74773_a("registers", this.registers);
        nbt.func_74774_a("faultCode", this.faultCode);
        nbt.func_74772_a("flags", this.packFlags());
        nbt.func_74778_a("error", this.error);
        ListNBT programTag = new ListNBT();
        for (byte[] b : this.program) {
            programTag.add((Object)new ByteArrayNBT(b));
        }
        nbt.func_218657_a("program", (INBT)programTag);
        ListNBT labelTag = new ListNBT();
        for (Label label : this.labels) {
            labelTag.add((Object)label.toNbt());
        }
        nbt.func_218657_a("labels", (INBT)labelTag);
        return nbt;
    }

    public boolean tick() {
        if (this.fault || this.wait && !this.step) {
            return false;
        }
        this.step = false;
        try {
            this.process();
        }
        catch (Exception e) {
            ModMinecoprocessors.proxy.handleUnexpectedException(e);
            this.error = this.getInstructionString();
            this.fault = true;
        }
        return true;
    }

    private String getInstructionString() {
        try {
            return InstructionUtil.compileLine(this.instruction, this.labels, this.ip);
        }
        catch (Exception e) {
            ModMinecoprocessors.proxy.handleUnexpectedException(e);
            return "??";
        }
    }

    private void process() throws ParseException {
        if (this.ip >= this.program.size()) {
            this.faultCode = (byte)3;
            this.fault = true;
            return;
        }
        if (this.ip < 0) {
            this.ip = 0;
        }
        this.instruction = this.program.get(this.ip);
        this.ip = (short)(this.ip + 1);
        switch (InstructionCode.values()[this.instruction[0]]) {
            case ADD: {
                this.processAdd();
                return;
            }
            case AND: {
                this.processAnd();
                return;
            }
            case CALL: {
                this.processCall();
                return;
            }
            case CMP: {
                this.processCmp();
                return;
            }
            case DIV: {
                this.processDiv();
                return;
            }
            case JMP: 
            case LOOP: {
                this.processJmp();
                return;
            }
            case JNZ: 
            case JNE: {
                this.processJnz();
                return;
            }
            case JZ: 
            case JE: {
                this.processJz();
                return;
            }
            case JG: {
                this.processJg();
                return;
            }
            case JGE: {
                this.processJge();
                return;
            }
            case JL: {
                this.processJl();
                return;
            }
            case JLE: {
                this.processJle();
                return;
            }
            case MOV: {
                this.processMov();
                return;
            }
            case MUL: {
                this.processMul();
                return;
            }
            case NOP: 
            case INT: {
                return;
            }
            case NOT: {
                this.processNot();
                return;
            }
            case OR: {
                this.processOr();
                return;
            }
            case POPA: {
                this.processPopAll();
                return;
            }
            case POP: {
                this.processPop();
                return;
            }
            case PUSH: {
                this.processPush();
                return;
            }
            case PUSHA: {
                this.processPushAll();
                return;
            }
            case RET: {
                this.processRet();
                return;
            }
            case SAL: 
            case SHL: {
                this.processShl();
                return;
            }
            case SHR: {
                this.processShr();
                return;
            }
            case SUB: {
                this.processSub();
                return;
            }
            case XOR: {
                this.processXor();
                return;
            }
            case WFE: {
                this.processWfe();
                return;
            }
            case INC: {
                this.processInc();
                return;
            }
            case DEC: {
                this.processDec();
                return;
            }
            case DJNZ: {
                this.processDjnz();
                break;
            }
            case JC: {
                this.processJc();
                break;
            }
            case JNC: {
                this.processJnc();
                break;
            }
            case ROR: {
                this.processRor();
                break;
            }
            case ROL: {
                this.processRol();
                break;
            }
            case SAR: {
                this.processSar();
                break;
            }
            case HLT: {
                this.processHlt();
                break;
            }
            case CLZ: {
                this.processClz();
                break;
            }
            case CLC: {
                this.processClc();
                break;
            }
            case SEZ: {
                this.processSez();
                break;
            }
            case SEC: {
                this.processSec();
                break;
            }
            case DUMP: {
                this.processDump();
                break;
            }
            default: {
                throw new RuntimeException("InstructionCode enum had unexpected value");
            }
        }
    }

    void processMov() throws ParseException {
        byte source = this.getVariableOperand(1);
        if (Processor.isLabelOperand(this.instruction, 0)) {
            throw new ParseException(InstructionUtil.compileLine(this.instruction, this.labels, (short)0), "labels can not be the first of two operands");
        }
        if (Processor.isMemoryReferenceOperand(this.instruction, 0)) {
            this.writeToMemory(source);
        } else {
            this.registers[this.instruction[1]] = source;
        }
    }

    private void writeToMemory(byte source) {
        try {
            this.stack[this.getVariableOperandNoReference((int)0) + this.getMemoryOffset((int)0)] = source;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.faultCode = (byte)5;
            this.fault = true;
        }
    }

    void processAdd() {
        byte a = this.getVariableOperand(0);
        byte b = this.getVariableOperand(1);
        int z = a + b;
        this.testOverflow(z);
        this.zero = z == 0;
        this.registers[this.instruction[1]] = (byte)z;
    }

    void processAnd() {
        byte b;
        byte a = this.getVariableOperand(0);
        byte z = (byte)(a & (b = this.getVariableOperand(1)));
        this.zero = z == 0;
        this.registers[this.instruction[1]] = z;
    }

    void processXor() {
        byte b;
        byte a = this.getVariableOperand(0);
        byte z = (byte)(a ^ (b = this.getVariableOperand(1)));
        this.zero = z == 0;
        this.registers[this.instruction[1]] = z;
    }

    void processOr() {
        byte b;
        byte a = this.getVariableOperand(0);
        byte z = (byte)(a | (b = this.getVariableOperand(1)));
        this.zero = z == 0;
        this.registers[this.instruction[1]] = z;
    }

    void processNot() {
        byte a = this.getVariableOperand(0);
        byte z = ~a;
        this.zero = z == 0;
        this.registers[this.instruction[1]] = z;
    }

    void processSub() {
        byte a = this.getVariableOperand(0);
        byte b = this.getVariableOperand(1);
        int z = a - b;
        this.testOverflow(z);
        this.zero = z == 0;
        this.registers[this.instruction[1]] = (byte)z;
    }

    void processCmp() {
        byte a = this.getVariableOperand(0);
        byte b = this.getVariableOperand(1);
        int z = a - b;
        this.testOverflow(z);
        if (a > b) {
            this.zero = false;
            this.carry = false;
        } else if (a < b) {
            this.zero = false;
            this.carry = true;
        } else if (a == b) {
            this.zero = true;
            this.carry = false;
        }
    }

    void processShl() {
        byte z;
        byte a = this.getVariableOperand(0);
        int b = this.getVariableOperand(1);
        if (b > 8) {
            b = 8;
        }
        this.zero = (z = (byte)(a << b)) == 0;
        this.registers[this.instruction[1]] = z;
    }

    void processShr() {
        byte z;
        int a = this.getVariableOperand(0) & 0xFF;
        int b = this.getVariableOperand(1) & 0xFF;
        if (b > 8) {
            b = 8;
        }
        this.zero = (z = (byte)(a >>> b)) == 0;
        this.registers[this.instruction[1]] = z;
    }

    void processSar() {
        byte n;
        byte a = this.getVariableOperand(0);
        byte z = (byte)(a >> (n = (byte)Math.min(this.getVariableOperand(1), 8)));
        this.zero = z == 0;
        this.registers[this.instruction[1]] = z;
    }

    void processRor() {
        byte n;
        int a = this.getVariableOperand(0) & 0xFF;
        byte z = (byte)(a >>> (n = (byte)Math.min(this.getVariableOperand(1), 8)) | a << 8 - n);
        this.zero = z == 0;
        this.registers[this.instruction[1]] = z;
    }

    void processRol() {
        byte n;
        int a = this.getVariableOperand(0) & 0xFF;
        byte z = (byte)(a << (n = (byte)Math.min(this.getVariableOperand(1), 8)) | a >>> 8 - n);
        this.zero = z == 0;
        this.registers[this.instruction[1]] = z;
    }

    void processWfe() {
        this.wait = true;
    }

    void processHlt() {
        this.faultCode = (byte)-2;
        this.fault = true;
    }

    void processClz() {
        this.zero = false;
    }

    void processClc() {
        this.carry = false;
    }

    void processSez() {
        this.zero = true;
    }

    void processSec() {
        this.carry = true;
    }

    void processJmp() {
        this.ip = this.labels.get((int)this.instruction[1]).address;
    }

    void processJz() {
        if (this.zero) {
            this.processJmp();
        }
    }

    void processJnz() {
        if (!this.zero) {
            this.processJmp();
        }
    }

    void processJc() {
        if (this.carry) {
            this.processJmp();
        }
    }

    void processJnc() {
        if (!this.carry) {
            this.processJmp();
        }
    }

    void processJg() {
        if (!this.carry && !this.zero) {
            this.processJmp();
        }
    }

    void processJge() {
        if (!this.carry && !this.zero || !this.carry && this.zero) {
            this.processJmp();
        }
    }

    void processJl() {
        if (this.carry && !this.zero) {
            this.processJmp();
        }
    }

    void processJle() {
        if (this.carry && this.zero || !this.carry && this.zero) {
            this.processJmp();
        }
    }

    void processDjnz() {
        this.processDec();
        byte tmp = this.instruction[1];
        this.instruction[1] = this.instruction[2];
        this.processJnz();
        this.instruction[1] = tmp;
    }

    void processPushAll() {
        for (int i = 0; i < 4; ++i) {
            if (this.sp >= this.stack.length) {
                this.faultCode = (byte)2;
                this.fault = true;
                return;
            }
            byte by = this.sp;
            this.sp = (byte)(by + 1);
            this.stack[by] = this.registers[i];
        }
    }

    void processPush() {
        if (this.sp >= this.stack.length) {
            this.faultCode = (byte)2;
            this.fault = true;
            return;
        }
        byte a = this.getVariableOperand(0);
        byte by = this.sp;
        this.sp = (byte)(by + 1);
        this.stack[by] = a;
    }

    void processPop() {
        if (this.sp <= 0) {
            this.faultCode = 1;
            this.fault = true;
            return;
        }
        this.sp = (byte)(this.sp - 1);
        this.registers[this.instruction[1]] = this.stack[this.sp];
    }

    void processPopAll() {
        for (int i = 3; i >= 0; --i) {
            if (this.sp <= 0) {
                this.faultCode = 1;
                this.fault = true;
                return;
            }
            this.sp = (byte)(this.sp - 1);
            this.registers[i] = this.stack[this.sp];
        }
    }

    void processCall() {
        if (this.sp >= this.stack.length - 1) {
            this.faultCode = (byte)2;
            this.fault = true;
            return;
        }
        byte by = this.sp;
        this.sp = (byte)(by + 1);
        this.stack[by] = ByteUtil.getByte(this.ip, 0);
        byte by2 = this.sp;
        this.sp = (byte)(by2 + 1);
        this.stack[by2] = ByteUtil.getByte(this.ip, 1);
        this.ip = this.labels.get((int)this.instruction[1]).address;
    }

    void processRet() {
        if (this.sp <= 1) {
            this.faultCode = 1;
            this.fault = true;
            this.error = "ret";
            return;
        }
        this.sp = (byte)(this.sp - 1);
        this.ip = ByteUtil.setByte(this.ip, this.stack[this.sp], 1);
        this.sp = (byte)(this.sp - 1);
        this.ip = ByteUtil.setByte(this.ip, this.stack[this.sp], 0);
    }

    void processInc() {
        byte a = this.getVariableOperand(0);
        int z = a + 1;
        this.zero = z == 0;
        this.registers[this.instruction[1]] = (byte)z;
    }

    void processDec() {
        byte a = this.getVariableOperand(0);
        int z = a - 1;
        this.zero = z == 0;
        this.registers[this.instruction[1]] = (byte)z;
    }

    void testOverflow(long z) {
        this.overflow = z != (long)((byte)z);
    }

    void processMul() {
        byte b;
        byte a = this.registers[Register.A.ordinal()];
        long z = a * (b = this.getVariableOperand(0));
        this.zero = z == 0L;
        this.testOverflow(z);
        this.registers[Register.A.ordinal()] = (byte)z;
    }

    void processDiv() {
        byte a = this.registers[Register.A.ordinal()];
        byte b = this.getVariableOperand(0);
        if (b == 0) {
            this.faultCode = 0;
            this.fault = true;
            return;
        }
        long z = a / b;
        this.zero = z == 0L;
        this.testOverflow(z);
        this.registers[Register.A.ordinal()] = (byte)z;
    }

    void processDump() {
        System.out.println(this.coreDump());
    }

    public String coreDump() {
        StringBuilder s = new StringBuilder();
        s.append("Redstone Processor:\n\n");
        s.append(" a  b  c  d    pf pb pl pr\n");
        s.append(" ");
        this.dumpRegister(s, Register.A);
        s.append(" ");
        this.dumpRegister(s, Register.B);
        s.append(" ");
        this.dumpRegister(s, Register.C);
        s.append(" ");
        this.dumpRegister(s, Register.D);
        s.append("   ");
        this.dumpRegister(s, Register.PF);
        s.append(" ");
        this.dumpRegister(s, Register.PB);
        s.append(" ");
        this.dumpRegister(s, Register.PL);
        s.append(" ");
        this.dumpRegister(s, Register.PR);
        s.append("\n\n");
        s.append(" ports  adc    ZF CF F  S\n");
        s.append(" ");
        this.dumpRegister(s, Register.PORTS);
        s.append("     ");
        this.dumpRegister(s, Register.ADC);
        s.append("     ");
        Processor.dumpFlag(s, this.zero);
        s.append(" ");
        Processor.dumpFlag(s, this.carry);
        s.append(" ");
        Processor.dumpFlag(s, this.fault);
        s.append(" ");
        Processor.dumpFlag(s, this.wait);
        s.append("\n\n");
        s.append(" fault code: ");
        s.append(" ");
        s.append(this.faultCode);
        s.append("\n\n");
        s.append(" memory\n");
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                s.append(" ");
            }
            s.append("\n");
        }
        return s.toString();
    }

    private void dumpRegister(StringBuilder s, Register reg) {
        s.append(Processor.fix(Processor.pad(Integer.toUnsignedString(this.registers[reg.ordinal()], 16))));
    }

    private static void dumpFlag(StringBuilder s, boolean flag) {
        s.append(flag ? "1 " : "0 ");
    }

    public String stateLineDump() {
        return String.format("{ ip:%04x sp:%02x f:%s regs:%02x%02x%02x%02x io:%02x%02x%02x%02x }", this.ip, this.sp, (this.fault ? "F" : "-") + (this.zero ? "Z" : "-") + (this.overflow ? "O" : "-") + (this.carry ? "C" : "-") + (this.wait ? "W" : "-"), this.registers[Register.A.ordinal()], this.registers[Register.B.ordinal()], this.registers[Register.C.ordinal()], this.registers[Register.D.ordinal()], this.registers[Register.PF.ordinal()], this.registers[Register.PB.ordinal()], this.registers[Register.PL.ordinal()], this.registers[Register.PR.ordinal()]);
    }

    byte getVariableOperand(int operandIndex) {
        if (Processor.isLabelOperand(this.instruction, operandIndex)) {
            return this.getProgramValueFromLabelOperand(operandIndex);
        }
        byte value = this.getVariableOperandNoReference(operandIndex);
        if (Processor.isMemoryReferenceOperand(this.instruction, operandIndex)) {
            value = this.stack[value];
        }
        return value;
    }

    private byte getProgramValueFromLabelOperand(int operandIndex) {
        byte value = this.instruction[operandIndex + 1];
        short address = this.labels.get((int)value).address;
        if (Processor.isOffsetOperand(this.instruction, operandIndex)) {
            address = (short)(address + this.instruction[4]);
        }
        return this.program.get(address)[1];
    }

    int getMemoryOffset(int operandIndex) {
        if (Processor.isOffsetOperand(this.instruction, operandIndex)) {
            return this.instruction[4];
        }
        return 0;
    }

    byte getVariableOperandNoReference(int operandIndex) {
        byte value = this.instruction[operandIndex + 1];
        if (Processor.isRegisterOperand(this.instruction, operandIndex)) {
            value = this.registers[value];
        }
        return value;
    }

    public static boolean isMemoryReferenceOperand(byte[] instruction, int operandIndex) {
        return ByteUtil.getBit(instruction[3], operandIndex * 4 + 3);
    }

    public static boolean isOffsetOperand(byte[] instruction, int operandIndex) {
        return ByteUtil.getBit(instruction[3], operandIndex * 4 + 2);
    }

    public static boolean isLiteralOperand(byte[] instruction, int operandIndex) {
        int offset = operandIndex * 4;
        return ByteUtil.getBit(instruction[3], offset) && !ByteUtil.getBit(instruction[3], offset + 1);
    }

    public static boolean isRegisterOperand(byte[] instruction, int operandIndex) {
        int offset = operandIndex * 4;
        return !ByteUtil.getBit(instruction[3], offset) && !ByteUtil.getBit(instruction[3], offset + 1);
    }

    public static boolean isLabelOperand(byte[] instruction, int operandIndex) {
        int offset = operandIndex * 4;
        return !ByteUtil.getBit(instruction[3], offset) && ByteUtil.getBit(instruction[3], offset + 1);
    }

    public boolean isFault() {
        return this.fault;
    }

    private static String pad(String s) {
        if (s.length() == 1) {
            return "0" + s;
        }
        return s;
    }

    private static String fix(String s) {
        if (s.length() > 2) {
            return s.substring(s.length() - 2, s.length());
        }
        return s;
    }

    public byte[] getRegisters() {
        return this.registers;
    }

    public byte getRegister(Register reg) {
        return this.registers[reg.ordinal()];
    }

    public List<byte[]> getProgram() {
        return this.program;
    }

    public boolean hasProgram() {
        return this.program != null && !this.program.isEmpty();
    }

    public short getIp() {
        return this.ip;
    }

    public byte getSp() {
        return this.sp;
    }

    public boolean isZero() {
        return this.zero;
    }

    public boolean isOverflow() {
        return this.overflow;
    }

    public boolean isCarry() {
        return this.carry;
    }

    public boolean isWait() {
        return this.wait;
    }

    public void setWait(boolean wait) {
        this.wait = wait;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public void setStep(boolean step) {
        this.step = step;
    }

    public boolean isStep() {
        return this.step;
    }

    public String getError() {
        return this.error;
    }

    public byte getFaultCode() {
        return this.faultCode;
    }
}

