/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.minecoprocessors.util;

import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class RedstoneUtil {
    private static final Direction[] fwd_port_mapping = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private static final int[] rev_port_mapping = new int[]{1, 2, 0, 3};

    public static Direction convertPortIndexToFacing(Direction facing, int portIndex) {
        return RedstoneUtil.rotateFacing(fwd_port_mapping[portIndex & 3], RedstoneUtil.getRotation(facing));
    }

    public static int convertFacingToPortIndex(Direction facing, Direction side) {
        return rev_port_mapping[RedstoneUtil.rotateFacing(side, -RedstoneUtil.getRotation(facing)).func_176736_b() & 3];
    }

    private static Direction rotateFacing(Direction facing, int rotation) {
        if (rotation >= 0) {
            for (int i = 0; i < rotation; ++i) {
                facing = facing.func_176746_e();
            }
        } else {
            rotation = -rotation;
            for (int i = 0; i < rotation; ++i) {
                facing = facing.func_176735_f();
            }
        }
        return facing;
    }

    private static int getRotation(Direction facing) {
        switch (facing) {
            case NORTH: {
                return 0;
            }
            case EAST: {
                return 1;
            }
            case SOUTH: {
                return 2;
            }
            case WEST: {
                return 3;
            }
        }
        return -1;
    }

    public static int portToPower(byte port) {
        return port & 0xF;
    }

    public static byte powerToPort(int powerValue) {
        return (byte)Math.min(powerValue, 15);
    }

    public static boolean isFrontPort(BlockState blockState, Direction side) {
        return blockState.func_177229_b((Property)HorizontalBlock.field_185512_D) == side;
    }

    public static boolean isBackPort(BlockState blockState, Direction side) {
        return ((Direction)blockState.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_176734_d() == side;
    }

    public static boolean isLeftPort(BlockState blockState, Direction side) {
        return ((Direction)blockState.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_176735_f() == side;
    }

    public static boolean isRightPort(BlockState blockState, Direction side) {
        return ((Direction)blockState.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_176746_e() == side;
    }

    public static BlockPos getFrontBlock(IBlockReader blockAccess, BlockPos pos) {
        return pos.func_177972_a((Direction)blockAccess.func_180495_p(pos).func_177229_b((Property)HorizontalBlock.field_185512_D));
    }
}

