/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.tile.TileEntityXPSolidifier;
import mob_grinding_utils.util.CapHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class BlockXPSolidifier
extends BaseEntityBlock {
    public static final MapCodec<BlockXPSolidifier> CODEC = BlockXPSolidifier.simpleCodec(BlockXPSolidifier::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public BlockXPSolidifier(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileEntityXPSolidifier(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@Nonnull Level pLevel, @Nonnull BlockState pState, @Nonnull BlockEntityType<T> pBlockEntityType) {
        return TileEntityXPSolidifier::tick;
    }

    @Nonnull
    public RenderShape getRenderShape(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    public BlockState playerWillDestroy(Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        TileEntityXPSolidifier tile;
        if (!world.isClientSide && !player.getAbilities().instabuild && (tile = (TileEntityXPSolidifier)world.getBlockEntity(pos)) != null) {
            CompoundTag nbt = new CompoundTag();
            tile.saveAdditional(nbt);
            ItemStack stack = new ItemStack((ItemLike)Item.byBlock((Block)this), 1);
            if (tile.tank.getFluidAmount() > 0) {
                stack.setTag(nbt);
            }
            Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
            if (!tile.inputSlots.getStackInSlot(0).isEmpty()) {
                Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)tile.inputSlots.getStackInSlot(0));
            }
            if (!tile.inputSlots.getStackInSlot(1).isEmpty()) {
                Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)tile.inputSlots.getStackInSlot(1));
            }
            if (!tile.outputSlot.getStackInSlot(0).isEmpty()) {
                Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)tile.outputSlot.getStackInSlot(0));
            }
            world.removeBlockEntity(pos);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void setPlacedBy(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        BlockEntity tileentity;
        super.setPlacedBy(world, pos, state, placer, stack);
        if (!world.isClientSide && stack.hasTag() && (tileentity = world.getBlockEntity(pos)) instanceof TileEntityXPSolidifier && !stack.getTag().contains("Empty")) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)stack.getTag());
            ((TileEntityXPSolidifier)tileentity).tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nonnull
    public InteractionResult use(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof TileEntityXPSolidifier) {
            if (!player.getItemInHand(hand).isEmpty() && player.getItemInHand(hand).getItem() instanceof BucketItem) {
                Optional<IFluidHandler> fluidHandler = CapHelper.getFluidHandler(world, pos, hit.getDirection());
                fluidHandler.ifPresent(handler -> {
                    if (player.getItemInHand(hand).isEmpty() && !handler.getFluidInTank(0).isEmpty()) {
                        player.displayClientMessage((Component)Component.translatable((String)(handler.getFluidInTank(0).getDisplayName().getString() + ": " + handler.getFluidInTank(0).getAmount() + "/" + handler.getTankCapacity(0))), true);
                    } else {
                        FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)world, (BlockPos)pos, (Direction)hit.getDirection());
                    }
                });
                return InteractionResult.SUCCESS;
            }
            player.openMenu((MenuProvider)((TileEntityXPSolidifier)tileentity), pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

