/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.entity.EntityXPOrbFalling;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MGUFlowingFluidBlock
extends LiquidBlock {
    public MGUFlowingFluidBlock(FlowingFluid fluidIn, BlockBehaviour.Properties builder) {
        super(fluidIn, builder);
    }

    public MGUFlowingFluidBlock(Supplier<? extends FlowingFluid> supplier, BlockBehaviour.Properties properties) {
        super(supplier, properties);
    }

    public void entityInside(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        if (!world.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            if (world.getGameTime() % 20L == 0L && player.getFoodData().getFoodLevel() > 0) {
                player.getFoodData().setFoodLevel(player.getFoodData().getFoodLevel() - 1);
                EntityXPOrbFalling orb = new EntityXPOrbFalling(world, (double)pos.getX() + 0.5, (double)pos.getY() - 0.125, (double)pos.getZ() + 0.5, 1);
                world.addFreshEntity((Entity)orb);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(@Nonnull BlockState stateIn, Level world, BlockPos pos, @Nonnull RandomSource rand) {
        if (world.isEmptyBlock(pos.above()) && world.getGameTime() % 5L == 0L) {
            float xx = (float)pos.getX() + 0.5f;
            float zz = (float)pos.getZ() + 0.5f;
            float fixedOffset = 0.25f;
            float randomOffset = rand.nextFloat() * 0.6f - 0.3f;
            world.addParticle((ParticleOptions)MobGrindingUtils.PARTICLE_FLUID_XP.get(), false, (double)(xx - fixedOffset), (double)pos.getY() + 0.8, (double)(zz + randomOffset), 0.0, 0.0, 0.0);
            world.addParticle((ParticleOptions)MobGrindingUtils.PARTICLE_FLUID_XP.get(), false, (double)(xx + fixedOffset), (double)pos.getY() + 0.8, (double)(zz + randomOffset), 0.0, 0.0, 0.0);
            world.addParticle((ParticleOptions)MobGrindingUtils.PARTICLE_FLUID_XP.get(), false, (double)(xx + randomOffset), (double)pos.getY() + 0.8, (double)(zz - fixedOffset), 0.0, 0.0, 0.0);
            world.addParticle((ParticleOptions)MobGrindingUtils.PARTICLE_FLUID_XP.get(), false, (double)(xx + randomOffset), (double)pos.getY() + 0.8, (double)(zz + fixedOffset), 0.0, 0.0, 0.0);
        }
    }
}

