/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.jei;

import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.client.jei.SolidifierCategory;
import mob_grinding_utils.recipe.SolidifyRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final ResourceLocation ID = new ResourceLocation("mob_grinding_utils", "jei_plugin");
    public static final RecipeType<SolidifyRecipe> SOLIDIFY_TYPE = RecipeType.create((String)"mob_grinding_utils", (String)"solidify", SolidifyRecipe.class);

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        ModItems.ITEMS.getEntries().forEach(item -> {
            String key = ((Item)item.get()).getDescriptionId() + ".jei.info";
            if (I18n.exists((String)key)) {
                registration.addIngredientInfo((Object)new ItemStack((ItemLike)item.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)key)});
            }
        });
        ClientLevel level = Minecraft.getInstance().level;
        registration.addRecipes(SOLIDIFY_TYPE, level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)MobGrindingUtils.SOLIDIFIER_TYPE.get()).stream().map(RecipeHolder::value).toList());
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new SolidifierCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.XPSOLIDIFIER.getItem()), new RecipeType[]{SOLIDIFY_TYPE});
    }
}

