/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.events;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class DirtSpawnEvent
extends Event {
    private final LevelAccessor world;
    private final double x;
    private final double y;
    private final double z;
    private final LivingEntity entityLiving;
    private final DirtType dirt;

    public DirtSpawnEvent(LevelAccessor world, double x, double y, double z, LivingEntity mob, DirtType type) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.entityLiving = mob;
        this.dirt = type;
    }

    public LevelAccessor getWorld() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public DirtType getDirt() {
        return this.dirt;
    }

    public LivingEntity getEntityLiving() {
        return this.entityLiving;
    }

    public static Event.Result checkEvent(Mob entity, LevelAccessor level, double x, double y, double z, DirtType type) {
        if (entity == null) {
            return Event.Result.DEFAULT;
        }
        DirtSpawnEvent event = new DirtSpawnEvent(level, x, y, z, (LivingEntity)entity, type);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getResult();
    }

    public static enum DirtType {
        DREADFUL,
        DELIGHTFUL;

    }
}

