/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.events;

import com.mojang.math.Axis;
import mob_grinding_utils.models.ChickenBodyModel;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Chicken;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;

public class RenderChickenSwell {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    @OnlyIn(value=Dist.CLIENT)
    public void renderChickenSwell(RenderLivingEvent.Post event) {
        if (event.getEntity() instanceof Chicken && event.getEntity().getPersistentData().contains("shouldExplode") && event.getRenderer().getModel() instanceof ChickenModel) {
            ModelPart tempPart = ChickenBodyModel.createBodyLayer().bakeRoot();
            ChickenBodyModel model = new ChickenBodyModel(tempPart);
            int count = event.getEntity().getPersistentData().getInt("countDown");
            float scale = (float)count * 0.04f;
            if (scale >= 0.75f) {
                scale = 0.75f;
            }
            event.getPoseStack().pushPose();
            event.getPoseStack().translate(0.0, -0.5 - (double)scale, 0.0);
            event.getPoseStack().mulPose(Axis.YN.rotationDegrees(event.getEntity().yBodyRot));
            event.getPoseStack().scale(1.0f + scale, 1.0f + scale, 1.0f + scale * 0.75f);
            model.renderToBuffer(event.getPoseStack(), event.getMultiBufferSource().getBuffer(RenderType.entitySolid((ResourceLocation)new ResourceLocation("textures/entity/chicken.png"))), event.getPackedLight(), OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
            event.getPoseStack().popPose();
        }
    }
}

