/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.inventory.client;

import mob_grinding_utils.inventory.client.GuiMGUButton;
import mob_grinding_utils.inventory.client.MGUScreen;
import mob_grinding_utils.inventory.client.TankGauge;
import mob_grinding_utils.inventory.server.ContainerAbsorptionHopper;
import mob_grinding_utils.network.BEGuiClick;
import mob_grinding_utils.tile.TileEntityAbsorptionHopper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public class GuiAbsorptionHopper
extends MGUScreen<ContainerAbsorptionHopper> {
    protected final ContainerAbsorptionHopper container;
    private final TileEntityAbsorptionHopper tile;
    private TankGauge tankGauge;

    public GuiAbsorptionHopper(ContainerAbsorptionHopper container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title, new ResourceLocation("mob_grinding_utils:textures/gui/absorption_hopper_gui.png"));
        this.container = container;
        this.tile = this.container.hopper;
        this.imageHeight = 226;
        this.imageWidth = 248;
    }

    public void init() {
        super.init();
        this.clearWidgets();
        this.tankGauge = new TankGauge(this.leftPos + 156, this.topPos + 8, 12, 120, this.tile.tank);
        this.addRenderableWidget((GuiEventListener)this.tankGauge);
        Button.OnPress message = button -> {
            if (button instanceof GuiMGUButton) {
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new BEGuiClick(this.tile.getBlockPos(), ((GuiMGUButton)button).id)});
            }
        };
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 7, this.topPos + 17, GuiMGUButton.Size.MEDIUM, 0, (Component)Component.literal((String)"Down"), message));
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 7, this.topPos + 34, GuiMGUButton.Size.MEDIUM, 1, (Component)Component.literal((String)"Up"), message));
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 7, this.topPos + 51, GuiMGUButton.Size.MEDIUM, 2, (Component)Component.literal((String)"North"), message));
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 82, this.topPos + 17, GuiMGUButton.Size.MEDIUM, 3, (Component)Component.literal((String)"South"), message));
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 82, this.topPos + 34, GuiMGUButton.Size.MEDIUM, 4, (Component)Component.literal((String)"West"), message));
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 82, this.topPos + 51, GuiMGUButton.Size.MEDIUM, 5, (Component)Component.literal((String)"East"), message));
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 173, this.topPos + 113, GuiMGUButton.Size.LARGE, 6, (Component)Component.empty(), button -> {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new BEGuiClick(this.tile.getBlockPos(), 6)});
            this.tile.showRenderBox = !this.tile.showRenderBox;
        }));
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 173, this.topPos + 25, GuiMGUButton.Size.SMALL, 7, (Component)Component.literal((String)"-"), message));
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 225, this.topPos + 25, GuiMGUButton.Size.SMALL, 8, (Component)Component.literal((String)"+"), message));
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 173, this.topPos + 59, GuiMGUButton.Size.SMALL, 9, (Component)Component.literal((String)"-"), message));
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 225, this.topPos + 59, GuiMGUButton.Size.SMALL, 10, (Component)Component.literal((String)"+"), message));
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 173, this.topPos + 93, GuiMGUButton.Size.SMALL, 11, (Component)Component.literal((String)"-"), message));
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 225, this.topPos + 93, GuiMGUButton.Size.SMALL, 12, (Component)Component.literal((String)"+"), message));
    }

    @Override
    protected void renderLabels(GuiGraphics gg, int mouseX, int mouseY) {
        gg.drawString(this.font, this.getTitle(), 8, 6, 0x404040, false);
        gg.drawString(this.font, Component.translatable((String)"block.mob_grinding_utils.absorption_hopper_d_u").getString(), 174, 14, 0x404040, false);
        gg.drawString(this.font, Component.translatable((String)"block.mob_grinding_utils.absorption_hopper_n_s").getString(), 174, 48, 0x404040, false);
        gg.drawString(this.font, Component.translatable((String)"block.mob_grinding_utils.absorption_hopper_w_e").getString(), 174, 82, 0x404040, false);
        gg.drawString(this.font, !this.tile.showRenderBox ? "Show Area" : "Hide Area", 207.0f - (float)this.font.width(!this.tile.showRenderBox ? "Show Area" : "Hide Area") / 2.0f, 117.0f, 0xE0E0E0, true);
        TileEntityAbsorptionHopper.EnumStatus DOWN = this.tile.getSideStatus(Direction.DOWN);
        TileEntityAbsorptionHopper.EnumStatus UP = this.tile.getSideStatus(Direction.UP);
        TileEntityAbsorptionHopper.EnumStatus NORTH = this.tile.getSideStatus(Direction.NORTH);
        TileEntityAbsorptionHopper.EnumStatus SOUTH = this.tile.getSideStatus(Direction.SOUTH);
        TileEntityAbsorptionHopper.EnumStatus WEST = this.tile.getSideStatus(Direction.WEST);
        TileEntityAbsorptionHopper.EnumStatus EAST = this.tile.getSideStatus(Direction.EAST);
        gg.drawCenteredString(this.font, DOWN.getSerializedName(), 58, 21, this.getModeColour(DOWN.ordinal()));
        gg.drawCenteredString(this.font, UP.getSerializedName(), 58, 38, this.getModeColour(UP.ordinal()));
        gg.drawCenteredString(this.font, NORTH.getSerializedName(), 58, 55, this.getModeColour(NORTH.ordinal()));
        gg.drawCenteredString(this.font, SOUTH.getSerializedName(), 133, 21, this.getModeColour(SOUTH.ordinal()));
        gg.drawCenteredString(this.font, WEST.getSerializedName(), 133, 38, this.getModeColour(WEST.ordinal()));
        gg.drawCenteredString(this.font, EAST.getSerializedName(), 133, 55, this.getModeColour(EAST.ordinal()));
        gg.drawCenteredString(this.font, String.valueOf(this.tile.getoffsetY()), 207, 29, 5285857);
        gg.drawCenteredString(this.font, String.valueOf(this.tile.getoffsetZ()), 207, 63, 5285857);
        gg.drawCenteredString(this.font, String.valueOf(this.tile.getoffsetX()), 207, 97, 5285857);
    }

    @Override
    protected void renderBg(GuiGraphics gg, float partialTicks, int mouseX, int mouseY) {
        gg.blit(this.TEX, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        gg.blit(this.TEX, this.leftPos + 153, this.topPos + 8, 248, 0, 6, 120);
    }

    public int getModeColour(int index) {
        return switch (index) {
            case 0 -> 0xFF0000;
            case 1 -> 5285857;
            case 2 -> 0xFFFF00;
            default -> 0xFFFF00;
        };
    }
}

