/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.inventory.client;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GuiMGUButton
extends Button {
    private static final ResourceLocation TEXTURES = new ResourceLocation("mob_grinding_utils:textures/gui/absorption_hopper_gui.png");
    private static final ResourceLocation SOLIDIFIER_TEXTURES = new ResourceLocation("mob_grinding_utils:textures/gui/solidifier_gui.png");
    public Size size;
    public int id;

    public GuiMGUButton(int x, int y, Size s, int idIn, Component title, Button.OnPress pressedAction) {
        super(x, y, s.width, s.height, title, pressedAction, DEFAULT_NARRATION);
        this.size = s;
        this.id = idIn;
    }

    public void renderWidget(@Nonnull GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        Font fontrenderer = mc.font;
        if (this.visible) {
            boolean hover;
            boolean bl = hover = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            if (hover) {
                gg.setColor(0.75f, 1.0f, 0.75f, 1.0f);
            } else {
                gg.setColor(0.75f, 0.75f, 0.75f, 0.5f);
            }
            gg.blit(this.getTextures(this.size), this.getX(), this.getY(), this.size.u, this.size.v, this.width, this.height);
            gg.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            int textColour = 0xE0E0E0;
            if (this.getFGColor() != 0) {
                textColour = this.getFGColor();
            } else if (!this.active) {
                textColour = 0xA0A0A0;
            } else if (this.isHoveredOrFocused()) {
                textColour = 0xFFFFA0;
            }
            gg.drawCenteredString(fontrenderer, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, textColour);
        }
    }

    public ResourceLocation getTextures(Size size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case Size.SMALL, Size.MEDIUM, Size.LARGE -> TEXTURES;
            case Size.SOLIDIFIER, Size.SOLIDIFIER_ON -> SOLIDIFIER_TEXTURES;
        };
    }

    static enum Size {
        SMALL(16, 16, 103, 228),
        MEDIUM(32, 16, 0, 228),
        LARGE(68, 16, 33, 228),
        SOLIDIFIER(34, 16, 178, 92),
        SOLIDIFIER_ON(20, 16, 178, 110);

        final int width;
        final int height;
        final int u;
        final int v;

        private Size(int w, int h, int U, int V) {
            this.width = w;
            this.height = h;
            this.u = U;
            this.v = V;
        }
    }
}

